/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.hadoop.io.Text;

abstract class TableMetadataServicer
extends MetadataServicer {
    private Instance instance;
    private Credentials credentials;
    private String tableIdBeingServiced;
    private String serviceTableName;

    public TableMetadataServicer(Instance instance, Credentials credentials, String serviceTableName, String tableIdBeingServiced) {
        this.instance = instance;
        this.credentials = credentials;
        this.serviceTableName = serviceTableName;
        this.tableIdBeingServiced = tableIdBeingServiced;
    }

    @Override
    public String getServicedTableId() {
        return this.tableIdBeingServiced;
    }

    public String getServicingTableName() {
        return this.serviceTableName;
    }

    @Override
    public void getTabletLocations(SortedMap<KeyExtent, String> tablets) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Scanner scanner = this.instance.getConnector(this.credentials.getPrincipal(), this.credentials.getToken()).createScanner(this.getServicingTableName(), Authorizations.EMPTY);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        scanner.setRange(MetadataSchema.TabletsSection.getRange(this.getServicedTableId()));
        Text colf = new Text();
        Text colq = new Text();
        KeyExtent currentKeyExtent = null;
        String location = null;
        Text row = null;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (row != null) {
                if (!row.equals((Object)entry.getKey().getRow())) {
                    currentKeyExtent = null;
                    location = null;
                    row = entry.getKey().getRow();
                }
            } else {
                row = entry.getKey().getRow();
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(colf = entry.getKey().getColumnFamily(colf), colq = entry.getKey().getColumnQualifier(colq))) {
                currentKeyExtent = new KeyExtent(entry.getKey().getRow(), entry.getValue());
                tablets.put(currentKeyExtent, location);
                currentKeyExtent = null;
                location = null;
                continue;
            }
            if (!colf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) continue;
            location = entry.getValue().toString();
        }
        this.validateEntries(tablets);
    }

    private void validateEntries(SortedMap<KeyExtent, String> tablets) throws AccumuloException {
        SortedSet tabletsKeys = (SortedSet)tablets.keySet();
        if (tabletsKeys.size() == 0) {
            throw new AccumuloException("No entries found in metadata table for table " + this.getServicedTableId());
        }
        if (((KeyExtent)tabletsKeys.first()).getPrevEndRow() != null) {
            throw new AccumuloException("Problem with metadata table, first entry for table " + this.getServicedTableId() + "- " + tabletsKeys.first() + " - has non null prev end row");
        }
        if (((KeyExtent)tabletsKeys.last()).getEndRow() != null) {
            throw new AccumuloException("Problem with metadata table, last entry for table " + this.getServicedTableId() + "- " + tabletsKeys.first() + " - has non null end row");
        }
        Iterator tabIter = tabletsKeys.iterator();
        Text lastEndRow = ((KeyExtent)tabIter.next()).getEndRow();
        while (tabIter.hasNext()) {
            KeyExtent tabke = (KeyExtent)tabIter.next();
            if (tabke.getPrevEndRow() == null) {
                throw new AccumuloException("Problem with metadata table, it has null prev end row in middle of table " + tabke);
            }
            if (!tabke.getPrevEndRow().equals((Object)lastEndRow)) {
                throw new AccumuloException("Problem with metadata table, it has a hole " + tabke.getPrevEndRow() + " != " + lastEndRow);
            }
            lastEndRow = tabke.getEndRow();
        }
    }
}

