/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Scanner;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.ShellOptionsJC;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.output.WriterOutputStream;

public class MockShell
extends Shell {
    private static final String NEWLINE = "\n";
    protected InputStream in;
    protected OutputStream out;
    @Deprecated
    protected Writer writer = null;

    public MockShell(InputStream in, OutputStream out) throws IOException {
        this.in = in;
        this.out = out;
    }

    @Deprecated
    public MockShell(InputStream in, Writer out) throws IOException {
        this(in, (OutputStream)new WriterOutputStream(out, Constants.UTF8.name()));
        this.writer = out;
    }

    @Override
    public boolean config(String ... args) {
        this.configError = super.config(args);
        try {
            this.reader = new ConsoleReader(this.in, this.out);
        }
        catch (Exception e) {
            this.printException(e);
            this.configError = true;
        }
        this.reader.setHistoryEnabled(false);
        this.reader.setPaginationEnabled(false);
        this.verbose = false;
        return this.configError;
    }

    @Override
    protected void setInstance(ShellOptionsJC options) {
        this.instance = new MockInstance();
    }

    @Deprecated
    protected void setInstance(CommandLine cl) {
        this.setInstance((ShellOptionsJC)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start() throws IOException {
        if (this.configError) {
            return 1;
        }
        if (this.isVerbose()) {
            this.printInfo();
        }
        if (this.execFile != null) {
            Scanner scanner = new Scanner(this.execFile, Constants.UTF8.name());
            try {
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
            finally {
                scanner.close();
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split(NEWLINE)) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (!this.hasExited()) {
            this.reader.setPrompt(this.getDefaultPrompt());
            String input = this.reader.readLine();
            if (input == null) {
                this.reader.println();
                return this.exitCode;
            }
            this.execCommand(input, false, false);
        }
        return this.exitCode;
    }

    public void setConsoleInputStream(InputStream in) {
        this.in = in;
    }

    public void setConsoleWriter(OutputStream out) {
        this.out = out;
    }

    @Deprecated
    public void setConsoleWriter(Writer out) {
        this.setConsoleWriter((OutputStream)new WriterOutputStream(out, Constants.UTF8.name()));
        this.writer = out;
    }

    public static ByteArrayInputStream makeCommands(String ... commands) {
        StringBuilder sb = new StringBuilder(commands.length * 8);
        for (String command : commands) {
            sb.append(command).append(NEWLINE);
        }
        return new ByteArrayInputStream(sb.toString().getBytes(Constants.UTF8));
    }
}

