/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractInputFormat<K, V>
implements InputFormat<K, V> {
    protected static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(JobConf job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, token);
    }

    public static void setConnectorInfo(JobConf job, String principal, String tokenFile) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobConf job) {
        return InputConfigurator.isConnectorInfoSet(CLASS, (Configuration)job);
    }

    protected static String getPrincipal(JobConf job) {
        return InputConfigurator.getPrincipal(CLASS, (Configuration)job);
    }

    @Deprecated
    protected static String getTokenClass(JobConf job) {
        return AbstractInputFormat.getAuthenticationToken(job).getClass().getName();
    }

    @Deprecated
    protected static byte[] getToken(JobConf job) {
        return AuthenticationToken.AuthenticationTokenSerializer.serialize(AbstractInputFormat.getAuthenticationToken(job));
    }

    protected static AuthenticationToken getAuthenticationToken(JobConf job) {
        return InputConfigurator.getAuthenticationToken(CLASS, (Configuration)job);
    }

    @Deprecated
    public static void setZooKeeperInstance(JobConf job, String instanceName, String zooKeepers) {
        AbstractInputFormat.setZooKeeperInstance(job, new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers));
    }

    public static void setZooKeeperInstance(JobConf job, ClientConfiguration clientConfig) {
        InputConfigurator.setZooKeeperInstance(CLASS, (Configuration)job, clientConfig);
    }

    public static void setMockInstance(JobConf job, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, (Configuration)job, instanceName);
    }

    protected static Instance getInstance(JobConf job) {
        return InputConfigurator.getInstance(CLASS, (Configuration)job);
    }

    public static void setLogLevel(JobConf job, Level level) {
        InputConfigurator.setLogLevel(CLASS, (Configuration)job, level);
    }

    protected static Level getLogLevel(JobConf job) {
        return InputConfigurator.getLogLevel(CLASS, (Configuration)job);
    }

    public static void setScanAuthorizations(JobConf job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, (Configuration)job, auths);
    }

    protected static Authorizations getScanAuthorizations(JobConf job) {
        return InputConfigurator.getScanAuthorizations(CLASS, (Configuration)job);
    }

    protected static TabletLocator getTabletLocator(JobConf job, String tableId) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, (Configuration)job, tableId);
    }

    protected static void validateOptions(JobConf job) throws IOException {
        InputConfigurator.validateOptions(CLASS, (Configuration)job);
    }

    public static Map<String, InputTableConfig> getInputTableConfigs(JobConf job) {
        return InputConfigurator.getInputTableConfigs(CLASS, (Configuration)job);
    }

    public static InputTableConfig getInputTableConfig(JobConf job, String tableName) {
        return InputConfigurator.getInputTableConfig(CLASS, (Configuration)job, tableName);
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobConf job, String tableId, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Instance instance = AbstractInputFormat.getInstance(job);
        Connector conn = instance.getConnector(AbstractInputFormat.getPrincipal(job), AbstractInputFormat.getAuthenticationToken(job));
        return InputConfigurator.binOffline(tableId, ranges, instance, conn);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Level logLevel = AbstractInputFormat.getLogLevel(job);
        log.setLevel(logLevel);
        AbstractInputFormat.validateOptions(job);
        Random random = new Random();
        LinkedList<RangeInputSplit> splits = new LinkedList<RangeInputSplit>();
        Map<String, InputTableConfig> tableConfigs = AbstractInputFormat.getInputTableConfigs(job);
        for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
            List<Range> ranges;
            boolean mockInstance;
            String tableId;
            String tableName = tableConfigEntry.getKey();
            InputTableConfig tableConfig = tableConfigEntry.getValue();
            Instance instance = AbstractInputFormat.getInstance(job);
            if (instance instanceof MockInstance) {
                tableId = "";
                mockInstance = true;
            } else {
                try {
                    tableId = Tables.getTableId(instance, tableName);
                }
                catch (TableNotFoundException e) {
                    throw new IOException(e);
                }
                mockInstance = false;
            }
            Authorizations auths = AbstractInputFormat.getScanAuthorizations(job);
            String principal = AbstractInputFormat.getPrincipal(job);
            AuthenticationToken token = AbstractInputFormat.getAuthenticationToken(job);
            boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
            List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
            if (ranges.isEmpty()) {
                ranges = new ArrayList<Range>(1);
                ranges.add(new Range());
            }
            Map<Object, Object> binnedRanges = new HashMap();
            try {
                if (tableConfig.isOfflineScan()) {
                    binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    while (binnedRanges == null) {
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    }
                } else {
                    TabletLocator tl = AbstractInputFormat.getTabletLocator(job, tableId);
                    tl.invalidateCache();
                    Credentials creds = new Credentials(AbstractInputFormat.getPrincipal(job), AbstractInputFormat.getAuthenticationToken(job));
                    while (!tl.binRanges(creds, ranges, binnedRanges).isEmpty()) {
                        if (!(instance instanceof MockInstance)) {
                            if (!Tables.exists(instance, tableId)) {
                                throw new TableDeletedException(tableId);
                            }
                            if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(instance, tableId);
                            }
                        }
                        binnedRanges.clear();
                        log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        tl.invalidateCache();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashMap<Range, ArrayList<String>> splitsToAdd = null;
            if (!autoAdjust) {
                splitsToAdd = new HashMap<Range, ArrayList<String>>();
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                String ip = ((String)entry.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getCanonicalHostName();
                    hostNameCache.put(ip, location);
                }
                for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                    Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                    for (Range r : (List)extentRanges.getValue()) {
                        if (autoAdjust) {
                            RangeInputSplit split = new RangeInputSplit(tableName, tableId, ke.clip(r), new String[]{location});
                            split.setOffline(tableConfig.isOfflineScan());
                            split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                            split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                            split.setMockInstance(mockInstance);
                            split.setFetchedColumns(tableConfig.getFetchedColumns());
                            split.setPrincipal(principal);
                            split.setToken(token);
                            split.setInstanceName(instance.getInstanceName());
                            split.setZooKeepers(instance.getZooKeepers());
                            split.setAuths(auths);
                            split.setIterators(tableConfig.getIterators());
                            split.setLogLevel(logLevel);
                            splits.add(split);
                            continue;
                        }
                        ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                        if (locations == null) {
                            locations = new ArrayList<String>(1);
                        }
                        locations.add(location);
                        splitsToAdd.put(r, locations);
                    }
                }
            }
            if (autoAdjust) continue;
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                RangeInputSplit split = new RangeInputSplit(tableName, tableId, (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                split.setOffline(tableConfig.isOfflineScan());
                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                split.setMockInstance(mockInstance);
                split.setFetchedColumns(tableConfig.getFetchedColumns());
                split.setPrincipal(principal);
                split.setToken(token);
                split.setInstanceName(instance.getInstanceName());
                split.setZooKeepers(instance.getZooKeepers());
                split.setAuths(auths);
                split.setIterators(tableConfig.getIterators());
                split.setLogLevel(logLevel);
                splits.add(split);
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    protected static abstract class AbstractRecordReader<K, V>
    implements RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected RangeInputSplit split;
        protected Key currentKey = null;

        protected AbstractRecordReader() {
        }

        protected abstract void setupIterators(JobConf var1, Scanner var2, String var3, RangeInputSplit var4);

        public void initialize(InputSplit inSplit, JobConf job) throws IOException {
            Scanner scanner;
            Collection<Pair<Text, Text>> columns;
            List<IteratorSetting> iterators;
            Boolean usesLocalIterators;
            Boolean isIsolated;
            Authorizations authorizations;
            AuthenticationToken token;
            String principal;
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.split.getRange()));
            Instance instance = this.split.getInstance();
            if (null == instance) {
                instance = AbstractInputFormat.getInstance(job);
            }
            if (null == (principal = this.split.getPrincipal())) {
                principal = AbstractInputFormat.getPrincipal(job);
            }
            if (null == (token = this.split.getToken())) {
                token = AbstractInputFormat.getAuthenticationToken(job);
            }
            if (null == (authorizations = this.split.getAuths())) {
                authorizations = AbstractInputFormat.getScanAuthorizations(job);
            }
            String table = this.split.getTableName();
            InputTableConfig tableConfig = AbstractInputFormat.getInputTableConfig(job, this.split.getTableName());
            Boolean isOffline = this.split.isOffline();
            if (null == isOffline) {
                isOffline = tableConfig.isOfflineScan();
            }
            if (null == (isIsolated = this.split.isIsolatedScan())) {
                isIsolated = tableConfig.shouldUseIsolatedScanners();
            }
            if (null == (usesLocalIterators = this.split.usesLocalIterators())) {
                usesLocalIterators = tableConfig.shouldUseLocalIterators();
            }
            if (null == (iterators = this.split.getIterators())) {
                iterators = tableConfig.getIterators();
            }
            if (null == (columns = this.split.getFetchedColumns())) {
                columns = tableConfig.getFetchedColumns();
            }
            try {
                log.debug((Object)("Creating connector with user: " + principal));
                log.debug((Object)("Creating scanner for table: " + table));
                log.debug((Object)("Authorizations are: " + authorizations));
                scanner = isOffline != false ? new OfflineScanner(instance, new Credentials(principal, token), this.split.getTableId(), authorizations) : (instance instanceof MockInstance ? instance.getConnector(principal, token).createScanner(this.split.getTableName(), authorizations) : new ScannerImpl(instance, new Credentials(principal, token), this.split.getTableId(), authorizations));
                if (isIsolated.booleanValue()) {
                    log.info((Object)"Creating isolated scanner");
                    scanner = new IsolatedScanner(scanner);
                }
                if (usesLocalIterators.booleanValue()) {
                    log.info((Object)"Using local iterators");
                    scanner = new ClientSideIteratorScanner(scanner);
                }
                this.setupIterators(job, scanner, this.split.getTableName(), this.split);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (Pair<Text, Text> c : columns) {
                if (c.getSecond() != null) {
                    log.debug((Object)("Fetching column " + c.getFirst() + ":" + c.getSecond()));
                    scanner.fetchColumn(c.getFirst(), c.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + c.getFirst()));
                scanner.fetchColumnFamily(c.getFirst());
            }
            scanner.setRange(this.split.getRange());
            this.numKeysRead = 0L;
            this.scannerIterator = scanner.iterator();
        }

        public void close() {
        }

        public long getPos() throws IOException {
            return this.numKeysRead;
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }
    }
}

