/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.net.HostAndPort;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.impl.ThriftTransportKey;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.SslConnectionParams;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftTransportPool {
    private static SecurityPermission TRANSPORT_POOL_PERMISSION = new SecurityPermission("transportPoolPermission");
    private static final Random random = new Random();
    private long killTime = 3000L;
    private Map<ThriftTransportKey, List<CachedConnection>> cache = new HashMap<ThriftTransportKey, List<CachedConnection>>();
    private Map<ThriftTransportKey, Long> errorCount = new HashMap<ThriftTransportKey, Long>();
    private Map<ThriftTransportKey, Long> errorTime = new HashMap<ThriftTransportKey, Long>();
    private Set<ThriftTransportKey> serversWarnedAbout = new HashSet<ThriftTransportKey>();
    private CountDownLatch closerExitLatch;
    private static final Logger log = Logger.getLogger(ThriftTransportPool.class);
    private static final Long ERROR_THRESHOLD = 20L;
    private static final int STUCK_THRESHOLD = 120000;
    private static ThriftTransportPool instance = new ThriftTransportPool();
    private static final AtomicBoolean daemonStarted = new AtomicBoolean(false);

    private ThriftTransportPool() {
    }

    public TTransport getTransportWithDefaultTimeout(HostAndPort addr, AccumuloConfiguration conf) throws TTransportException {
        return this.getTransport(String.format("%s:%d", addr.getHostText(), addr.getPort()), conf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT), SslConnectionParams.forClient(conf));
    }

    public TTransport getTransport(String location, long milliseconds, SslConnectionParams sslParams) throws TTransportException {
        return this.getTransport(new ThriftTransportKey(location, milliseconds, sslParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport getTransport(ThriftTransportKey cacheKey) throws TTransportException {
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            List<CachedConnection> ccl = this.getCache().get(cacheKey);
            if (ccl == null) {
                ccl = new LinkedList<CachedConnection>();
                this.getCache().put(cacheKey, ccl);
            }
            for (CachedConnection cachedConnection : ccl) {
                if (cachedConnection.isReserved()) continue;
                cachedConnection.setReserved(true);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Using existing connection to " + cacheKey.getLocation() + ":" + cacheKey.getPort()));
                }
                return cachedConnection.transport;
            }
        }
        return this.createNewTransport(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<String, TTransport> getAnyTransport(List<ThriftTransportKey> servers, boolean preferCachedConnection) throws TTransportException {
        servers = new ArrayList<ThriftTransportKey>(servers);
        if (preferCachedConnection) {
            HashSet<ThriftTransportKey> serversSet = new HashSet<ThriftTransportKey>(servers);
            ThriftTransportPool thriftTransportPool = this;
            synchronized (thriftTransportPool) {
                serversSet.retainAll(this.getCache().keySet());
                if (serversSet.size() > 0) {
                    ArrayList<ThriftTransportKey> cachedServers = new ArrayList<ThriftTransportKey>(serversSet);
                    Collections.shuffle(cachedServers, random);
                    for (ThriftTransportKey ttk : cachedServers) {
                        for (CachedConnection cachedConnection : this.getCache().get(ttk)) {
                            if (cachedConnection.isReserved()) continue;
                            cachedConnection.setReserved(true);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Using existing connection to " + ttk.getLocation() + ":" + ttk.getPort()));
                            }
                            return new Pair<String, TTransport>(ttk.getLocation() + ":" + ttk.getPort(), cachedConnection.transport);
                        }
                    }
                }
            }
        }
        for (int retryCount = 0; servers.size() > 0 && retryCount < 10; ++retryCount) {
            int index = random.nextInt(servers.size());
            ThriftTransportKey ttk = servers.get(index);
            if (!preferCachedConnection) {
                ThriftTransportPool i$ = this;
                synchronized (i$) {
                    List<CachedConnection> cachedConnList = this.getCache().get(ttk);
                    if (cachedConnList != null) {
                        for (CachedConnection cachedConnection : cachedConnList) {
                            if (cachedConnection.isReserved()) continue;
                            cachedConnection.setReserved(true);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Using existing connection to " + ttk.getLocation() + ":" + ttk.getPort() + " timeout " + ttk.getTimeout()));
                            }
                            return new Pair<String, TTransport>(ttk.getLocation() + ":" + ttk.getPort(), cachedConnection.transport);
                        }
                    }
                }
            }
            try {
                return new Pair<String, TTransport>(ttk.getLocation() + ":" + ttk.getPort(), this.createNewTransport(ttk));
            }
            catch (TTransportException tte) {
                log.debug((Object)("Failed to connect to " + servers.get(index)), (Throwable)tte);
                servers.remove(index);
                continue;
            }
        }
        throw new TTransportException("Failed to connect to a server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport createNewTransport(ThriftTransportKey cacheKey) throws TTransportException {
        TTransport transport = ThriftUtil.createClientTransport(HostAndPort.fromParts((String)cacheKey.getLocation(), (int)cacheKey.getPort()), (int)cacheKey.getTimeout(), cacheKey.getSslParams());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating new connection to connection to " + cacheKey.getLocation() + ":" + cacheKey.getPort()));
        }
        CachedTTransport tsc = new CachedTTransport(transport, cacheKey);
        CachedConnection cc = new CachedConnection(tsc);
        cc.setReserved(true);
        try {
            ThriftTransportPool thriftTransportPool = this;
            synchronized (thriftTransportPool) {
                List<CachedConnection> ccl = this.getCache().get(cacheKey);
                if (ccl == null) {
                    ccl = new LinkedList<CachedConnection>();
                    this.getCache().put(cacheKey, ccl);
                }
                ccl.add(cc);
            }
        }
        catch (TransportPoolShutdownException e) {
            cc.transport.close();
            throw e;
        }
        return cc.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTransport(TTransport tsc) {
        if (tsc == null) {
            return;
        }
        boolean existInCache = false;
        CachedTTransport ctsc = (CachedTTransport)tsc;
        ArrayList<CachedConnection> closeList = new ArrayList<CachedConnection>();
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            CachedConnection cachedConnection;
            List<CachedConnection> ccl = this.getCache().get(ctsc.getCacheKey());
            Iterator<CachedConnection> iterator = ccl.iterator();
            while (iterator.hasNext()) {
                cachedConnection = iterator.next();
                if (cachedConnection.transport != tsc) continue;
                if (ctsc.sawError) {
                    Long ecount;
                    closeList.add(cachedConnection);
                    iterator.remove();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Returned connection had error " + ctsc.getCacheKey()));
                    }
                    if ((ecount = this.errorCount.get(ctsc.getCacheKey())) == null) {
                        ecount = 0L;
                    }
                    Long l = ecount;
                    Long l2 = ecount = Long.valueOf(ecount + 1L);
                    this.errorCount.put(ctsc.getCacheKey(), ecount);
                    Long etime = this.errorTime.get(ctsc.getCacheKey());
                    if (etime == null) {
                        this.errorTime.put(ctsc.getCacheKey(), System.currentTimeMillis());
                    }
                    if (ecount >= ERROR_THRESHOLD && !this.serversWarnedAbout.contains(ctsc.getCacheKey())) {
                        log.warn((Object)("Server " + ctsc.getCacheKey() + " had " + ecount + " failures in a short time period, will not complain anymore "));
                        this.serversWarnedAbout.add(ctsc.getCacheKey());
                    }
                    cachedConnection.setReserved(false);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Returned connection " + ctsc.getCacheKey() + " ioCount : " + cachedConnection.transport.ioCount));
                    }
                    cachedConnection.lastReturnTime = System.currentTimeMillis();
                    cachedConnection.setReserved(false);
                }
                existInCache = true;
                break;
            }
            if (ctsc.sawError) {
                iterator = ccl.iterator();
                while (iterator.hasNext()) {
                    cachedConnection = iterator.next();
                    if (cachedConnection.isReserved()) continue;
                    closeList.add(cachedConnection);
                    iterator.remove();
                }
            }
        }
        for (CachedConnection cachedConnection : closeList) {
            try {
                cachedConnection.transport.close();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to close connection w/ errors", (Throwable)e);
            }
        }
        if (!existInCache) {
            log.warn((Object)"Returned tablet server connection to cache that did not come from cache");
            tsc.close();
        }
    }

    public synchronized void setIdleTime(long time) {
        this.killTime = time;
        log.debug((Object)("Set thrift transport pool idle time to " + time));
    }

    public static ThriftTransportPool getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TRANSPORT_POOL_PERMISSION);
        }
        if (daemonStarted.compareAndSet(false, true)) {
            CountDownLatch closerExitLatch = new CountDownLatch(1);
            new Daemon(new Closer(instance, closerExitLatch), "Thrift Connection Pool Checker").start();
            instance.setCloserExitLatch(closerExitLatch);
        }
        return instance;
    }

    private synchronized void setCloserExitLatch(CountDownLatch closerExitLatch) {
        this.closerExitLatch = closerExitLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ThriftTransportPool thriftTransportPool = this;
        synchronized (thriftTransportPool) {
            if (this.cache == null) {
                return;
            }
            for (List<CachedConnection> ccl : this.getCache().values()) {
                for (CachedConnection cc : ccl) {
                    try {
                        cc.transport.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)"Error closing transport during shutdown", (Throwable)e);
                    }
                }
            }
            this.cache = null;
        }
        try {
            this.closerExitLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<ThriftTransportKey, List<CachedConnection>> getCache() {
        if (this.cache == null) {
            throw new TransportPoolShutdownException();
        }
        return this.cache;
    }

    static class CachedTTransport
    extends TTransport {
        private ThriftTransportKey cacheKey;
        private TTransport wrappedTransport;
        private boolean sawError = false;
        private volatile String ioThreadName = null;
        private volatile long ioStartTime = 0L;
        private volatile boolean reserved = false;
        private String stuckThreadName = null;
        int ioCount = 0;
        int lastIoCount = -1;

        private void sawError(Exception e) {
            this.sawError = true;
        }

        final void setReserved(boolean reserved) {
            this.reserved = reserved;
            if (reserved) {
                this.ioThreadName = Thread.currentThread().getName();
                this.ioCount = 0;
                this.lastIoCount = -1;
            } else {
                if ((this.ioCount & 1) == 1) {
                    log.warn((Object)("Connection returned to thrift connection pool that may still be in use " + this.ioThreadName + " " + Thread.currentThread().getName()), (Throwable)new Exception());
                }
                this.ioCount = 0;
                this.lastIoCount = -1;
                this.ioThreadName = null;
            }
            this.checkForStuckIO(120000L);
        }

        final void checkForStuckIO(long threshold) {
            if ((this.ioCount & 1) == 1) {
                if (this.ioCount == this.lastIoCount) {
                    long delta = System.currentTimeMillis() - this.ioStartTime;
                    if (delta >= threshold && this.stuckThreadName == null) {
                        this.stuckThreadName = this.ioThreadName;
                        log.warn((Object)("Thread \"" + this.ioThreadName + "\" stuck on IO  to " + this.cacheKey + " for at least " + delta + " ms"));
                    }
                } else {
                    this.lastIoCount = this.ioCount;
                    this.ioStartTime = System.currentTimeMillis();
                    if (this.stuckThreadName != null) {
                        log.info((Object)("Thread \"" + this.stuckThreadName + "\" no longer stuck on IO  to " + this.cacheKey + " sawError = " + this.sawError));
                        this.stuckThreadName = null;
                    }
                }
            } else if (this.stuckThreadName != null) {
                log.info((Object)("Thread \"" + this.stuckThreadName + "\" no longer stuck on IO  to " + this.cacheKey + " sawError = " + this.sawError));
                this.stuckThreadName = null;
            }
        }

        public CachedTTransport(TTransport transport, ThriftTransportKey cacheKey2) {
            this.wrappedTransport = transport;
            this.cacheKey = cacheKey2;
        }

        public boolean isOpen() {
            return this.wrappedTransport.isOpen();
        }

        public void open() throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.open();
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int read(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.read(arg0, arg1, arg2);
                return n;
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public int readAll(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.readAll(arg0, arg1, arg2);
                return n;
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void write(byte[] arg0, int arg1, int arg2) throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.write(arg0, arg1, arg2);
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        public void write(byte[] arg0) throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.write(arg0);
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                ++this.ioCount;
                this.wrappedTransport.close();
            }
            finally {
                ++this.ioCount;
            }
        }

        public void flush() throws TTransportException {
            try {
                ++this.ioCount;
                this.wrappedTransport.flush();
            }
            catch (TTransportException tte) {
                this.sawError((Exception)((Object)tte));
                throw tte;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean peek() {
            try {
                ++this.ioCount;
                boolean bl = this.wrappedTransport.peek();
                return bl;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getBuffer() {
            try {
                ++this.ioCount;
                byte[] byArray = this.wrappedTransport.getBuffer();
                return byArray;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getBufferPosition() {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.getBufferPosition();
                return n;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getBytesRemainingInBuffer() {
            try {
                ++this.ioCount;
                int n = this.wrappedTransport.getBytesRemainingInBuffer();
                return n;
            }
            finally {
                ++this.ioCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeBuffer(int len) {
            try {
                ++this.ioCount;
                this.wrappedTransport.consumeBuffer(len);
            }
            finally {
                ++this.ioCount;
            }
        }

        public ThriftTransportKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static class Closer
    implements Runnable {
        final ThriftTransportPool pool;
        private CountDownLatch closerExitLatch;

        public Closer(ThriftTransportPool pool, CountDownLatch closerExitLatch) {
            this.pool = pool;
            this.closerExitLatch = closerExitLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConnections() {
            while (true) {
                ArrayList<CachedConnection> connectionsToClose = new ArrayList<CachedConnection>();
                ThriftTransportPool thriftTransportPool = this.pool;
                synchronized (thriftTransportPool) {
                    for (List ccl : this.pool.getCache().values()) {
                        Iterator iter = ccl.iterator();
                        while (iter.hasNext()) {
                            CachedConnection cachedConnection = (CachedConnection)iter.next();
                            if (cachedConnection.isReserved() || System.currentTimeMillis() - cachedConnection.lastReturnTime <= this.pool.killTime) continue;
                            connectionsToClose.add(cachedConnection);
                            iter.remove();
                        }
                    }
                    for (List ccl : this.pool.getCache().values()) {
                        for (CachedConnection cachedConnection : ccl) {
                            cachedConnection.transport.checkForStuckIO(120000L);
                        }
                    }
                    Iterator iter = this.pool.errorTime.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        long delta = System.currentTimeMillis() - (Long)entry.getValue();
                        if (delta < 120000L) continue;
                        this.pool.errorCount.remove(entry.getKey());
                        iter.remove();
                    }
                }
                for (CachedConnection cachedConnection : connectionsToClose) {
                    cachedConnection.transport.close();
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.closeConnections();
            }
            catch (TransportPoolShutdownException transportPoolShutdownException) {
            }
            finally {
                this.closerExitLatch.countDown();
            }
        }
    }

    public static class TransportPoolShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    private static class CachedConnection {
        CachedTTransport transport;
        long lastReturnTime;

        public CachedConnection(CachedTTransport t) {
            this.transport = t;
        }

        void setReserved(boolean reserved) {
            this.transport.setReserved(reserved);
        }

        boolean isReserved() {
            return this.transport.reserved;
        }
    }
}

