/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.log4j.Logger;

public class Tables {
    public static final String VALID_NAME_REGEX = "^(\\w+\\.)?(\\w+)$";
    public static final String VALID_ID_REGEX = "^([a-z0-9]+)$";
    public static final ArgumentChecker.Validator<String> VALID_NAME = new ArgumentChecker.Validator<String>(){

        @Override
        public boolean isValid(String tableName) {
            return tableName != null && tableName.matches(Tables.VALID_NAME_REGEX);
        }

        @Override
        public String invalidMessage(String tableName) {
            if (tableName == null) {
                return "Table name cannot be null";
            }
            return "Table names must only contain word characters (letters, digits, and underscores): " + tableName;
        }
    };
    public static final ArgumentChecker.Validator<String> VALID_ID = new ArgumentChecker.Validator<String>(){

        @Override
        public boolean isValid(String tableId) {
            return tableId != null && ("+r".equals(tableId) || "!0".equals(tableId) || tableId.matches(Tables.VALID_ID_REGEX));
        }

        @Override
        public String invalidMessage(String tableId) {
            if (tableId == null) {
                return "Table id cannot be null";
            }
            return "Table IDs are base-36 numbers, represented with lowercase alphanumeric digits: " + tableId;
        }
    };
    public static final ArgumentChecker.Validator<String> NOT_SYSTEM = new ArgumentChecker.Validator<String>(){

        @Override
        public boolean isValid(String tableName) {
            return !"accumulo".equals(Tables.qualify(tableName).getFirst());
        }

        @Override
        public String invalidMessage(String tableName) {
            return "Table cannot be in the accumulo namespace";
        }
    };
    public static final ArgumentChecker.Validator<String> NOT_ROOT = new ArgumentChecker.Validator<String>(){

        @Override
        public boolean isValid(String tableName) {
            return !"accumulo.root".equals(tableName);
        }

        @Override
        public String invalidMessage(String tableName) {
            return "Table cannot be the accumulo.root(Id: +r) table";
        }
    };
    public static final ArgumentChecker.Validator<String> NOT_ROOT_ID = new ArgumentChecker.Validator<String>(){

        @Override
        public boolean isValid(String tableId) {
            return !"+r".equals(tableId);
        }

        @Override
        public String invalidMessage(String tableId) {
            return "Table cannot be the accumulo.root(Id: +r) table";
        }
    };
    private static SecurityPermission TABLES_PERMISSION = new SecurityPermission("tablesPermission");
    private static AtomicLong cacheResetCount = new AtomicLong(0L);
    private static final Logger log = Logger.getLogger(Tables.class);

    private static ZooCache getZooCache(Instance instance) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLES_PERMISSION);
        }
        return ZooCache.getInstance((String)instance.getZooKeepers(), (int)instance.getZooKeepersSessionTimeOut());
    }

    private static SortedMap<String, String> getMap(Instance instance, boolean nameAsKey) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        TreeMap<String, String> tableMap = new TreeMap<String, String>();
        HashMap<String, String> namespaceIdToNameMap = new HashMap<String, String>();
        for (String tableId : tableIds) {
            String namespaceName;
            byte[] tableName;
            block7: {
                tableName = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/name");
                byte[] nId = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/namespace");
                namespaceName = "";
                if (nId == null) {
                    namespaceName = null;
                } else {
                    String namespaceId = new String(nId, Constants.UTF8);
                    if (!namespaceId.equals("+default")) {
                        try {
                            namespaceName = (String)namespaceIdToNameMap.get(namespaceId);
                            if (namespaceName != null) break block7;
                            namespaceName = Namespaces.getNamespaceName(instance, namespaceId);
                            namespaceIdToNameMap.put(namespaceId, namespaceName);
                        }
                        catch (NamespaceNotFoundException e) {
                            log.error((Object)("Table (" + tableId + ") contains reference to namespace (" + namespaceId + ") that doesn't exist"), (Throwable)e);
                            continue;
                        }
                    }
                }
            }
            if (tableName == null || namespaceName == null) continue;
            String tableNameStr = Tables.qualified(new String(tableName, Constants.UTF8), namespaceName);
            if (nameAsKey) {
                tableMap.put(tableNameStr, tableId);
                continue;
            }
            tableMap.put(tableId, tableNameStr);
        }
        return tableMap;
    }

    public static String getTableId(Instance instance, String tableName) throws TableNotFoundException {
        try {
            return Tables._getTableId(instance, tableName);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(tableName, e);
        }
    }

    public static String _getTableId(Instance instance, String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        String tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
        if (tableId == null) {
            Tables.clearCache(instance);
            tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
            if (tableId == null) {
                String namespace = Tables.qualify(tableName).getFirst();
                if (Namespaces.getNameToIdMap(instance).containsKey(namespace)) {
                    throw new TableNotFoundException(null, tableName, null);
                }
                throw new NamespaceNotFoundException(null, namespace, null);
            }
        }
        return tableId;
    }

    public static String getTableName(Instance instance, String tableId) throws TableNotFoundException {
        String tableName = (String)Tables.getIdToNameMap(instance).get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId, null, null);
        }
        return tableName;
    }

    public static SortedMap<String, String> getNameToIdMap(Instance instance) {
        return Tables.getMap(instance, true);
    }

    public static SortedMap<String, String> getIdToNameMap(Instance instance) {
        return Tables.getMap(instance, false);
    }

    public static boolean exists(Instance instance, String tableId) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        return tableIds.contains(tableId);
    }

    public static void clearCache(Instance instance) {
        cacheResetCount.incrementAndGet();
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/tables");
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/namespaces");
    }

    public static String getPrintableTableNameFromId(Map<String, String> tidToNameMap, String tableId) {
        String tableName = tidToNameMap.get(tableId);
        return tableName == null ? "(ID:" + tableId + ")" : tableName;
    }

    public static String getPrintableTableIdFromName(Map<String, String> nameToIdMap, String tableName) {
        String tableId = nameToIdMap.get(tableName);
        return tableId == null ? "(NAME:" + tableName + ")" : tableId;
    }

    public static String getPrintableTableInfoFromId(Instance instance, String tableId) {
        String tableName = null;
        try {
            tableName = Tables.getTableName(instance, tableId);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableName == null ? String.format("?(ID:%s)", tableId) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static String getPrintableTableInfoFromName(Instance instance, String tableName) {
        String tableId = null;
        try {
            tableId = Tables.getTableId(instance, tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableId == null ? String.format("%s(?)", tableName) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static TableState getTableState(Instance instance, String tableId) {
        String statePath = ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/state";
        ZooCache zc = Tables.getZooCache(instance);
        byte[] state = zc.get(statePath);
        if (state == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state, Constants.UTF8));
    }

    public static long getCacheResetCount() {
        return cacheResetCount.get();
    }

    public static String qualified(String tableName) {
        return Tables.qualified(tableName, "");
    }

    public static String qualified(String tableName, String defaultNamespace) {
        Pair<String, String> qualifiedTableName = Tables.qualify(tableName, defaultNamespace);
        if ("".equals(qualifiedTableName.getFirst())) {
            return qualifiedTableName.getSecond();
        }
        return qualifiedTableName.toString("", ".", "");
    }

    public static Pair<String, String> qualify(String tableName) {
        return Tables.qualify(tableName, "");
    }

    public static Pair<String, String> qualify(String tableName, String defaultNamespace) {
        if (!tableName.matches(VALID_NAME_REGEX)) {
            throw new IllegalArgumentException("Invalid table name '" + tableName + "'");
        }
        if ("!METADATA".equals(tableName)) {
            tableName = "accumulo.metadata";
        }
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.", 2);
            return new Pair<String, String>(s[0], s[1]);
        }
        return new Pair<String, String>(defaultNamespace, tableName);
    }

    public static String getNamespaceId(Instance instance, String tableId) throws IllegalArgumentException {
        ArgumentChecker.notNull(instance, tableId);
        ZooCache zc = Tables.getZooCache(instance);
        byte[] n = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/namespace");
        if (null == n) {
            throw new IllegalArgumentException("Table with id " + tableId + " does not exist");
        }
        return new String(n, Constants.UTF8);
    }
}

