/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge23;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge25Sasl
extends HadoopThriftAuthBridge23 {
    static final Log LOG = LogFactory.getLog(HadoopThriftAuthBridge25Sasl.class);

    @Override
    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new Server();
        }
        return new Server(keytabFile, principalConf);
    }

    @Override
    public Client createClientWithConf(String authType) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authType);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    @Override
    public Client createClient() {
        return new Client();
    }

    public static class Client
    extends HadoopThriftAuthBridge.Client {
        public static final String DIGEST = "DIGEST";
        public static final String MAPRSASL = "MAPRSASL";
        public static final String PAM = "PAM";
        public static final String LDAP = "LDAP";
        public static final String CUSTOM = "CUSTOM";
        public static final String EMPTY_STRING = "";

        @Override
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            TSaslClientTransport saslTransport = null;
            if (DIGEST.equals(methodStr)) {
                LOG.info("User authentication with method : " + methodStr);
                SaslRpcServer.AuthMethod method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr);
                Token t = new Token();
                t.decodeFromUrlString(tokenStrForm);
                saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, new HadoopThriftAuthBridge.Client.SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
                return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
            }
            Configuration conf = new Configuration();
            Configuration.addDefaultResource((String)"hive-site.xml");
            UserGroupInformation.AuthenticationMethod authenticationMethod = Client.findAuthenticationMethod(conf);
            RpcAuthMethod rpcAuthMethod = RpcAuthRegistry.getAuthMethod((UserGroupInformation.AuthenticationMethod)authenticationMethod);
            if (UserGroupInformation.AuthenticationMethod.KERBEROS.equals((Object)authenticationMethod)) {
                String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                if (names.length != 3) {
                    throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                }
                try {
                    saslTransport = new TSaslClientTransport(rpcAuthMethod.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                    return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
                }
                catch (SaslException se) {
                    throw new IOException("Could not instantiate SASL transport", se);
                }
            }
            try {
                saslTransport = new TSaslClientTransport(rpcAuthMethod.getMechanismName(), null, null, "default", saslProps, null, underlyingTransport);
                return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
            }
            catch (SaslException se) {
                throw new IOException("Could not instantiate SASL transport", se);
            }
        }

        private static UserGroupInformation.AuthenticationMethod findAuthenticationMethod(Configuration conf) throws IOException {
            UserGroupInformation.AuthenticationMethod authenticationMethod;
            String authTypeStr = conf.get("hive.server2.authentication");
            authTypeStr = authTypeStr == null ? EMPTY_STRING : authTypeStr.toUpperCase(Locale.ENGLISH);
            LOG.info("Hive is configured for user authentication: " + authTypeStr);
            Object[] authTypesAsCustom = new String[]{MAPRSASL, PAM, LDAP, EMPTY_STRING};
            if (ArrayUtils.contains(authTypesAsCustom, authTypeStr)) {
                authTypeStr = CUSTOM;
            }
            try {
                authenticationMethod = (UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.valueOf(UserGroupInformation.AuthenticationMethod.class, (String)authTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Unsupported authentication method: " + authTypeStr);
            }
            LOG.info("User authentication with method: " + authTypeStr);
            return authenticationMethod;
        }
    }

    public static class Server
    extends HadoopThriftAuthBridge.Server {
        public Server() throws TTransportException {
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            super(keytabFile, principalConf);
        }

        @Override
        public TTransportFactory createTransportFactory(Map<String, String> saslProps) throws TTransportException {
            List rpcAuthMethods = this.realUgi.getRpcAuthMethodList();
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            for (RpcAuthMethod rpcAuthMethod : rpcAuthMethods) {
                if (rpcAuthMethod.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                    String kerberosName = this.realUgi.getUserName();
                    String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
                    if (names.length != 3) continue;
                    transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), names[0], names[1], saslProps, rpcAuthMethod.createCallbackHandler());
                    continue;
                }
                transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), null, "default", saslProps, rpcAuthMethod.createCallbackHandler());
            }
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, new HadoopThriftAuthBridge.Server.SaslDigestCallbackHandler(this.secretManager));
            return new HadoopThriftAuthBridge.Server.TUGIAssumingTransportFactory(transFactory, this.realUgi);
        }
    }
}

