/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.hadoop.io.Text;

public class MetadataSchema {
    private static final String RESERVED_PREFIX = "~";

    public static class BlipSection {
        private static final Section section = new Section("~blip", true, "~bliq", false);

        public static Range getRange() {
            return section.range;
        }

        public static String getRowPrefix() {
            return section.rowPrefix;
        }
    }

    public static class DeletesSection {
        private static final Section section = new Section("~del", true, "~dem", false);

        public static Range getRange() {
            return section.range;
        }

        public static String getRowPrefix() {
            return section.rowPrefix;
        }
    }

    public static class ReservedSection {
        private static final Section section = new Section("~", true, null, false);

        public static Range getRange() {
            return section.range;
        }

        public static String getRowPrefix() {
            return section.rowPrefix;
        }
    }

    public static class TabletsSection {
        private static final Section section = new Section(null, false, "~", false);

        public static Range getRange() {
            return section.range;
        }

        public static Range getRange(String tableId) {
            return new Range(new Key(tableId + ';'), true, new Key(tableId + '<').followingKey(PartialKey.ROW), false);
        }

        public static Text getRow(Text tableId, Text endRow) {
            Text entry = new Text(tableId);
            if (endRow == null) {
                entry.append(new byte[]{60}, 0, 1);
            } else {
                entry.append(new byte[]{59}, 0, 1);
                entry.append(endRow.getBytes(), 0, endRow.getLength());
            }
            return entry;
        }

        public static class ChoppedColumnFamily {
            public static final Text NAME = new Text("chopped");
            public static final ColumnFQ CHOPPED_COLUMN = new ColumnFQ(NAME, new Text("chopped"));
        }

        public static class LogColumnFamily {
            public static final Text NAME = new Text("log");
        }

        public static class ScanFileColumnFamily {
            public static final Text NAME = new Text("scan");
        }

        public static class DataFileColumnFamily {
            public static final Text NAME = new Text("file");
        }

        public static class ClonedColumnFamily {
            public static final Text NAME = new Text("!cloned");
        }

        public static class BulkFileColumnFamily {
            public static final Text NAME = new Text("loaded");
        }

        public static class LastLocationColumnFamily {
            public static final Text NAME = new Text("last");
        }

        public static class FutureLocationColumnFamily {
            public static final Text NAME = new Text("future");
        }

        public static class CurrentLocationColumnFamily {
            public static final Text NAME = new Text("loc");
        }

        public static class ServerColumnFamily {
            public static final Text NAME = new Text("srv");
            public static final ColumnFQ DIRECTORY_COLUMN = new ColumnFQ(NAME, new Text("dir"));
            public static final ColumnFQ TIME_COLUMN = new ColumnFQ(NAME, new Text("time"));
            public static final ColumnFQ FLUSH_COLUMN = new ColumnFQ(NAME, new Text("flush"));
            public static final ColumnFQ COMPACT_COLUMN = new ColumnFQ(NAME, new Text("compact"));
            public static final ColumnFQ LOCK_COLUMN = new ColumnFQ(NAME, new Text("lock"));
        }

        public static class TabletColumnFamily {
            public static final Text NAME = new Text("~tab");
            public static final ColumnFQ PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("~pr"));
            public static final ColumnFQ OLD_PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("oldprevrow"));
            public static final ColumnFQ SPLIT_RATIO_COLUMN = new ColumnFQ(NAME, new Text("splitRatio"));
        }
    }

    private static class Section {
        private String rowPrefix;
        private Range range;

        private Section(String startRow, boolean startInclusive, String endRow, boolean endInclusive) {
            this.rowPrefix = startRow;
            this.range = new Range(startRow, startInclusive, endRow, endInclusive);
        }
    }
}

