/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.Interruptible;
import com.google.code.tempusfugit.concurrency.ThreadUtils;
import com.google.code.tempusfugit.temporal.Conditions;
import com.google.code.tempusfugit.temporal.Duration;
import com.google.code.tempusfugit.temporal.Timeout;
import com.google.code.tempusfugit.temporal.WaitFor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ExecutorServiceShutdown {
    private final ExecutorService executor;

    private ExecutorServiceShutdown(ExecutorService executor) {
        this.executor = executor;
    }

    public static ExecutorServiceShutdown shutdown(ExecutorService executor) {
        return new ExecutorServiceShutdown(executor);
    }

    public Boolean waitingForCompletion(Duration duration) {
        if (this.executor == null) {
            return false;
        }
        this.executor.shutdown();
        return ThreadUtils.resetInterruptFlagWhen(this.awaitingTerminationIsInterrupted(duration));
    }

    public Boolean waitingForShutdown(Timeout timeout) throws TimeoutException, InterruptedException {
        if (this.executor == null) {
            return false;
        }
        this.executor.shutdownNow();
        WaitFor.waitOrTimeout(Conditions.shutdown(this.executor), timeout);
        return true;
    }

    @Deprecated
    public Boolean waitingForShutdown(Duration timeout) throws TimeoutException, InterruptedException {
        return this.waitingForShutdown(Timeout.timeout(timeout));
    }

    private Interruptible<Boolean> awaitingTerminationIsInterrupted(final Duration timeout) {
        return new Interruptible<Boolean>(){

            @Override
            public Boolean call() throws InterruptedException {
                return ExecutorServiceShutdown.this.executor.awaitTermination(timeout.inMillis(), TimeUnit.MILLISECONDS);
            }
        };
    }
}

