/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.ExecuteException;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.JarDelegator;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class StreamingDelegator
extends LauncherDelegator {
    public StreamingDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, List<String> inputs, String inputreader, String output, String mapper, String reducer, String combiner, List<String> fileList, String files, List<String> defines, List<String> cmdenvs, List<String> jarArgs, String statusdir, String callback, String completedUrl, boolean enableLog, Boolean enableJobReconnect, LauncherDelegator.JobType jobType) throws NotAuthorizedException, BadParam, BusyException, QueueException, ExecuteException, IOException, InterruptedException {
        List<String> args = this.makeArgs(inputs, inputreader, output, mapper, reducer, combiner, fileList, cmdenvs, jarArgs);
        JarDelegator d = new JarDelegator(this.appConf);
        return d.run(user, userArgs, this.appConf.streamingJar(), null, null, files, args, defines, statusdir, callback, false, completedUrl, enableLog, enableJobReconnect, jobType);
    }

    private List<String> makeArgs(List<String> inputs, String inputreader, String output, String mapper, String reducer, String combiner, List<String> fileList, List<String> cmdenvs, List<String> jarArgs) throws BadParam {
        ArrayList<String> args = new ArrayList<String>();
        for (String input : inputs) {
            args.add("-input");
            args.add(input);
        }
        args.add("-output");
        args.add(output);
        args.add("-mapper");
        args.add(mapper);
        args.add("-reducer");
        args.add(reducer);
        if (inputreader != null && !inputreader.isEmpty()) {
            args.add("-inputreader");
            args.add(inputreader);
        }
        if (TempletonUtils.isset(combiner)) {
            args.add("-combiner");
            args.add(combiner);
        }
        for (String f : fileList) {
            args.add("-file");
            args.add(f);
        }
        for (String e : cmdenvs) {
            args.add("-cmdenv");
            args.add(TempletonUtils.quoteForWindows(e));
        }
        for (String arg : jarArgs) {
            args.add(TempletonUtils.quoteForWindows(arg));
        }
        return args;
    }
}

