/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class PigDelegator
extends LauncherDelegator {
    private static final Log LOG = LogFactory.getLog(PigDelegator.class);

    public PigDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, String execute, String srcFile, List<String> pigArgs, String otherFiles, String statusdir, String callback, boolean usesHcatalog, String completedUrl, boolean enablelog, Boolean enableJobReconnect) throws NotAuthorizedException, BadParam, BusyException, QueueException, ExecuteException, IOException, InterruptedException {
        this.runAs = user;
        List<String> args = this.makeArgs(execute, srcFile, pigArgs, otherFiles, statusdir, usesHcatalog, completedUrl, enablelog, enableJobReconnect);
        return this.enqueueController(user, userArgs, callback, args);
    }

    private List<String> makeArgs(String execute, String srcFile, List<String> pigArgs, String otherFiles, String statusdir, boolean usesHcatalog, String completedUrl, boolean enablelog, Boolean enableJobReconnect) throws BadParam, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        boolean needsMetastoreAccess = usesHcatalog || this.hasPigArgUseHcat(pigArgs);
        try {
            boolean shipHiveTar;
            ArrayList<String> allFiles = new ArrayList<String>();
            if (TempletonUtils.isset(srcFile)) {
                allFiles.add(TempletonUtils.hadoopFsFilename(srcFile, this.appConf, this.runAs));
            }
            if (TempletonUtils.isset(otherFiles)) {
                String[] ofs = TempletonUtils.hadoopFsListAsArray(otherFiles, this.appConf, this.runAs);
                allFiles.addAll(Arrays.asList(ofs));
            }
            args.addAll(this.makeLauncherArgs(this.appConf, statusdir, completedUrl, allFiles, enablelog, enableJobReconnect, LauncherDelegator.JobType.PIG));
            boolean shipPigTar = this.appConf.pigArchive() != null && !this.appConf.pigArchive().equals("");
            boolean bl = shipHiveTar = needsMetastoreAccess && this.appConf.hiveArchive() != null && !this.appConf.hiveArchive().equals("");
            if (shipPigTar || shipHiveTar) {
                args.add("-archives");
                StringBuilder archives = new StringBuilder();
                if (shipPigTar) {
                    archives.append(this.appConf.pigArchive());
                }
                if (shipPigTar && shipHiveTar) {
                    archives.append(",");
                }
                if (shipHiveTar) {
                    archives.append(this.appConf.hiveArchive());
                }
                args.add(archives.toString());
            }
            if (shipHiveTar) {
                PigDelegator.addDef(args, "HIVE_HOME", this.appConf.get("templeton.hive.home"));
                PigDelegator.addDef(args, "HCAT_HOME", this.appConf.get("templeton.hcat.home"));
                PigDelegator.addDef(args, "PIG_OPTS", this.appConf.get("templeton.hive.properties"));
            }
            args.add("--");
            TempletonUtils.addCmdForWindows(args);
            args.add(this.appConf.pigPath());
            args.add("-D__MR_JOB_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION__");
            args.add("-D__MR_JOB_TAGS_OPTION=MR_JOB_TAGS_JOBID__");
            for (String pigArg : pigArgs) {
                args.add(TempletonUtils.quoteForWindows(pigArg));
            }
            if (needsMetastoreAccess) {
                this.addHiveMetaStoreTokenArg();
            }
            if (TempletonUtils.isset(execute)) {
                args.add("-execute");
                args.add(TempletonUtils.quoteForWindows(execute));
            } else if (TempletonUtils.isset(srcFile)) {
                args.add("-file");
                args.add(TempletonUtils.hadoopFsPath(srcFile, this.appConf, this.runAs).getName());
            }
        }
        catch (FileNotFoundException e) {
            throw new BadParam(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BadParam(e.getMessage());
        }
        return args;
    }

    private boolean hasPigArgUseHcat(List<String> pigArgs) {
        return pigArgs.contains("-useHCatalog");
    }
}

