/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.Helper;
import org.apache.calcite.avatica.InternalProperty;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalcitePreparedStatement;
import org.apache.calcite.jdbc.CalciteRootSchema;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteStatement;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.BaseQueryable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.server.CalciteServer;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Holder;

abstract class CalciteConnectionImpl
extends AvaticaConnection
implements CalciteConnection,
QueryProvider {
    public final JavaTypeFactory typeFactory;
    final CalciteRootSchema rootSchema;
    final Function0<CalcitePrepare> prepareFactory;
    final CalciteServer server = new CalciteServerImpl();
    static final AvaticaConnection.Trojan TROJAN = CalciteConnectionImpl.createTrojan();

    protected CalciteConnectionImpl(Driver driver, AvaticaFactory factory, String url, Properties info, CalciteRootSchema rootSchema, JavaTypeFactory typeFactory) {
        super((UnregisteredDriver)driver, factory, url, info);
        CalciteConnectionConfigImpl cfg = new CalciteConnectionConfigImpl(info);
        this.prepareFactory = driver.prepareFactory;
        if (typeFactory != null) {
            this.typeFactory = typeFactory;
        } else {
            RelDataTypeSystem typeSystem = cfg.typeSystem(RelDataTypeSystem.class, RelDataTypeSystem.DEFAULT);
            this.typeFactory = new JavaTypeFactoryImpl(typeSystem);
        }
        this.rootSchema = rootSchema != null ? rootSchema : CalciteSchema.createRootSchema(true);
        this.properties.put(InternalProperty.CASE_SENSITIVE, cfg.caseSensitive());
        this.properties.put(InternalProperty.UNQUOTED_CASING, cfg.unquotedCasing());
        this.properties.put(InternalProperty.QUOTED_CASING, cfg.quotedCasing());
        this.properties.put(InternalProperty.QUOTING, cfg.quoting());
    }

    CalciteMetaImpl meta() {
        return (CalciteMetaImpl)this.meta;
    }

    @Override
    public CalciteConnectionConfig config() {
        return new CalciteConnectionConfigImpl(this.info);
    }

    void init() {
        MaterializationService service = MaterializationService.instance();
        for (CalciteSchema.LatticeEntry e : Schemas.getLatticeEntries(this.rootSchema)) {
            Lattice lattice = e.getLattice();
            for (Lattice.Tile tile : lattice.computeTiles()) {
                service.defineTile(lattice, tile.bitSet(), (List<Lattice.Measure>)tile.measures, e.schema, true, true);
            }
        }
    }

    public CalciteStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (CalciteStatement)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CalcitePreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            CalcitePrepare.CalciteSignature signature = this.parseQuery(sql, new ContextImpl(this), -1);
            return (CalcitePreparedStatement)this.factory.newPreparedStatement((AvaticaConnection)this, null, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", (Exception)e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> CalcitePrepare.CalciteSignature<T> parseQuery(String sql, CalcitePrepare.Context prepareContext, int maxRowCount) {
        CalcitePrepare.Dummy.push(prepareContext);
        try {
            CalcitePrepare prepare = (CalcitePrepare)this.prepareFactory.apply();
            CalcitePrepare.CalciteSignature calciteSignature = prepare.prepareSql(prepareContext, sql, null, (Type)((Object)Object[].class), maxRowCount);
            return calciteSignature;
        }
        finally {
            CalcitePrepare.Dummy.pop(prepareContext);
        }
    }

    @Override
    public SchemaPlus getRootSchema() {
        return this.rootSchema.plus();
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Properties getProperties() {
        return this.info;
    }

    public <T> Queryable<T> createQuery(Expression expression, Class<T> rowType) {
        return new CalciteQueryable(this, rowType, expression);
    }

    public <T> Queryable<T> createQuery(Expression expression, Type rowType) {
        return new CalciteQueryable(this, rowType, expression);
    }

    public <T> T execute(Expression expression, Type type) {
        return null;
    }

    public <T> T execute(Expression expression, Class<T> type) {
        return null;
    }

    public <T> Enumerator<T> executeQuery(Queryable<T> queryable) {
        try {
            CalciteStatement statement = (CalciteStatement)this.createStatement();
            CalcitePrepare.CalciteSignature<T> signature = statement.prepare(queryable);
            return this.enumerable(statement.handle, signature).enumerator();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Enumerable<T> enumerable(Meta.StatementHandle handle, CalcitePrepare.CalciteSignature<T> signature) throws SQLException {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AvaticaStatement statement = this.lookupStatement(handle);
        List parameterValues = TROJAN.getParameterValues(statement);
        for (Ord o : Ord.zip((List)parameterValues)) {
            map.put("?" + o.i, o.e);
        }
        map.putAll(signature.internalParameters);
        DataContext dataContext = this.createDataContext(map);
        return signature.enumerable(dataContext);
    }

    public DataContext createDataContext(Map<String, Object> parameterValues) {
        if (this.config().spark()) {
            return new SlimDataContext();
        }
        return new DataContextImpl(this, parameterValues);
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    static class CalciteServerStatementImpl
    implements CalciteServerStatement {
        private final CalciteConnectionImpl connection;

        public CalciteServerStatementImpl(CalciteConnectionImpl connection) {
            this.connection = (CalciteConnectionImpl)Preconditions.checkNotNull((Object)connection);
        }

        @Override
        public ContextImpl createPrepareContext() {
            return new ContextImpl(this.connection);
        }

        @Override
        public CalciteConnection getConnection() {
            return this.connection;
        }
    }

    private static class SlimDataContext
    implements DataContext,
    Serializable {
        private SlimDataContext() {
        }

        @Override
        public SchemaPlus getRootSchema() {
            return null;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return null;
        }

        @Override
        public Object get(String name) {
            return null;
        }
    }

    static class ContextImpl
    implements CalcitePrepare.Context {
        private final CalciteConnectionImpl connection;

        public ContextImpl(CalciteConnectionImpl connection) {
            this.connection = (CalciteConnectionImpl)Preconditions.checkNotNull((Object)connection);
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.connection.typeFactory;
        }

        @Override
        public CalciteRootSchema getRootSchema() {
            return this.connection.rootSchema;
        }

        @Override
        public List<String> getDefaultSchemaPath() {
            String schemaName = this.connection.getSchema();
            return schemaName == null ? ImmutableList.of() : ImmutableList.of((Object)schemaName);
        }

        @Override
        public CalciteConnectionConfig config() {
            return this.connection.config();
        }

        @Override
        public DataContext getDataContext() {
            return this.connection.createDataContext((Map<String, Object>)ImmutableMap.of());
        }

        @Override
        public CalcitePrepare.SparkHandler spark() {
            boolean enable = this.config().spark();
            return CalcitePrepare.Dummy.getSparkHandler(enable);
        }
    }

    static class DataContextImpl
    implements DataContext {
        private final ImmutableMap<Object, Object> map;
        private final CalciteSchema rootSchema;
        private final QueryProvider queryProvider;
        private final JavaTypeFactory typeFactory;

        DataContextImpl(CalciteConnectionImpl connection, Map<String, Object> parameters) {
            long localOffset;
            this.queryProvider = connection;
            this.typeFactory = connection.getTypeFactory();
            this.rootSchema = connection.rootSchema;
            Holder<Long> timeHolder = Holder.of(System.currentTimeMillis());
            Hook.CURRENT_TIME.run(timeHolder);
            long time = timeHolder.get();
            TimeZone timeZone = connection.getTimeZone();
            long currentOffset = localOffset = (long)timeZone.getOffset(time);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)time).put((Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)(time + currentOffset)).put((Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)(time + localOffset)).put((Object)DataContext.Variable.TIME_ZONE.camelName, (Object)timeZone);
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                Object e = entry.getValue();
                if (e == null) {
                    e = AvaticaParameter.DUMMY_VALUE;
                }
                builder.put((Object)entry.getKey(), e);
            }
            this.map = builder.build();
        }

        @Override
        public synchronized Object get(String name) {
            Object o = this.map.get((Object)name);
            if (o == AvaticaParameter.DUMMY_VALUE) {
                return null;
            }
            if (o == null && DataContext.Variable.SQL_ADVISOR.camelName.equals(name)) {
                return this.getSqlAdvisor();
            }
            return o;
        }

        private SqlAdvisor getSqlAdvisor() {
            CalciteConnectionImpl con = (CalciteConnectionImpl)this.queryProvider;
            String schemaName = con.getSchema();
            ImmutableList schemaPath = schemaName == null ? ImmutableList.of() : ImmutableList.of((Object)schemaName);
            SqlAdvisorValidator validator = new SqlAdvisorValidator(SqlStdOperatorTable.instance(), new CalciteCatalogReader(this.rootSchema, con.config().caseSensitive(), (List<String>)schemaPath, this.typeFactory), this.typeFactory, SqlConformance.DEFAULT);
            return new SqlAdvisor(validator);
        }

        @Override
        public SchemaPlus getRootSchema() {
            return this.rootSchema.plus();
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return this.queryProvider;
        }
    }

    static class RootSchema
    extends AbstractSchema {
        RootSchema() {
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        }
    }

    private static class CalciteServerImpl
    implements CalciteServer {
        final Map<Integer, CalciteServerStatement> statementMap = Maps.newHashMap();

        private CalciteServerImpl() {
        }

        @Override
        public void removeStatement(Meta.StatementHandle h) {
            this.statementMap.remove(h.id);
        }

        @Override
        public void addStatement(CalciteConnection connection, Meta.StatementHandle h) {
            CalciteConnectionImpl c = (CalciteConnectionImpl)connection;
            this.statementMap.put(h.id, new CalciteServerStatementImpl(c));
        }

        @Override
        public CalciteServerStatement getStatement(Meta.StatementHandle h) {
            return this.statementMap.get(h.id);
        }
    }

    static class CalciteQueryable<T>
    extends BaseQueryable<T> {
        public CalciteQueryable(CalciteConnection connection, Type elementType, Expression expression) {
            super((QueryProvider)connection, elementType, expression);
        }

        public CalciteConnection getConnection() {
            return (CalciteConnection)this.provider;
        }
    }
}

