/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.predicate.PrimitiveComparisonFilter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RecordReader;

public class HiveAccumuloRecordReader
implements RecordReader<Text, AccumuloHiveRow> {
    private RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> recordReader;
    private int iteratorCount;

    public HiveAccumuloRecordReader(RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> recordReader, int iteratorCount) {
        this.recordReader = recordReader;
        this.iteratorCount = iteratorCount;
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public Text createKey() {
        return new Text();
    }

    public AccumuloHiveRow createValue() {
        return new AccumuloHiveRow();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() throws IOException {
        return this.recordReader.getProgress();
    }

    public boolean next(Text rowKey, AccumuloHiveRow row) throws IOException {
        PeekingIterator iter;
        Text key = (Text)this.recordReader.createKey();
        if (this.recordReader.next((Object)key, (Object)(iter = (PeekingIterator)this.recordReader.createValue()))) {
            row.clear();
            row.setRowId(key.toString());
            ArrayList keys = Lists.newArrayList();
            ArrayList values = Lists.newArrayList();
            while (iter.hasNext()) {
                Map.Entry kv = (Map.Entry)iter.next();
                keys.add(kv.getKey());
                values.add(kv.getValue());
            }
            if (this.iteratorCount == 0) {
                this.pushToValue(keys, values, row);
            } else {
                for (int i = 0; i < this.iteratorCount; ++i) {
                    SortedMap decoded = PrimitiveComparisonFilter.decodeRow((Key)((Key)keys.get(0)), (Value)((Value)values.get(0)));
                    keys = Lists.newArrayList(decoded.keySet());
                    values = Lists.newArrayList(decoded.values());
                }
                this.pushToValue(keys, values, row);
            }
            return true;
        }
        return false;
    }

    private void pushToValue(List<Key> keys, List<Value> values, AccumuloHiveRow row) throws IOException {
        Iterator<Key> kIter = keys.iterator();
        Iterator<Value> vIter = values.iterator();
        while (kIter.hasNext()) {
            Key k = kIter.next();
            Value v = vIter.next();
            row.add(k.getColumnFamily().toString(), k.getColumnQualifier().toString(), v.get());
        }
    }
}

