/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.commons.codec.binary.Base64;

public class Authorizations
implements Iterable<byte[]>,
Serializable,
AuthorizationContainer {
    private static final long serialVersionUID = 1L;
    private Set<ByteSequence> auths = new HashSet<ByteSequence>();
    private List<byte[]> authsList = new ArrayList<byte[]>();
    public static final Authorizations EMPTY;
    private static final boolean[] validAuthChars;
    public static final String HEADER = "!AUTH1:";

    static final boolean isValidAuthChar(byte b) {
        return validAuthChars[0xFF & b];
    }

    private void checkAuths() {
        TreeSet<ByteSequence> sortedAuths = new TreeSet<ByteSequence>(this.auths);
        for (ByteSequence bs : sortedAuths) {
            if (bs.length() == 0) {
                throw new IllegalArgumentException("Empty authorization");
            }
            this.authsList.add(bs.toArray());
        }
    }

    public Authorizations(Collection<byte[]> authorizations) {
        ArgumentChecker.notNull(authorizations);
        for (byte[] auth : authorizations) {
            this.auths.add(new ArrayByteSequence(auth));
        }
        this.checkAuths();
    }

    public Authorizations(List<ByteBuffer> authorizations) {
        ArgumentChecker.notNull(authorizations);
        for (ByteBuffer buffer : authorizations) {
            this.auths.add(new ArrayByteSequence(ByteBufferUtil.toBytes(buffer)));
        }
        this.checkAuths();
    }

    public Authorizations(byte[] authorizations) {
        ArgumentChecker.notNull((Object)authorizations);
        String authsString = new String(authorizations, Constants.UTF8);
        if (authsString.startsWith(HEADER)) {
            if ((authsString = authsString.substring(HEADER.length())).length() > 0) {
                for (String encAuth : authsString.split(",")) {
                    byte[] auth = Base64.decodeBase64((byte[])encAuth.getBytes(Constants.UTF8));
                    this.auths.add(new ArrayByteSequence(auth));
                }
                this.checkAuths();
            }
        } else {
            ArgumentChecker.notNull((Object)authorizations);
            if (authorizations.length > 0) {
                this.setAuthorizations(authsString.split(","));
            }
        }
    }

    public Authorizations() {
    }

    public Authorizations(String ... authorizations) {
        this.setAuthorizations(authorizations);
    }

    private void setAuthorizations(String ... authorizations) {
        ArgumentChecker.notNull(authorizations);
        this.auths.clear();
        for (String str : authorizations) {
            str = str.trim();
            this.auths.add(new ArrayByteSequence(str.getBytes(Constants.UTF8)));
        }
        this.checkAuths();
    }

    public byte[] getAuthorizationsArray() {
        return this.serialize().getBytes(Constants.UTF8);
    }

    public List<byte[]> getAuthorizations() {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(bytes);
        }
        return Collections.unmodifiableList(copy);
    }

    public List<ByteBuffer> getAuthorizationsBB() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(ByteBuffer.wrap(bytes));
        }
        return Collections.unmodifiableList(copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (ByteSequence auth : this.auths) {
            sb.append(sep);
            sep = ",";
            sb.append(new String(auth.toArray(), Constants.UTF8));
        }
        return sb.toString();
    }

    public boolean contains(byte[] auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    @Override
    public boolean contains(ByteSequence auth) {
        return this.auths.contains(auth);
    }

    public boolean contains(String auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Authorizations) {
            Authorizations ao = (Authorizations)o;
            return ((Object)this.auths).equals(ao.auths);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (ByteSequence b : this.auths) {
            result += b.hashCode();
        }
        return result;
    }

    public int size() {
        return this.auths.size();
    }

    public boolean isEmpty() {
        return this.auths.isEmpty();
    }

    @Override
    public Iterator<byte[]> iterator() {
        return this.getAuthorizations().iterator();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder(HEADER);
        String sep = "";
        for (byte[] auth : this.authsList) {
            sb.append(sep);
            sep = ",";
            sb.append(new String(Base64.encodeBase64((byte[])auth), Constants.UTF8));
        }
        return sb.toString();
    }

    static {
        int i;
        EMPTY = new Authorizations();
        validAuthChars = new boolean[256];
        for (i = 0; i < 256; ++i) {
            Authorizations.validAuthChars[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        Authorizations.validAuthChars[95] = true;
        Authorizations.validAuthChars[45] = true;
        Authorizations.validAuthChars[58] = true;
        Authorizations.validAuthChars[46] = true;
        Authorizations.validAuthChars[47] = true;
    }
}

