/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.TabletServerBatchReader;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.Credentials;

public class TabletServerBatchDeleter
extends TabletServerBatchReader
implements BatchDeleter {
    private Instance instance;
    private Credentials credentials;
    private String tableId;
    private BatchWriterConfig bwConfig;

    public TabletServerBatchDeleter(Instance instance, Credentials credentials, String tableId, Authorizations authorizations, int numQueryThreads, BatchWriterConfig bwConfig) throws TableNotFoundException {
        super(instance, credentials, tableId, authorizations, numQueryThreads);
        this.instance = instance;
        this.credentials = credentials;
        this.tableId = tableId;
        this.bwConfig = bwConfig;
        super.addScanIterator(new IteratorSetting(Integer.MAX_VALUE, BatchDeleter.class.getName() + ".NOVALUE", SortedKeyIterator.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws MutationsRejectedException, TableNotFoundException {
        BatchWriter bw = null;
        try {
            bw = new BatchWriterImpl(this.instance, this.credentials, this.tableId, this.bwConfig);
            Iterator<Map.Entry<Key, Value>> iter = super.iterator();
            while (iter.hasNext()) {
                Map.Entry<Key, Value> next = iter.next();
                Key k = next.getKey();
                Mutation m = new Mutation(k.getRow());
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), k.getTimestamp());
                bw.addMutation(m);
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }
}

