/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;

public class ListDelegator
extends TempletonDelegator {
    public ListDelegator(AppConfig appConf) {
        super(appConf);
    }

    public List<String> run(String user, boolean showall) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        try (HadoopShims.WebHCatJTShim tracker = null;){
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            ArrayList<String> ids = new ArrayList<String>();
            JobStatus[] jobs = tracker.getAllJobs();
            if (jobs != null) {
                for (JobStatus job : jobs) {
                    String id = job.getJobID().toString();
                    if (!showall && !user.equals(job.getUsername())) continue;
                    ids.add(id);
                }
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
    }
}

