/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAccumuloHelper {
    private static final Logger log = LoggerFactory.getLogger(HiveAccumuloHelper.class);
    public static final Text ACCUMULO_SERVICE = new Text("ACCUMULO_AUTH_TOKEN");
    private static final String DELEGATION_TOKEN_CONFIG_CLASS_NAME = "org.apache.accumulo.core.client.admin.DelegationTokenConfig";
    private static final String DELEGATION_TOKEN_IMPL_CLASS_NAME = "org.apache.accumulo.core.client.impl.DelegationTokenImpl";
    private static final String GET_DELEGATION_TOKEN_METHOD_NAME = "getDelegationToken";
    private static final String GET_IDENTIFIER_METHOD_NAME = "getIdentifier";
    private static final String GET_PASSWORD_METHOD_NAME = "getPassword";
    private static final String GET_SERVICE_NAME_METHOD_NAME = "getServiceName";
    private static final String CLIENT_CONFIGURATION_CLASS_NAME = "org.apache.accumulo.core.client.ClientConfiguration";
    private static final String LOAD_DEFAULT_METHOD_NAME = "loadDefault";
    private static final String SET_PROPERTY_METHOD_NAME = "setProperty";
    private static final String INSTANCE_ZOOKEEPER_HOST = "instance.zookeeper.host";
    private static final String INSTANCE_NAME = "instance.name";
    private static final String INSTANCE_RPC_SASL_ENABLED = "instance.rpc.sasl.enabled";
    private static final String SET_ZOOKEEPER_INSTANCE_METHOD_NAME = "setZooKeeperInstance";
    private static final String CONFIGURATOR_BASE_CLASS_NAME = "org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase";
    private static final String UNWRAP_AUTHENTICATION_TOKEN_METHOD_NAME = "unwrapAuthenticationToken";

    public void addTokenFromUserToJobConf(UserGroupInformation user, JobConf jobConf) throws IOException {
        Preconditions.checkNotNull((Object)user, (Object)"Provided UGI was null");
        Preconditions.checkNotNull((Object)jobConf, (Object)"JobConf was null");
        Token accumuloToken = null;
        Collection tokens = user.getTokens();
        for (Token token : tokens) {
            if (!ACCUMULO_SERVICE.equals((Object)token.getKind())) continue;
            accumuloToken = token;
            break;
        }
        if (null == accumuloToken) {
            log.error("Could not find accumulo token in user: " + tokens);
            throw new IOException("Could not find Accumulo Token in user's tokens");
        }
        this.mergeTokenIntoJobConf(jobConf, accumuloToken);
    }

    public void mergeTokenIntoJobConf(JobConf jobConf, Token<?> accumuloToken) throws IOException {
        JobConf accumuloJobConf = new JobConf((Configuration)jobConf);
        accumuloJobConf.getCredentials().addToken(accumuloToken.getService(), accumuloToken);
        ShimLoader.getHadoopShims().mergeCredentials(jobConf, accumuloJobConf);
    }

    public AuthenticationToken getDelegationToken(Connector conn) throws IOException {
        try {
            Class clz = JavaUtils.loadClass((String)DELEGATION_TOKEN_CONFIG_CLASS_NAME);
            Object delegationTokenConfig = clz.newInstance();
            SecurityOperations secOps = conn.securityOperations();
            Method getDelegationTokenMethod = secOps.getClass().getMethod(GET_DELEGATION_TOKEN_METHOD_NAME, clz);
            return (AuthenticationToken)getDelegationTokenMethod.invoke((Object)secOps, delegationTokenConfig);
        }
        catch (Exception e) {
            throw new IOException("Failed to obtain DelegationToken from Accumulo", e);
        }
    }

    public Token<? extends TokenIdentifier> getHadoopToken(AuthenticationToken delegationToken) throws IOException {
        try {
            Class delegationTokenClass = JavaUtils.loadClass((String)DELEGATION_TOKEN_IMPL_CLASS_NAME);
            Method getIdentifierMethod = delegationTokenClass.getMethod(GET_IDENTIFIER_METHOD_NAME, new Class[0]);
            Method getPasswordMethod = delegationTokenClass.getMethod(GET_PASSWORD_METHOD_NAME, new Class[0]);
            Method getServiceNameMethod = delegationTokenClass.getMethod(GET_SERVICE_NAME_METHOD_NAME, new Class[0]);
            TokenIdentifier identifier = (TokenIdentifier)getIdentifierMethod.invoke((Object)delegationToken, new Object[0]);
            return new Token(identifier.getBytes(), (byte[])getPasswordMethod.invoke((Object)delegationToken, new Object[0]), identifier.getKind(), (Text)getServiceNameMethod.invoke((Object)delegationToken, new Object[0]));
        }
        catch (Exception e) {
            throw new IOException("Failed to create Hadoop token from Accumulo DelegationToken", e);
        }
    }

    public Object getClientConfiguration(String zookeepers, String instanceName, boolean useSasl) throws IOException {
        try {
            Class clientConfigClass = JavaUtils.loadClass((String)CLIENT_CONFIGURATION_CLASS_NAME);
            Method loadDefaultMethod = clientConfigClass.getMethod(LOAD_DEFAULT_METHOD_NAME, new Class[0]);
            Object clientConfig = loadDefaultMethod.invoke(null, new Object[0]);
            Method setPropertyMethod = clientConfigClass.getMethod(SET_PROPERTY_METHOD_NAME, String.class, Object.class);
            setPropertyMethod.invoke(clientConfig, INSTANCE_ZOOKEEPER_HOST, zookeepers);
            setPropertyMethod.invoke(clientConfig, INSTANCE_NAME, instanceName);
            if (useSasl) {
                setPropertyMethod.invoke(clientConfig, INSTANCE_RPC_SASL_ENABLED, true);
            }
            return clientConfig;
        }
        catch (Exception e) {
            String msg = "Failed to instantiate and invoke methods on ClientConfiguration";
            log.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    public void setZooKeeperInstance(JobConf jobConf, Class<?> inputOrOutputFormatClass, String zookeepers, String instanceName, boolean useSasl) throws IOException {
        try {
            Class clientConfigClass = JavaUtils.loadClass((String)CLIENT_CONFIGURATION_CLASS_NAME);
            Object clientConfig = this.getClientConfiguration(zookeepers, instanceName, useSasl);
            Method setZooKeeperMethod = inputOrOutputFormatClass.getMethod(SET_ZOOKEEPER_INSTANCE_METHOD_NAME, JobConf.class, clientConfigClass);
            setZooKeeperMethod.invoke(null, jobConf, clientConfig);
        }
        catch (Exception e) {
            throw new IOException("Failed to invoke setZooKeeperInstance method", e);
        }
    }

    public AuthenticationToken unwrapAuthenticationToken(JobConf jobConf, AuthenticationToken token) throws IOException {
        try {
            Class configuratorBaseClass = JavaUtils.loadClass((String)CONFIGURATOR_BASE_CLASS_NAME);
            Method unwrapAuthenticationTokenMethod = configuratorBaseClass.getMethod(UNWRAP_AUTHENTICATION_TOKEN_METHOD_NAME, JobConf.class, AuthenticationToken.class);
            return (AuthenticationToken)unwrapAuthenticationTokenMethod.invoke(null, jobConf, token);
        }
        catch (Exception e) {
            throw new IOException("Failed to unwrap AuthenticationToken", e);
        }
    }
}

