/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Charsets;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.log4j.Logger;

public class HiveAccumuloColumnMapping
extends ColumnMapping {
    private static final Logger log = Logger.getLogger(HiveAccumuloColumnMapping.class);
    protected String columnFamily;
    protected String columnQualifier;
    protected byte[] columnFamilyBytes;
    protected byte[] columnQualifierBytes;

    public HiveAccumuloColumnMapping(String cf, String cq, ColumnEncoding encoding, String columnName, String columnType) {
        super(cf + ':' + cq, encoding, columnName, columnType);
        this.columnFamily = cf;
        this.columnQualifier = cq;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getColumnFamilyBytes() {
        if (null == this.columnFamilyBytes) {
            this.columnFamilyBytes = this.columnFamily.getBytes(Charsets.UTF_8);
        }
        return this.columnFamilyBytes;
    }

    public String getColumnQualifier() {
        return this.columnQualifier;
    }

    public byte[] getColumnQualifierBytes() {
        if (null == this.columnQualifierBytes) {
            this.columnQualifierBytes = this.columnQualifier.getBytes(Charsets.UTF_8);
        }
        return this.columnQualifierBytes;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.columnFamily).append(':');
        if (null != this.columnQualifier) {
            sb.append(this.columnQualifier);
        }
        return sb.toString();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.columnFamily + ":" + this.columnQualifier + ", encoding " + (Object)((Object)this.encoding) + "]";
    }
}

