/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class EnumerableValues
extends Values
implements EnumerableRel {
    private EnumerableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
        super(cluster, rowType, tuples, traitSet);
    }

    public static EnumerableValues create(RelOptCluster cluster, final RelDataType rowType, final ImmutableList<ImmutableList<RexLiteral>> tuples) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            public List<RelCollation> get() {
                return RelMdCollation.values(rowType, (ImmutableList<ImmutableList<RexLiteral>>)tuples);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            public RelDistribution get() {
                return RelMdDistribution.values(rowType, (ImmutableList<ImmutableList<RexLiteral>>)tuples);
            }
        });
        return new EnumerableValues(cluster, rowType, tuples, traitSet);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return EnumerableValues.create(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferCustom());
        Type rowClass = physType.getJavaRowType();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        List<RelDataTypeField> fields = this.rowType.getFieldList();
        for (List tuple : this.tuples) {
            ArrayList<Expression> literals = new ArrayList<Expression>();
            for (Pair pair : Pair.zip(fields, tuple)) {
                literals.add(RexToLixTranslator.translateLiteral((RexLiteral)pair.right, ((RelDataTypeField)pair.left).getType(), typeFactory, RexImpTable.NullAs.NULL));
            }
            expressions.add(physType.record(literals));
        }
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)Primitive.box((Type)rowClass), expressions)})));
        return implementor.result(physType, builder.toBlock());
    }
}

