/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class OfflineCommand
extends TableOperation {
    private boolean wait;
    private Option waitOpt;

    @Override
    public String description() {
        return "starts the process of taking table offline";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (tableName.equals("accumulo.metadata")) {
            Shell.log.info((Object)"  You cannot take the accumulo.metadata offline.");
        } else {
            shellState.getConnector().tableOperations().offline(tableName, this.wait);
            Shell.log.info((Object)("Offline of table " + tableName + (this.wait ? " completed." : " initiated...")));
        }
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.wait = cl.hasOption(this.waitOpt.getLongOpt());
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.waitOpt = new Option("w", "wait", false, "wait for offline to finish");
        opts.addOption(this.waitOpt);
        return opts;
    }
}

