/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;

public final class Compression {
    static final Log LOG = LogFactory.getLog(Compression.class);
    public static final String COMPRESSION_SNAPPY = "snappy";
    public static final String COMPRESSION_GZ = "gz";
    public static final String COMPRESSION_LZO = "lzo";
    public static final String COMPRESSION_NONE = "none";

    private Compression() {
    }

    static Algorithm getCompressionAlgorithmByName(String compressName) {
        Algorithm[] algos;
        for (Algorithm a : algos = (Algorithm[])Algorithm.class.getEnumConstants()) {
            if (!a.getName().equals(compressName)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + compressName);
    }

    public static String[] getSupportedAlgorithms() {
        Algorithm[] algos = (Algorithm[])Algorithm.class.getEnumConstants();
        ArrayList<String> ret = new ArrayList<String>();
        for (Algorithm a : algos) {
            if (!a.isSupported()) continue;
            ret.add(a.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static enum Algorithm {
        LZO("lzo"){
            private transient boolean checked = false;
            private static final String defaultClazz = "org.apache.hadoop.io.compress.LzoCodec";
            private transient CompressionCodec codec = null;

            @Override
            public synchronized boolean isSupported() {
                if (!this.checked) {
                    this.checked = true;
                    String extClazz = conf.get(Algorithm.CONF_LZO_CLASS) == null ? System.getProperty(Algorithm.CONF_LZO_CLASS) : null;
                    String clazz = extClazz != null ? extClazz : defaultClazz;
                    try {
                        LOG.info((Object)("Trying to load Lzo codec class: " + clazz));
                        this.codec = (CompressionCodec)ReflectionUtils.newInstance(Class.forName(clazz), (Configuration)conf);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return this.codec != null;
            }

            @Override
            CompressionCodec getCodec() throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("LZO codec class not specified. Did you forget to set property io.compression.codec.lzo.class?");
                }
                return this.codec;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("LZO codec class not specified. Did you forget to set property io.compression.codec.lzo.class?");
                }
                InputStream bis1 = null;
                bis1 = downStreamBufferSize > 0 ? new BufferedInputStream(downStream, downStreamBufferSize) : downStream;
                conf.setInt("io.compression.codec.lzo.buffersize", 65536);
                CompressionInputStream cis = this.codec.createInputStream(bis1, decompressor);
                BufferedInputStream bis2 = new BufferedInputStream((InputStream)cis, 1024);
                return bis2;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("LZO codec class not specified. Did you forget to set property io.compression.codec.lzo.class?");
                }
                OutputStream bos1 = null;
                bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
                conf.setInt("io.compression.codec.lzo.buffersize", 65536);
                CompressionOutputStream cos = this.codec.createOutputStream(bos1, compressor);
                BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
                return bos2;
            }
        }
        ,
        GZ("gz"){
            private transient DefaultCodec codec;

            @Override
            synchronized CompressionCodec getCodec() {
                if (this.codec == null) {
                    this.codec = new DefaultCodec();
                    this.codec.setConf(conf);
                }
                return this.codec;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    this.codec.getConf().setInt("io.file.buffer.size", downStreamBufferSize);
                }
                CompressionInputStream cis = this.codec.createInputStream(downStream, decompressor);
                BufferedInputStream bis2 = new BufferedInputStream((InputStream)cis, 1024);
                return bis2;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                OutputStream bos1 = null;
                bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
                this.codec.getConf().setInt("io.file.buffer.size", 32768);
                CompressionOutputStream cos = this.codec.createOutputStream(bos1, compressor);
                BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
                return bos2;
            }

            @Override
            public boolean isSupported() {
                return true;
            }
        }
        ,
        NONE("none"){

            @Override
            CompressionCodec getCodec() {
                return null;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedInputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedOutputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public boolean isSupported() {
                return true;
            }
        }
        ,
        SNAPPY("snappy"){
            private transient CompressionCodec snappyCodec = null;
            private transient boolean checked = false;
            private static final String defaultClazz = "org.apache.hadoop.io.compress.SnappyCodec";

            @Override
            public CompressionCodec getCodec() throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("SNAPPY codec class not specified. Did you forget to set property io.compression.codec.snappy.class?");
                }
                return this.snappyCodec;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("SNAPPY codec class not specified. Did you forget to set property io.compression.codec.snappy.class?");
                }
                OutputStream bos1 = null;
                bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
                conf.setInt("io.compression.codec.snappy.buffersize", 65536);
                CompressionOutputStream cos = this.snappyCodec.createOutputStream(bos1, compressor);
                BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
                return bos2;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("SNAPPY codec class not specified. Did you forget to set property io.compression.codec.snappy.class?");
                }
                if (downStreamBufferSize > 0) {
                    conf.setInt("io.file.buffer.size", downStreamBufferSize);
                }
                CompressionInputStream cis = this.snappyCodec.createInputStream(downStream, decompressor);
                BufferedInputStream bis2 = new BufferedInputStream((InputStream)cis, 1024);
                return bis2;
            }

            @Override
            public synchronized boolean isSupported() {
                if (!this.checked) {
                    this.checked = true;
                    String extClazz = conf.get(Algorithm.CONF_SNAPPY_CLASS) == null ? System.getProperty(Algorithm.CONF_SNAPPY_CLASS) : null;
                    String clazz = extClazz != null ? extClazz : defaultClazz;
                    try {
                        LOG.info((Object)("Trying to load snappy codec class: " + clazz));
                        this.snappyCodec = (CompressionCodec)ReflectionUtils.newInstance(Class.forName(clazz), (Configuration)conf);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return this.snappyCodec != null;
            }
        };

        protected static final Configuration conf;
        private final String compressName;
        private static final int DATA_IBUF_SIZE = 1024;
        private static final int DATA_OBUF_SIZE = 4096;
        public static final String CONF_LZO_CLASS = "io.compression.codec.lzo.class";
        public static final String CONF_SNAPPY_CLASS = "io.compression.codec.snappy.class";

        private Algorithm(String name) {
            this.compressName = name;
        }

        abstract CompressionCodec getCodec() throws IOException;

        public abstract InputStream createDecompressionStream(InputStream var1, Decompressor var2, int var3) throws IOException;

        public abstract OutputStream createCompressionStream(OutputStream var1, Compressor var2, int var3) throws IOException;

        public abstract boolean isSupported();

        public Compressor getCompressor() throws IOException {
            CompressionCodec codec = this.getCodec();
            if (codec != null) {
                Compressor compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (compressor != null) {
                    if (compressor.finished()) {
                        LOG.warn((Object)"Compressor obtained from CodecPool already finished()");
                    } else {
                        LOG.debug((Object)("Got a compressor: " + compressor.hashCode()));
                    }
                    compressor.reset();
                }
                return compressor;
            }
            return null;
        }

        public void returnCompressor(Compressor compressor) {
            if (compressor != null) {
                LOG.debug((Object)("Return a compressor: " + compressor.hashCode()));
                CodecPool.returnCompressor((Compressor)compressor);
            }
        }

        public Decompressor getDecompressor() throws IOException {
            CompressionCodec codec = this.getCodec();
            if (codec != null) {
                Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (decompressor != null) {
                    if (decompressor.finished()) {
                        LOG.warn((Object)"Decompressor obtained from CodecPool already finished()");
                    } else {
                        LOG.debug((Object)("Got a decompressor: " + decompressor.hashCode()));
                    }
                    decompressor.reset();
                }
                return decompressor;
            }
            return null;
        }

        public void returnDecompressor(Decompressor decompressor) {
            if (decompressor != null) {
                LOG.debug((Object)("Returned a decompressor: " + decompressor.hashCode()));
                CodecPool.returnDecompressor((Decompressor)decompressor);
            }
        }

        public String getName() {
            return this.compressName;
        }

        static {
            conf = new Configuration();
        }
    }

    static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        public FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super((OutputStream)cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

