/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.ByteBufferUtil;

public class KeyValue
implements Map.Entry<Key, Value> {
    public Key key;
    public byte[] value;

    public KeyValue(Key key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    public KeyValue(Key key, ByteBuffer value) {
        this.key = key;
        this.value = ByteBufferUtil.toBytes(value);
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Value getValue() {
        return new Value(this.value);
    }

    @Override
    public Value setValue(Value value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.key + " " + new String(this.value, Constants.UTF8);
    }
}

