/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.counters;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;

public class QueryFragmentCounters
implements LowLevelCacheCounters {
    private final boolean doUseTimeCounters;
    private final AtomicLongArray fixedCounters = new AtomicLongArray(Counter.values().length);
    private final Object[] descs = new Object[Desc.values().length];

    public QueryFragmentCounters(Configuration conf) {
        this.doUseTimeCounters = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ORC_ENABLE_TIME_COUNTERS);
        if (!this.doUseTimeCounters) {
            this.setCounter(Counter.TOTAL_IO_TIME_US, -1L);
            this.setCounter(Counter.DECODE_TIME_US, -1L);
            this.setCounter(Counter.HDFS_TIME_US, -1L);
            this.setCounter(Counter.CONSUMER_TIME_US, -1L);
        }
    }

    public void incrCounter(Counter counter) {
        this.incrCounter(counter, 1L);
    }

    public void incrCounter(Counter counter, long delta) {
        this.fixedCounters.addAndGet(counter.ordinal(), delta);
    }

    @Override
    public final long startTimeCounter() {
        return this.doUseTimeCounters ? System.nanoTime() : 0L;
    }

    public void incrTimeCounter(Counter counter, long startTime) {
        if (!this.doUseTimeCounters) {
            return;
        }
        this.fixedCounters.addAndGet(counter.ordinal(), System.nanoTime() - startTime);
    }

    public void setCounter(Counter counter, long value) {
        this.fixedCounters.set(counter.ordinal(), value);
    }

    public void setDesc(Desc key, Object desc) {
        this.descs[key.ordinal()] = desc;
    }

    @Override
    public void recordCacheHit(long bytesHit) {
        this.incrCounter(Counter.CACHE_HIT_BYTES, bytesHit);
    }

    @Override
    public void recordCacheMiss(long bytesMissed) {
        this.incrCounter(Counter.CACHE_MISS_BYTES, bytesMissed);
    }

    @Override
    public void recordAllocBytes(long bytesUsed, long bytesAllocated) {
        this.incrCounter(Counter.ALLOCATED_USED_BYTES, bytesUsed);
        this.incrCounter(Counter.ALLOCATED_BYTES, bytesAllocated);
    }

    @Override
    public void recordHdfsTime(long startTime) {
        this.incrTimeCounter(Counter.HDFS_TIME_US, startTime);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Fragment counters for [");
        for (i = 0; i < this.descs.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.descs[i] == null) continue;
            sb.append(this.descs[i]);
        }
        sb.append("]: [ ");
        for (i = 0; i < this.fixedCounters.length(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(Counter.values()[i].name()).append("=").append(this.fixedCounters.get(i));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static enum Desc {
        MACHINE,
        TABLE,
        FILE,
        STRIPES;

    }

    public static enum Counter {
        NUM_VECTOR_BATCHES,
        NUM_DECODED_BATCHES,
        SELECTED_ROWGROUPS,
        NUM_ERRORS,
        ROWS_EMITTED,
        METADATA_CACHE_HIT,
        METADATA_CACHE_MISS,
        CACHE_HIT_BYTES,
        CACHE_MISS_BYTES,
        ALLOCATED_BYTES,
        ALLOCATED_USED_BYTES,
        TOTAL_IO_TIME_US,
        DECODE_TIME_US,
        HDFS_TIME_US,
        CONSUMER_TIME_US;

    }
}

