/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.common.CompressionUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapOptionsProcessor;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapServiceDriver {
    protected static final Logger LOG = LoggerFactory.getLogger((String)LlapServiceDriver.class.getName());
    private static final String[] DEFAULT_AUX_CLASSES = new String[]{"org.apache.hive.hcatalog.data.JsonSerDe"};
    private static final String HBASE_SERDE_CLASS = "org.apache.hadoop.hive.hbase.HBaseSerDe";
    private static final String[] NEEDED_CONFIGS = new String[]{"tez-site.xml", "hive-site.xml", "llap-daemon-site.xml", "core-site.xml"};
    private static final String[] OPTIONAL_CONFIGS = new String[]{"ssl-server.xml"};
    private final Configuration conf;

    public LlapServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            new LlapServiceDriver().run(args);
        }
        catch (Throwable t) {
            System.err.println("Failed: " + t.getMessage());
            t.printStackTrace();
            ret = 3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    public static Configuration resolve(Configuration configured, String first, String ... resources) {
        Configuration defaults = new Configuration(false);
        defaults.addResource(first);
        for (String resource : resources) {
            defaults.addResource(resource);
        }
        Configuration slice = new Configuration(false);
        for (Map.Entry kv : defaults) {
            slice.set((String)kv.getKey(), configured.get((String)kv.getKey()));
        }
        return slice;
    }

    private void run(String[] args) throws Exception {
        String auxJars;
        LlapOptionsProcessor optionsProcessor = new LlapOptionsProcessor();
        LlapOptionsProcessor.LlapOptions options = optionsProcessor.processOptions(args);
        if (options == null) {
            return;
        }
        Path tmpDir = new Path(options.getDirectory());
        if (this.conf == null) {
            throw new Exception("Cannot load any configuration to run command");
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileSystem lfs = FileSystem.getLocal((Configuration)this.conf).getRawFileSystem();
        for (String f : NEEDED_CONFIGS) {
            this.conf.addResource(f);
            if (this.conf.getResource(f) != null) continue;
            throw new Exception("Unable to find required config file: " + f);
        }
        for (String f : OPTIONAL_CONFIGS) {
            this.conf.addResource(f);
        }
        this.conf.reloadConfiguration();
        if (options.getName() != null) {
            this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + options.getName());
        }
        if (options.getSize() != -1L) {
            if (options.getCache() != -1L) {
                Preconditions.checkArgument((options.getCache() < options.getSize() ? 1 : 0) != 0, (Object)"Cache has to be smaller than the container sizing");
            }
            if (options.getXmx() != -1L) {
                Preconditions.checkArgument((options.getXmx() < options.getSize() ? 1 : 0) != 0, (Object)"Working memory has to be smaller than the container sizing");
            }
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT)) {
                Preconditions.checkArgument((options.getXmx() + options.getCache() < options.getSize() ? 1 : 0) != 0, (Object)"Working memory + cache has to be smaller than the containing sizing ");
            }
        }
        long minAlloc = this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1);
        if (options.getSize() != -1L) {
            long containerSize = options.getSize() / 0x100000L;
            Preconditions.checkArgument((containerSize >= minAlloc ? 1 : 0) != 0, (String)"Container size should be greater than minimum allocation(%s)", (Object[])new Object[]{minAlloc + "m"});
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, containerSize);
        }
        if (options.getExecutors() != -1) {
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, (long)options.getExecutors());
        }
        if (options.getCache() != -1L) {
            this.conf.set(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, Long.toString(options.getCache()));
        }
        if (options.getXmx() != -1L) {
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, options.getXmx() / 0x100000L);
        }
        for (Map.Entry<Object, Object> props : options.getConfig().entrySet()) {
            this.conf.set((String)props.getKey(), (String)props.getValue());
        }
        URL logger = this.conf.getResource("llap-daemon-log4j2.properties");
        if (null == logger) {
            throw new Exception("Unable to find required config file: llap-daemon-log4j2.properties");
        }
        Path home = new Path(System.getenv("HIVE_HOME"));
        Path scripts = new Path(new Path(new Path(home, "scripts"), "llap"), "bin");
        if (!lfs.exists(home)) {
            throw new Exception("Unable to find HIVE_HOME:" + home);
        }
        if (!lfs.exists(scripts)) {
            LOG.warn("Unable to find llap scripts:" + scripts);
        }
        Path libDir = new Path(tmpDir, "lib");
        String tezLibs = this.conf.get("tez.lib.uris");
        if (tezLibs == null) {
            LOG.warn("Missing tez.lib.uris in tez-site.xml");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying tez libs from " + tezLibs);
        }
        lfs.mkdirs(libDir);
        fs.copyToLocalFile(new Path(tezLibs), new Path(libDir, "tez.tar.gz"));
        CompressionUtils.unTar((String)new Path(libDir, "tez.tar.gz").toString(), (String)libDir.toString(), (boolean)true);
        lfs.delete(new Path(libDir, "tez.tar.gz"), false);
        lfs.copyFromLocalFile(new Path(Utilities.jarFinderGetJar(LlapDaemonProtocolProtos.class)), libDir);
        lfs.copyFromLocalFile(new Path(Utilities.jarFinderGetJar(LlapTezUtils.class)), libDir);
        lfs.copyFromLocalFile(new Path(Utilities.jarFinderGetJar(LlapInputFormat.class)), libDir);
        lfs.copyFromLocalFile(new Path(Utilities.jarFinderGetJar(HiveInputFormat.class)), libDir);
        for (String className : DEFAULT_AUX_CLASSES) {
            this.localizeJarForClass(lfs, libDir, className, false);
        }
        if (options.getIsHBase()) {
            try {
                this.localizeJarForClass(lfs, libDir, HBASE_SERDE_CLASS, true);
                Job fakeJob = new Job((Configuration)new JobConf());
                TableMapReduceUtil.addDependencyJars((Job)fakeJob);
                Collection hbaseJars = fakeJob.getConfiguration().getStringCollection("tmpjars");
                for (String jarPath : hbaseJars) {
                    if (jarPath.isEmpty()) continue;
                    lfs.copyFromLocalFile(new Path(jarPath), libDir);
                }
            }
            catch (Throwable t) {
                String err = "Failed to add HBase jars. Use --auxhbase=false to avoid localizing them";
                LOG.error(err);
                System.err.println(err);
                throw new RuntimeException(t);
            }
        }
        if ((auxJars = options.getAuxJars()) != null && !auxJars.isEmpty()) {
            String[] jarPaths;
            String[] arr$ = jarPaths = auxJars.split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String jarPath = arr$[i$];
                if (jarPath.isEmpty()) continue;
                lfs.copyFromLocalFile(new Path(jarPath), libDir);
            }
        }
        Path confPath = new Path(tmpDir, "conf");
        lfs.mkdirs(confPath);
        for (String f : NEEDED_CONFIGS) {
            this.copyConfig(options, lfs, confPath, f);
        }
        for (String f : OPTIONAL_CONFIGS) {
            try {
                this.copyConfig(options, lfs, confPath, f);
            }
            catch (Throwable t) {
                LOG.info("Error getting an optional config " + f + "; ignoring: " + t.getMessage());
            }
        }
        lfs.copyFromLocalFile(new Path(logger.toString()), confPath);
        String java_home = System.getenv("JAVA_HOME");
        String jre_home = System.getProperty("java.home");
        if (java_home == null) {
            java_home = jre_home;
        } else if (!java_home.equals(jre_home)) {
            LOG.warn("Java versions might not match : JAVA_HOME=%s,process jre=%s", (Object)java_home, (Object)jre_home);
        }
        JSONObject configs = new JSONObject();
        configs.put("java.home", (Object)java_home);
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB));
        configs.put(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, HiveConf.getSizeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE));
        configs.put(HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT.varname, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS));
        configs.put("yarn.scheduler.minimum-allocation-mb", this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1));
        configs.put("yarn.scheduler.minimum-allocation-vcores", this.conf.getInt("yarn.scheduler.minimum-allocation-vcores", -1));
        FSDataOutputStream os = lfs.create(new Path(tmpDir, "config.json"));
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os);
        configs.write((Writer)w);
        w.close();
        os.close();
        lfs.close();
        fs.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting successfully");
        }
    }

    private void localizeJarForClass(FileSystem lfs, Path libDir, String className, boolean doThrow) throws IOException {
        String jarPath = null;
        boolean hasException = false;
        try {
            Class<?> auxClass = Class.forName(className);
            jarPath = Utilities.jarFinderGetJar(auxClass);
        }
        catch (Throwable t) {
            if (doThrow) {
                throw t instanceof IOException ? (IOException)t : new IOException(t);
            }
            hasException = true;
            String err = "Cannot find a jar for [" + className + "] due to an exception (" + t.getMessage() + "); not packaging the jar";
            LOG.error(err, t);
            System.err.println(err);
        }
        if (jarPath != null) {
            lfs.copyFromLocalFile(new Path(jarPath), libDir);
        } else if (!hasException) {
            String err = "Cannot find a jar for [" + className + "]; not packaging the jar";
            if (doThrow) {
                throw new IOException(err);
            }
            LOG.error(err);
            System.err.println(err);
        }
    }

    private void copyConfig(LlapOptionsProcessor.LlapOptions options, FileSystem lfs, Path confPath, String f) throws IOException {
        if (f.equals("llap-daemon-site.xml")) {
            FSDataOutputStream confStream = lfs.create(new Path(confPath, f));
            Configuration copy = LlapServiceDriver.resolve(this.conf, "llap-daemon-site.xml", new String[0]);
            for (Map.Entry<Object, Object> props : options.getConfig().entrySet()) {
                copy.set((String)props.getKey(), (String)props.getValue());
            }
            copy.writeXml((OutputStream)confStream);
            confStream.close();
        } else {
            lfs.copyFromLocalFile(new Path(this.conf.getResource(f).toString()), confPath);
        }
    }
}

