/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapOptionsProcessor {
    protected static final Logger l4j = LoggerFactory.getLogger((String)LlapOptionsProcessor.class.getName());
    private final Options options = new Options();
    Map<String, String> hiveVariables = new HashMap<String, String>();
    private CommandLine commandLine;

    public LlapOptionsProcessor() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"instances");
        OptionBuilder.withLongOpt((String)"instances");
        OptionBuilder.withDescription((String)"Specify the number of instances to run this on");
        this.options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"Cluster name for YARN registry");
        this.options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.withDescription((String)"Temp directory for jars etc.");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.withLongOpt((String)"args");
        OptionBuilder.withDescription((String)"java arguments to the llap instance");
        this.options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"loglevel");
        OptionBuilder.withLongOpt((String)"loglevel");
        OptionBuilder.withDescription((String)"log levels for the llap instance");
        this.options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"chaosmonkey");
        OptionBuilder.withLongOpt((String)"chaosmonkey");
        OptionBuilder.withDescription((String)"chaosmonkey interval");
        this.options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"executors");
        OptionBuilder.withLongOpt((String)"executors");
        OptionBuilder.withDescription((String)"executor per instance");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"cache");
        OptionBuilder.withLongOpt((String)"cache");
        OptionBuilder.withDescription((String)"cache size per instance");
        this.options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.withLongOpt((String)"size");
        OptionBuilder.withDescription((String)"container size per instance");
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"xmx");
        OptionBuilder.withLongOpt((String)"xmx");
        OptionBuilder.withDescription((String)"working memory size");
        this.options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"auxjars");
        OptionBuilder.withLongOpt((String)"auxjars");
        OptionBuilder.withDescription((String)"additional jars to package (by default, JSON SerDe jar is packaged if available)");
        this.options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"auxhbase");
        OptionBuilder.withLongOpt((String)"auxhbase");
        OptionBuilder.withDescription((String)"whether to package the HBase jars (true by default)");
        this.options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    private static long parseSuffixed(String value) {
        return StringUtils.TraditionalBinaryPrefix.string2long((String)value);
    }

    public LlapOptions processOptions(String[] argv) throws ParseException {
        this.commandLine = new GnuParser().parse(this.options, argv);
        if (this.commandLine.hasOption('H') || !this.commandLine.hasOption("instances")) {
            this.printUsage();
            return null;
        }
        int instances = Integer.parseInt(this.commandLine.getOptionValue("instances"));
        String directory = this.commandLine.getOptionValue("directory");
        String jars = this.commandLine.getOptionValue("auxjars");
        String name = this.commandLine.getOptionValue("name", null);
        int executors = Integer.parseInt(this.commandLine.getOptionValue("executors", "-1"));
        long cache = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue("cache", "-1"));
        long size = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue("size", "-1"));
        long xmx = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue("xmx", "-1"));
        boolean isHbase = Boolean.parseBoolean(this.commandLine.getOptionValue("auxhbase", "true"));
        Properties hiveconf = this.commandLine.hasOption("hiveconf") ? this.commandLine.getOptionProperties("hiveconf") : new Properties();
        return new LlapOptions(name, instances, directory, executors, cache, size, xmx, jars, isHbase, hiveconf);
    }

    private void printUsage() {
        new HelpFormatter().printHelp("llap", this.options);
    }

    public class LlapOptions {
        private final int instances;
        private final String directory;
        private final String name;
        private final int executors;
        private final long cache;
        private final long size;
        private final long xmx;
        private final String jars;
        private final boolean isHbase;
        private final Properties conf;

        public LlapOptions(String name, int instances, String directory, int executors, long cache, long size, long xmx, String jars, @Nonnull boolean isHbase, Properties hiveconf) throws ParseException {
            if (instances <= 0) {
                throw new ParseException("Invalid configuration: " + instances + " (should be greater than 0)");
            }
            this.instances = instances;
            this.directory = directory;
            this.name = name;
            this.executors = executors;
            this.cache = cache;
            this.size = size;
            this.xmx = xmx;
            this.jars = jars;
            this.isHbase = isHbase;
            this.conf = hiveconf;
        }

        public String getName() {
            return this.name;
        }

        public int getInstances() {
            return this.instances;
        }

        public String getDirectory() {
            return this.directory;
        }

        public int getExecutors() {
            return this.executors;
        }

        public long getCache() {
            return this.cache;
        }

        public long getSize() {
            return this.size;
        }

        public long getXmx() {
            return this.xmx;
        }

        public String getAuxJars() {
            return this.jars;
        }

        public boolean getIsHBase() {
            return this.isHbase;
        }

        public Properties getConfig() {
            return this.conf;
        }
    }
}

