/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;

public class LowLevelFifoCachePolicy
implements LowLevelCachePolicy {
    private final Lock lock = new ReentrantLock();
    private final LinkedList<LlapCacheableBuffer> buffers;
    private EvictionListener evictionListener;
    private LlapOomDebugDump parentDebugDump;

    public LowLevelFifoCachePolicy(Configuration conf) {
        if (LlapIoImpl.LOGL.isInfoEnabled()) {
            LlapIoImpl.LOG.info("FIFO cache policy");
        }
        this.buffers = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
        this.lock.lock();
        try {
            this.buffers.add(buffer);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
    }

    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    @Override
    public void setParentDebugDumper(LlapOomDebugDump dumper) {
        this.parentDebugDump = dumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        long evicted = 0L;
        this.lock.lock();
        try {
            Iterator iter = this.buffers.iterator();
            while (evicted < memoryToReserve && iter.hasNext()) {
                LlapCacheableBuffer candidate = (LlapCacheableBuffer)iter.next();
                if (!candidate.invalidate()) continue;
                iter.remove();
                evicted += candidate.getMemoryUsage();
                this.evictionListener.notifyEvicted(candidate);
            }
        }
        finally {
            this.lock.unlock();
        }
        return evicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugDumpForOom() {
        StringBuilder sb = new StringBuilder("FIFO eviction list: ");
        this.lock.lock();
        try {
            sb.append(this.buffers.size()).append(" elements): ");
            Iterator iter = this.buffers.iterator();
            while (iter.hasNext()) {
                sb.append(((LlapCacheableBuffer)iter.next()).toStringForCache()).append(",\n");
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.parentDebugDump != null) {
            sb.append("\n").append(this.parentDebugDump.debugDumpForOom());
        }
        return sb.toString();
    }
}

