/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.impl.EvictingPriorityBlockingQueue;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorTestHelpers;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.FirstInFirstOutComparator;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFirstInFirstOutComparator {
    private static Configuration conf;
    private static Credentials cred;

    @Before
    public void setup() {
        conf = new Configuration();
    }

    private LlapDaemonProtocolProtos.SubmitWorkRequestProto createRequest(int fragmentNumber, int numSelfAndUpstreamTasks, int dagStartTime, int attemptStartTime) {
        return this.createRequest(fragmentNumber, numSelfAndUpstreamTasks, 0, dagStartTime, attemptStartTime, 1);
    }

    private LlapDaemonProtocolProtos.SubmitWorkRequestProto createRequest(int fragmentNumber, int numSelfAndUpstreamTasks, int numSelfAndUpstreamComplete, int dagStartTime, int attemptStartTime, int withinDagPriority) {
        ApplicationId appId = ApplicationId.newInstance((long)9999L, (int)72);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)dagId, (int)35);
        TezTaskID tId = TezTaskID.getInstance((TezVertexID)vId, (int)389);
        TezTaskAttemptID taId = TezTaskAttemptID.getInstance((TezTaskID)tId, (int)fragmentNumber);
        return LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder().setFragmentSpec(LlapDaemonProtocolProtos.FragmentSpecProto.newBuilder().setAttemptNumber(0).setDagName("MockDag").setFragmentNumber(fragmentNumber).setVertexName("MockVertex").setProcessorDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("MockProcessor").build()).setFragmentIdentifierString(taId.toString()).build()).setAmHost("localhost").setAmPort(12345).setAppAttemptNumber(0).setApplicationIdString("MockApp_1").setContainerIdString("MockContainer_1").setUser("MockUser").setTokenIdentifier("MockToken_1").setFragmentRuntimeInfo(LlapDaemonProtocolProtos.FragmentRuntimeInfo.newBuilder().setDagStartTime((long)dagStartTime).setFirstAttemptStartTime((long)attemptStartTime).setNumSelfAndUpstreamTasks(numSelfAndUpstreamTasks).setNumSelfAndUpstreamCompletedTasks(numSelfAndUpstreamComplete).setWithinDagPriority(withinDagPriority).build()).build();
    }

    @Test
    public void testWaitQueueComparator() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), false, 1000000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        TaskExecutorService.TaskWrapper r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), false, 1000000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 1, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 1, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 1, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 1, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), false, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 2, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5));
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
    }

    @Test(timeout=5000L)
    public void testWaitQueueComparatorWithinDagPriority() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 1, 0, 100, 100, 10), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 1, 0, 100, 100, 1), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 1, 0, 100, 100, 5), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=5000L)
    public void testWaitQueueComparatorParallelism() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 10, 3, 100, 100, 1), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 10, 7, 100, 100, 1), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 10, 5, 100, 100, 1), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1));
        Assert.assertNull((Object)queue.offer((Object)r2));
        Assert.assertNull((Object)queue.offer((Object)r3));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    static {
        cred = new Credentials();
    }

    private static class MockRequest
    extends TaskRunnerCallable {
        private int workTime;
        private boolean canFinish;

        public MockRequest(LlapDaemonProtocolProtos.SubmitWorkRequestProto requestProto, boolean canFinish, int workTime) {
            super(requestProto, (QueryFragmentInfo)Mockito.mock(QueryFragmentInfo.class), conf, (ExecutionContext)new ExecutionContextImpl("localhost"), null, cred, 0L, null, null, null, (KilledTaskHandler)Mockito.mock(KilledTaskHandler.class), (FragmentCompletionHandler)Mockito.mock(FragmentCompletionHandler.class), (HadoopShim)new DefaultHadoopShim());
            this.workTime = workTime;
            this.canFinish = canFinish;
        }

        protected TaskRunner2Result callInternal() {
            System.out.println(super.getRequestId() + " is executing..");
            try {
                Thread.sleep(this.workTime);
            }
            catch (InterruptedException e) {
                return new TaskRunner2Result(EndReason.KILL_REQUESTED, null, false);
            }
            return new TaskRunner2Result(EndReason.SUCCESS, null, false);
        }

        public boolean canFinish() {
            return this.canFinish;
        }
    }
}

