/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.configuration.LlapConfiguration;
import org.apache.hadoop.hive.llap.daemon.ContainerRunner;
import org.apache.hadoop.hive.llap.daemon.impl.LlapProtocolServerImpl;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapProtocolClientImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLlapDaemonProtocolServerImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void test() throws ServiceException, IOException {
        LlapConfiguration daemonConf = new LlapConfiguration();
        int rpcPort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
        int numHandlers = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_NUM_HANDLERS);
        ContainerRunner containerRunnerMock = (ContainerRunner)Mockito.mock(ContainerRunner.class);
        LlapProtocolServerImpl server = new LlapProtocolServerImpl(numHandlers, containerRunnerMock, new AtomicReference(), new AtomicReference(), rpcPort, rpcPort + 1);
        Mockito.when((Object)containerRunnerMock.submitWork((LlapDaemonProtocolProtos.SubmitWorkRequestProto)Mockito.any(LlapDaemonProtocolProtos.SubmitWorkRequestProto.class))).thenReturn((Object)LlapDaemonProtocolProtos.SubmitWorkResponseProto.newBuilder().setSubmissionState(LlapDaemonProtocolProtos.SubmissionStateProto.ACCEPTED).build());
        try {
            server.init(new Configuration());
            server.start();
            InetSocketAddress serverAddr = server.getBindAddress();
            LlapProtocolClientImpl client = new LlapProtocolClientImpl(new Configuration(), serverAddr.getHostName(), serverAddr.getPort(), null, null);
            LlapDaemonProtocolProtos.SubmitWorkResponseProto responseProto = client.submitWork(null, LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder().setAmHost("amhost").setAmPort(2000).build());
            Assert.assertEquals((Object)responseProto.getSubmissionState().name(), (Object)LlapDaemonProtocolProtos.SubmissionStateProto.ACCEPTED.name());
        }
        finally {
            server.stop();
        }
    }
}

