/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.impl.QueryInfo;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.impl.TestTaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorTestHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskExecutorService.class);

    public static MockRequest createMockRequest(int fragmentNum, int parallelism, long startTime, boolean canFinish, long workTime) {
        LlapDaemonProtocolProtos.SubmitWorkRequestProto requestProto = TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNum, parallelism, startTime);
        QueryFragmentInfo queryFragmentInfo = TaskExecutorTestHelpers.createQueryFragmentInfo(requestProto.getFragmentSpec());
        MockRequest mockRequest = new MockRequest(requestProto, queryFragmentInfo, canFinish, workTime);
        return mockRequest;
    }

    public static TaskExecutorService.TaskWrapper createTaskWrapper(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, boolean canFinish, int workTime) {
        QueryFragmentInfo queryFragmentInfo = TaskExecutorTestHelpers.createQueryFragmentInfo(request.getFragmentSpec());
        MockRequest mockRequest = new MockRequest(request, queryFragmentInfo, canFinish, workTime);
        TaskExecutorService.TaskWrapper taskWrapper = new TaskExecutorService.TaskWrapper((TaskRunnerCallable)mockRequest, null);
        return taskWrapper;
    }

    public static QueryFragmentInfo createQueryFragmentInfo(LlapDaemonProtocolProtos.FragmentSpecProto fragmentSpecProto) {
        QueryInfo queryInfo = TaskExecutorTestHelpers.createQueryInfo();
        QueryFragmentInfo fragmentInfo = new QueryFragmentInfo(queryInfo, "fakeVertexName", fragmentSpecProto.getFragmentNumber(), 0, fragmentSpecProto);
        return fragmentInfo;
    }

    public static QueryInfo createQueryInfo() {
        QueryIdentifier queryIdentifier = new QueryIdentifier("fake_app_id_string", 1);
        QueryInfo queryInfo = new QueryInfo(queryIdentifier, "fake_app_id_string", "fake_dag_name", 1, "fakeUser", new ConcurrentHashMap(), new String[0], null);
        return queryInfo;
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, long attemptStartTime) {
        return TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNumber, selfAndUpstreamParallelism, 0, attemptStartTime, 1);
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, int selfAndUpstreamComplete, long attemptStartTime, int withinDagPriority) {
        ApplicationId appId = ApplicationId.newInstance((long)9999L, (int)72);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)dagId, (int)35);
        TezTaskID tId = TezTaskID.getInstance((TezVertexID)vId, (int)389);
        TezTaskAttemptID taId = TezTaskAttemptID.getInstance((TezTaskID)tId, (int)fragmentNumber);
        return LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder().setFragmentSpec(LlapDaemonProtocolProtos.FragmentSpecProto.newBuilder().setAttemptNumber(0).setDagName("MockDag").setFragmentNumber(fragmentNumber).setVertexName("MockVertex").setProcessorDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("MockProcessor").build()).setFragmentIdentifierString(taId.toString()).build()).setAmHost("localhost").setAmPort(12345).setAppAttemptNumber(0).setApplicationIdString("MockApp_1").setContainerIdString("MockContainer_1").setUser("MockUser").setTokenIdentifier("MockToken_1").setFragmentRuntimeInfo(LlapDaemonProtocolProtos.FragmentRuntimeInfo.newBuilder().setFirstAttemptStartTime(attemptStartTime).setNumSelfAndUpstreamTasks(selfAndUpstreamParallelism).setNumSelfAndUpstreamCompletedTasks(selfAndUpstreamComplete).setWithinDagPriority(withinDagPriority).build()).build();
    }

    private static void logInfo(String message, Throwable t) {
        LOG.info(message, t);
    }

    private static void logInfo(String message) {
        TaskExecutorTestHelpers.logInfo(message, null);
    }

    public static class MockRequest
    extends TaskRunnerCallable {
        private final long workTime;
        private final boolean canFinish;
        private final AtomicBoolean isStarted = new AtomicBoolean(false);
        private final AtomicBoolean isFinished = new AtomicBoolean(false);
        private final AtomicBoolean wasKilled = new AtomicBoolean(false);
        private final AtomicBoolean wasInterrupted = new AtomicBoolean(false);
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition startedCondition = this.lock.newCondition();
        private final Condition sleepCondition = this.lock.newCondition();
        private boolean shouldSleep = true;
        private final Condition finishedCondition = this.lock.newCondition();

        public MockRequest(LlapDaemonProtocolProtos.SubmitWorkRequestProto requestProto, QueryFragmentInfo fragmentInfo, boolean canFinish, long workTime) {
            super(requestProto, fragmentInfo, new Configuration(), (ExecutionContext)new ExecutionContextImpl("localhost"), null, new Credentials(), 0L, null, null, (LlapDaemonExecutorMetrics)Mockito.mock(LlapDaemonExecutorMetrics.class), (KilledTaskHandler)Mockito.mock(KilledTaskHandler.class), (FragmentCompletionHandler)Mockito.mock(FragmentCompletionHandler.class), (HadoopShim)new DefaultHadoopShim());
            this.workTime = workTime;
            this.canFinish = canFinish;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected TaskRunner2Result callInternal() {
            try {
                TaskExecutorTestHelpers.logInfo(super.getRequestId() + " is executing..", null);
                this.lock.lock();
                try {
                    this.isStarted.set(true);
                    this.startedCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
                this.lock.lock();
                try {
                    if (this.shouldSleep) {
                        this.sleepCondition.await(this.workTime, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    this.wasInterrupted.set(true);
                    TaskRunner2Result taskRunner2Result = new TaskRunner2Result(EndReason.KILL_REQUESTED, null, false);
                    this.lock.lock();
                    try {
                        this.isFinished.set(true);
                        this.finishedCondition.signal();
                        return taskRunner2Result;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (this.wasKilled.get()) {
                    TaskRunner2Result taskRunner2Result = new TaskRunner2Result(EndReason.KILL_REQUESTED, null, false);
                    return taskRunner2Result;
                }
                TaskRunner2Result taskRunner2Result = new TaskRunner2Result(EndReason.SUCCESS, null, false);
                return taskRunner2Result;
            }
            finally {
                this.lock.lock();
                try {
                    this.isFinished.set(true);
                    this.finishedCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killTask() {
            this.lock.lock();
            try {
                this.wasKilled.set(true);
                this.shouldSleep = false;
                this.sleepCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean hasStarted() {
            return this.isStarted.get();
        }

        boolean hasFinished() {
            return this.isFinished.get();
        }

        boolean wasPreempted() {
            return this.wasKilled.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            this.lock.lock();
            try {
                this.shouldSleep = false;
                this.sleepCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitStart() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isStarted.get()) {
                    this.startedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEnd() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isFinished.get()) {
                    this.finishedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean canFinish() {
            return this.canFinish;
        }
    }
}

