/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniLlapCluster
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(MiniLlapCluster.class);
    private final File testWorkDir;
    private final long execBytesPerService;
    private final boolean llapIoEnabled;
    private final boolean ioIsDirect;
    private final long ioBytesPerService;
    private final int numExecutorsPerService;
    private final String[] localDirs;
    private final Configuration clusterSpecificConfiguration = new Configuration(false);
    private LlapDaemon llapDaemon;

    public static MiniLlapCluster create(String clusterName, int numExecutorsPerService, long execBytePerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        return new MiniLlapCluster(clusterName, numExecutorsPerService, execBytePerService, llapIoEnabled, ioIsDirect, ioBytesPerService, numLocalDirs);
    }

    public static MiniLlapCluster createAndLaunch(Configuration conf, String clusterName, int numExecutorsPerService, long execBytePerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        MiniLlapCluster miniLlapCluster = MiniLlapCluster.create(clusterName, numExecutorsPerService, execBytePerService, llapIoEnabled, ioIsDirect, ioBytesPerService, numLocalDirs);
        miniLlapCluster.init(conf);
        miniLlapCluster.start();
        Configuration llapConf = miniLlapCluster.getClusterSpecificConfiguration();
        for (Map.Entry entry : llapConf) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return miniLlapCluster;
    }

    private MiniLlapCluster(String clusterName, int numExecutorsPerService, long execMemoryPerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        super(clusterName + "_" + MiniLlapCluster.class.getSimpleName());
        Preconditions.checkArgument((numExecutorsPerService > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((execMemoryPerService > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((numLocalDirs > 0 ? 1 : 0) != 0);
        String clusterNameTrimmed = clusterName.replace("$", "") + "_" + MiniLlapCluster.class.getSimpleName();
        File targetWorkDir = new File("target", clusterNameTrimmed);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn("Could not cleanup test workDir: " + targetWorkDir, (Throwable)e);
            throw new RuntimeException("Could not cleanup test workDir: " + targetWorkDir, e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.numExecutorsPerService = numExecutorsPerService;
        this.execBytesPerService = execMemoryPerService;
        this.ioIsDirect = ioIsDirect;
        this.llapIoEnabled = llapIoEnabled;
        this.ioBytesPerService = ioBytesPerService;
        this.localDirs = new String[numLocalDirs];
        for (int i = 0; i < numLocalDirs; ++i) {
            File f = new File(this.testWorkDir, "localDir");
            f.mkdirs();
            LOG.info("Created localDir: " + f.getAbsolutePath());
            this.localDirs[i] = f.getAbsolutePath();
        }
    }

    public void serviceInit(Configuration conf) {
        this.llapDaemon = new LlapDaemon(conf, this.numExecutorsPerService, this.execBytesPerService, this.llapIoEnabled, this.ioIsDirect, this.ioBytesPerService, this.localDirs, 0, 0, 0);
        this.llapDaemon.init(conf);
    }

    public void serviceStart() {
        this.llapDaemon.start();
        this.clusterSpecificConfiguration.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, this.getServiceAddress().getHostName());
        this.clusterSpecificConfiguration.setInt(HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT.varname, this.getServiceAddress().getPort());
        this.clusterSpecificConfiguration.setInt(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, this.numExecutorsPerService);
        this.clusterSpecificConfiguration.setLong(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, this.execBytesPerService);
        this.clusterSpecificConfiguration.setBoolean("tez.runtime.optimize.local.fetch", false);
    }

    public void serviceStop() {
        if (this.llapDaemon != null) {
            this.llapDaemon.stop();
            this.llapDaemon = null;
        }
    }

    private InetSocketAddress getServiceAddress() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.llapDaemon.getListenerAddress();
    }

    public Configuration getClusterSpecificConfiguration() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.clusterSpecificConfiguration;
    }

    public long getNumSubmissions() {
        return this.llapDaemon.getNumSubmissions();
    }
}

