/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcMetadataCache {
    @Test
    public void testGetPut() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        OrcMetadataCache cache = new OrcMetadataCache((MemoryManager)mm, (LowLevelCachePolicy)cp);
        OrcFileMetadata ofm1 = OrcFileMetadata.createDummy((int)1);
        OrcFileMetadata ofm2 = OrcFileMetadata.createDummy((int)2);
        Assert.assertSame((Object)ofm1, (Object)cache.putFileMetadata(ofm1));
        Assert.assertEquals((long)1L, (long)mm.allocs);
        Assert.assertSame((Object)ofm2, (Object)cache.putFileMetadata(ofm2));
        Assert.assertEquals((long)2L, (long)mm.allocs);
        Assert.assertSame((Object)ofm1, (Object)cache.getFileMetadata(1L));
        Assert.assertSame((Object)ofm2, (Object)cache.getFileMetadata(2L));
        OrcFileMetadata ofm3 = OrcFileMetadata.createDummy((int)1);
        Assert.assertSame((Object)ofm1, (Object)cache.putFileMetadata(ofm3));
        Assert.assertEquals((long)2L, (long)mm.allocs);
        Assert.assertSame((Object)ofm1, (Object)cache.getFileMetadata(1L));
        OrcStripeMetadata osm1 = OrcStripeMetadata.createDummy((long)1L);
        OrcStripeMetadata osm2 = OrcStripeMetadata.createDummy((long)2L);
        Assert.assertSame((Object)osm1, (Object)cache.putStripeMetadata(osm1));
        Assert.assertEquals((long)3L, (long)mm.allocs);
        Assert.assertSame((Object)osm2, (Object)cache.putStripeMetadata(osm2));
        Assert.assertEquals((long)4L, (long)mm.allocs);
        Assert.assertSame((Object)osm1, (Object)cache.getStripeMetadata(osm1.getKey()));
        Assert.assertSame((Object)osm2, (Object)cache.getStripeMetadata(osm2.getKey()));
        OrcStripeMetadata osm3 = OrcStripeMetadata.createDummy((long)1L);
        Assert.assertSame((Object)osm1, (Object)cache.putStripeMetadata(osm3));
        Assert.assertEquals((long)4L, (long)mm.allocs);
        Assert.assertSame((Object)osm1, (Object)cache.getStripeMetadata(osm3.getKey()));
    }

    private static class DummyMemoryManager
    implements MemoryManager {
        int allocs = 0;

        private DummyMemoryManager() {
        }

        public boolean reserveMemory(long memoryToReserve, boolean waitForEviction) {
            ++this.allocs;
            return true;
        }

        public void releaseMemory(long memUsage) {
            --this.allocs;
        }

        public String debugDumpForOom() {
            return "";
        }

        public void updateMaxSize(long maxSize) {
        }

        public void forceReservedMemory(int memoryToEvict) {
        }
    }

    private static class DummyCachePolicy
    implements LowLevelCachePolicy {
        public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
        }

        public void notifyLock(LlapCacheableBuffer buffer) {
        }

        public void notifyUnlock(LlapCacheableBuffer buffer) {
        }

        public long evictSomeBlocks(long memoryToReserve) {
            return memoryToReserve;
        }

        public void setEvictionListener(EvictionListener listener) {
        }

        public String debugDumpForOom() {
            return "";
        }

        public void setParentDebugDumper(LlapOomDebugDump dumper) {
        }
    }
}

