/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.HttpBasicAuthInterceptor;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveConnection
implements Connection {
    private static final String HIVE_AUTH_TYPE = "auth";
    private static final String HIVE_AUTH_QOP = "sasl.qop";
    private static final String HIVE_AUTH_SIMPLE = "noSasl";
    private static final String HIVE_AUTH_USER = "user";
    private static final String HIVE_AUTH_PRINCIPAL = "principal";
    private static final String HIVE_AUTH_PASSWD = "password";
    private static final String HIVE_ANONYMOUS_USER = "anonymous";
    private static final String HIVE_ANONYMOUS_PASSWD = "anonymous";
    private static final String HIVE_SSL = "ssl";
    private static final String HIVE_SSL_ENABLED = "true";
    private static final String HIVE_SSL_TRUSTSTORE = "sslTrustStore";
    private static final String HIVE_SSL_TRUSTSTORE_PASSWD = "sslTrustStorePassword";
    private final String jdbcURI;
    private final String host;
    private final int port;
    private final Map<String, String> sessConfMap;
    private final Map<String, String> hiveConfMap;
    private final Map<String, String> hiveVarMap;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();

    public HiveConnection(String uri, Properties info) throws SQLException {
        this.jdbcURI = uri;
        Utils.JdbcConnectionParams connParams = Utils.parseURL(this.jdbcURI);
        this.host = connParams.getHost();
        this.port = connParams.getPort();
        this.sessConfMap = connParams.getSessionVars();
        this.hiveConfMap = connParams.getHiveConfs();
        this.hiveVarMap = connParams.getHiveVars();
        this.isEmbeddedMode = connParams.isEmbeddedMode();
        if (this.isEmbeddedMode) {
            this.client = new EmbeddedThriftBinaryCLIService();
        } else {
            if (info.containsKey(HIVE_AUTH_USER)) {
                this.sessConfMap.put(HIVE_AUTH_USER, info.getProperty(HIVE_AUTH_USER));
                if (info.containsKey(HIVE_AUTH_PASSWD)) {
                    this.sessConfMap.put(HIVE_AUTH_PASSWD, info.getProperty(HIVE_AUTH_PASSWD));
                }
            }
            this.openTransport();
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V2);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
        this.openSession();
        this.configureConnection();
    }

    private void openTransport() throws SQLException {
        this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new TCLIService.Client((TProtocol)protocol);
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new SQLException("Could not open connection to " + this.jdbcURI + ": " + e.getMessage(), " 08S01", e);
        }
    }

    private TTransport createHttpTransport() throws SQLException {
        String httpPath = this.hiveConfMap.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname);
        if (httpPath == null) {
            httpPath = "/";
        }
        if (!httpPath.startsWith("/")) {
            httpPath = "/" + httpPath;
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String httpUrl = this.hiveConfMap.get(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname) + "://" + this.host + ":" + this.port + httpPath;
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new HttpBasicAuthInterceptor(this.getUserName(), this.getPasswd()));
        try {
            this.transport = new THttpClient(httpUrl, (HttpClient)httpClient);
        }
        catch (TTransportException e) {
            String msg = "Could not create http connection to " + this.jdbcURI + ". " + e.getMessage();
            throw new SQLException(msg, " 08S01", e);
        }
        return this.transport;
    }

    private TTransport createBinaryTransport() throws SQLException {
        block20: {
            if (this.sessConfMap.containsKey(HIVE_SSL) && this.sessConfMap.get(HIVE_SSL).equals(HIVE_SSL_ENABLED)) {
                String prevTS = System.getProperty("javax.net.ssl.trustStore");
                String prevTSP = System.getProperty("javax.net.ssl.trustStorePassword");
                try {
                    String tsp;
                    String ts = this.sessConfMap.get(HIVE_SSL_TRUSTSTORE);
                    if (ts != null) {
                        System.setProperty("javax.net.ssl.trustStore", ts);
                    }
                    if ((tsp = this.sessConfMap.get(HIVE_SSL_TRUSTSTORE_PASSWD)) != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", tsp);
                    }
                    this.transport = TSSLTransportFactory.getClientSocket((String)this.host, (int)this.port, (int)0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SQLException("Could not establish SSL transport" + this.jdbcURI + ": " + e.getMessage(), " 08S01");
                }
                finally {
                    if (prevTS != null) {
                        System.setProperty("javax.net.ssl.trustStore", prevTS);
                    }
                    if (prevTSP != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", prevTSP);
                    }
                }
            } else {
                this.transport = new TSocket(this.host, this.port);
            }
            if (!this.sessConfMap.containsKey(HIVE_AUTH_TYPE) || !this.sessConfMap.get(HIVE_AUTH_TYPE).equals(HIVE_AUTH_SIMPLE)) {
                try {
                    String passwd;
                    if (this.sessConfMap.containsKey(HIVE_AUTH_PRINCIPAL)) {
                        HashMap<String, String> saslProps = new HashMap<String, String>();
                        SaslQOP saslQOP = SaslQOP.AUTH;
                        if (this.sessConfMap.containsKey(HIVE_AUTH_QOP)) {
                            try {
                                saslQOP = SaslQOP.fromString((String)this.sessConfMap.get(HIVE_AUTH_QOP));
                            }
                            catch (IllegalArgumentException e) {
                                throw new SQLException("Invalid sasl.qop parameter. " + e.getMessage(), "42000", e);
                            }
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                        saslProps.put("javax.security.sasl.server.authentication", HIVE_SSL_ENABLED);
                        this.transport = KerberosSaslHelper.getKerberosTransport((String)this.sessConfMap.get(HIVE_AUTH_PRINCIPAL), (String)this.host, (TTransport)this.transport, saslProps);
                        break block20;
                    }
                    String userName = this.sessConfMap.get(HIVE_AUTH_USER);
                    if (userName == null || userName.isEmpty()) {
                        userName = "anonymous";
                    }
                    if ((passwd = this.sessConfMap.get(HIVE_AUTH_PASSWD)) == null || passwd.isEmpty()) {
                        passwd = "anonymous";
                    }
                    this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)this.transport);
                }
                catch (SaslException e) {
                    throw new SQLException("Could not create secure connection to " + this.jdbcURI + ": " + e.getMessage(), " 08S01", e);
                }
            }
        }
        return this.transport;
    }

    private boolean isHttpTransportMode() {
        String transportMode = this.hiveConfMap.get(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname);
        return transportMode != null && (transportMode.equalsIgnoreCase("http") || transportMode.equalsIgnoreCase("https"));
    }

    private void openSession() throws SQLException {
        TOpenSessionReq openReq = new TOpenSessionReq();
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.sessHandle = openResp.getSessionHandle();
        }
        catch (TException e) {
            throw new SQLException("Could not establish connection to " + this.jdbcURI + ": " + e.getMessage(), " 08S01", e);
        }
        this.isClosed = false;
    }

    private void configureConnection() throws SQLException {
        if (this.isEmbeddedMode) {
            if (!this.hiveVarMap.isEmpty()) {
                SessionState.get().setHiveVariables(this.hiveVarMap);
            }
        } else {
            Statement stmt = this.createStatement();
            for (Map.Entry<String, String> hiveConf : this.hiveConfMap.entrySet()) {
                stmt.execute("set " + hiveConf.getKey() + "=" + hiveConf.getValue());
            }
            for (Map.Entry<String, String> hiveVar : this.hiveVarMap.entrySet()) {
                stmt.execute("set hivevar:" + hiveVar.getKey() + "=" + hiveVar.getValue());
            }
            stmt.close();
        }
    }

    private String getUserName() {
        return this.getSessionValue(HIVE_AUTH_USER, "anonymous");
    }

    private String getPasswd() {
        return this.getSessionValue(HIVE_AUTH_PASSWD, "anonymous");
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this.client, this.sessHandle);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new HiveDatabaseMetaData(this.client, this.sessHandle);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            throw new SQLException("enabling autocommit is not supported");
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

