/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hwi;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.JettyShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HWIServer {
    protected static final Logger l4j = LoggerFactory.getLogger((String)HWIServer.class.getName());
    private JettyShims.Server webServer;
    private final String[] args;

    public HWIServer(String[] args) throws IOException {
        this.args = args;
    }

    public void start() throws IOException {
        HiveConf conf = new HiveConf(this.getClass());
        String listen = null;
        int port = -1;
        listen = conf.getVar(HiveConf.ConfVars.HIVEHWILISTENHOST);
        port = conf.getIntVar(HiveConf.ConfVars.HIVEHWILISTENPORT);
        if (listen.equals("")) {
            l4j.warn("hive.hwi.listen.host was not specified defaulting to 0.0.0.0");
            listen = "0.0.0.0";
        }
        if (port == -1) {
            l4j.warn("hive.hwi.listen.port was not specified defaulting to 9999");
            port = 9999;
        }
        String hwiWAR = conf.getVar(HiveConf.ConfVars.HIVEHWIWARFILE);
        String hivehome = System.getenv().get("HIVE_HOME");
        File hwiWARFile = new File(hivehome, hwiWAR);
        if (!hwiWARFile.exists()) {
            l4j.error("HWI WAR file not found at " + hwiWARFile.toString());
            System.exit(1);
        }
        this.webServer = ShimLoader.getJettyShims().startServer(listen, port);
        this.webServer.addWar(hwiWARFile.toString(), "/hwi");
        StringBuilder sb = new StringBuilder();
        for (String arg : this.args) {
            sb.append(arg + " ");
        }
        System.setProperty("hwi-args", sb.toString());
        try {
            this.webServer.start();
            this.webServer.join();
            l4j.debug(" HWI Web Server is started.");
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            IOException ie = new IOException("Problem starting HWI server");
            ie.initCause(e);
            l4j.error("Parsing hwi.listen.port caused exception ", (Throwable)e);
            throw ie;
        }
    }

    public static void main(String[] args) throws Exception {
        HWIServer hwi = new HWIServer(args);
        l4j.info("HWI is starting up");
        hwi.start();
    }

    public void stop() throws Exception {
        l4j.info("HWI is shutting down");
        this.webServer.stop();
    }
}

