/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHFileOutputFormat
extends HFileOutputFormat
implements HiveOutputFormat<ImmutableBytesWritable, KeyValue> {
    public static final String HFILE_FAMILY_PATH = "hfile.family.path";
    static final Logger LOG = LoggerFactory.getLogger((String)HiveHFileOutputFormat.class.getName());

    private org.apache.hadoop.mapreduce.RecordWriter<ImmutableBytesWritable, KeyValue> getFileWriter(TaskAttemptContext tac) throws IOException {
        try {
            return super.getRecordWriter(tac);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    public static String getFamilyPath(Configuration jc, Properties tableProps) {
        return jc.get(HFILE_FAMILY_PATH, tableProps.getProperty(HFILE_FAMILY_PATH));
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(final JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progressable) throws IOException {
        String hfilePath = HiveHFileOutputFormat.getFamilyPath((Configuration)jc, tableProperties);
        if (hfilePath == null) {
            throw new RuntimeException("Please set hfile.family.path to target location for HFiles");
        }
        final Path columnFamilyPath = new Path(hfilePath);
        final String columnFamilyName = columnFamilyPath.getName();
        final byte[] columnFamilyNameBytes = Bytes.toBytes((String)columnFamilyName);
        Job job = new Job((Configuration)jc);
        HiveHFileOutputFormat.setCompressOutput((Job)job, (boolean)isCompressed);
        HiveHFileOutputFormat.setOutputPath((Job)job, (Path)finalOutPath);
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext(job.getConfiguration(), progressable);
        final Path outputdir = FileOutputFormat.getOutputPath((JobContext)tac);
        final Path taskAttemptOutputdir = new FileOutputCommitter(outputdir, tac).getWorkPath();
        final org.apache.hadoop.mapreduce.RecordWriter<ImmutableBytesWritable, KeyValue> fileWriter = this.getFileWriter(tac);
        String columnList = tableProperties.getProperty("columns");
        String[] columnArray = columnList.split(",");
        final TreeMap<byte[], Integer> columnMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        int i = 0;
        for (String columnName : columnArray) {
            if (i != 0) {
                columnMap.put(Bytes.toBytes((String)columnName), i);
            }
            ++i;
        }
        return new FileSinkOperator.RecordWriter(){

            public void close(boolean abort) throws IOException {
                try {
                    Path srcDir;
                    FileSystem fs;
                    block7: {
                        FileStatus[] files;
                        fileWriter.close(null);
                        if (abort) {
                            return;
                        }
                        fs = outputdir.getFileSystem((Configuration)jc);
                        fs.mkdirs(columnFamilyPath);
                        srcDir = taskAttemptOutputdir;
                        do {
                            if ((files = fs.listStatus(srcDir, FileUtils.STAGING_DIR_PATH_FILTER)) == null || files.length == 0) {
                                throw new IOException("No family directories found in " + srcDir);
                            }
                            if (files.length != 1) {
                                throw new IOException("Multiple family directories found in " + srcDir);
                            }
                            srcDir = files[0].getPath();
                            if (srcDir.getName().equals(columnFamilyName)) break block7;
                        } while (!files[0].isFile());
                        throw new IOException("No family directories found in " + taskAttemptOutputdir + ". The last component in hfile path should match column family name " + columnFamilyName);
                    }
                    for (FileStatus regionFile : fs.listStatus(srcDir, FileUtils.STAGING_DIR_PATH_FILTER)) {
                        fs.rename(regionFile.getPath(), new Path(columnFamilyPath, regionFile.getPath().getName()));
                    }
                    fs.delete(taskAttemptOutputdir, true);
                    fs.createNewFile(taskAttemptOutputdir);
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
            }

            private void writeText(Text text) throws IOException {
                String s = text.toString();
                String[] fields = s.split("\u0001");
                assert (fields.length <= columnMap.size() + 1);
                byte[] rowKeyBytes = Bytes.toBytes((String)fields[0]);
                for (Map.Entry entry : columnMap.entrySet()) {
                    String val;
                    byte[] columnNameBytes = (byte[])entry.getKey();
                    int iColumn = (Integer)entry.getValue();
                    if (iColumn >= fields.length) {
                        val = "";
                    } else {
                        val = fields[iColumn];
                        if ("\\N".equals(val)) continue;
                    }
                    byte[] valBytes = Bytes.toBytes((String)val);
                    KeyValue kv = new KeyValue(rowKeyBytes, columnFamilyNameBytes, columnNameBytes, valBytes);
                    try {
                        fileWriter.write(null, (Object)kv);
                    }
                    catch (IOException e) {
                        LOG.error("Failed while writing row: " + s);
                        throw e;
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(ex);
                    }
                }
            }

            private void writePut(PutWritable put) throws IOException {
                ImmutableBytesWritable row = new ImmutableBytesWritable(put.getPut().getRow());
                NavigableMap cells = put.getPut().getFamilyCellMap();
                for (Map.Entry entry : cells.entrySet()) {
                    Collections.sort((List)entry.getValue(), new CellComparator());
                    for (Cell c : (List)entry.getValue()) {
                        try {
                            fileWriter.write((Object)row, (Object)KeyValueUtil.copyToNewKeyValue((Cell)c));
                        }
                        catch (InterruptedException e) {
                            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                        }
                    }
                }
            }

            public void write(Writable w) throws IOException {
                if (w instanceof Text) {
                    this.writeText((Text)w);
                } else if (w instanceof PutWritable) {
                    this.writePut((PutWritable)w);
                } else {
                    throw new IOException("Unexpected writable " + w);
                }
            }
        };
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf jc) throws IOException {
        Job job = new Job((Configuration)jc);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        this.checkOutputSpecs(jobContext);
    }

    public RecordWriter<ImmutableBytesWritable, KeyValue> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        throw new NotImplementedException("This will not be invoked");
    }
}

