/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase.struct;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.struct.DefaultHBaseValueFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroLazyObjectInspector;
import org.apache.hadoop.hive.serde2.avro.AvroSchemaRetriever;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;

public class AvroHBaseValueFactory
extends DefaultHBaseValueFactory {
    private AvroSchemaRetriever avroSchemaRetriever;
    private Schema schema;

    public AvroHBaseValueFactory(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void init(HBaseSerDeParameters hbaseParams, Configuration conf, Properties properties) throws SerDeException {
        super.init(hbaseParams, conf, properties);
        String avroSchemaRetClass = properties.getProperty(AvroSerdeUtils.SCHEMA_RETRIEVER);
        if (avroSchemaRetClass != null) {
            Class avroSchemaRetrieverClass = null;
            try {
                avroSchemaRetrieverClass = conf.getClassByName(avroSchemaRetClass);
            }
            catch (ClassNotFoundException e) {
                throw new SerDeException((Throwable)e);
            }
            this.initAvroSchemaRetriever(avroSchemaRetrieverClass, conf, properties);
        }
    }

    @Override
    public ObjectInspector createValueObjectInspector(TypeInfo type) throws SerDeException {
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])this.serdeParams.getSeparators(), (int)1, (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar(), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.AVRO);
        this.initInternalObjectInspectors(oi);
        return oi;
    }

    @Override
    public byte[] serializeValue(Object object, StructField field) throws IOException {
        return super.serializeValue(object, field);
    }

    private void initAvroSchemaRetriever(Class<?> avroSchemaRetrieverClass, Configuration conf, Properties tbl) throws SerDeException {
        try {
            this.avroSchemaRetriever = (AvroSchemaRetriever)avroSchemaRetrieverClass.getDeclaredConstructor(Configuration.class, Properties.class).newInstance(conf, tbl);
        }
        catch (NoSuchMethodException e) {
            throw new SerDeException("Constructor not defined in schema retriever class [" + avroSchemaRetrieverClass.getName() + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    private void initInternalObjectInspectors(ObjectInspector oi) {
        ObjectInspector valueOI;
        if (oi instanceof AvroLazyObjectInspector) {
            this.initAvroObjectInspector(oi);
        } else if (oi instanceof MapObjectInspector && (valueOI = ((MapObjectInspector)oi).getMapValueObjectInspector()) instanceof AvroLazyObjectInspector) {
            this.initAvroObjectInspector(valueOI);
        }
    }

    private void initAvroObjectInspector(ObjectInspector oi) {
        if (oi instanceof ListObjectInspector) {
            ListObjectInspector loi = (ListObjectInspector)oi;
            this.initAvroObjectInspector(loi.getListElementObjectInspector());
            return;
        }
        if (!(oi instanceof AvroLazyObjectInspector)) {
            return;
        }
        AvroLazyObjectInspector aoi = (AvroLazyObjectInspector)oi;
        aoi.setSchemaRetriever(this.avroSchemaRetriever);
        aoi.setReaderSchema(this.schema);
        for (StructField field : aoi.getAllStructFieldRefs()) {
            this.initAvroObjectInspector(field.getFieldObjectInspector());
        }
    }
}

