/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.JobConf;

class HiveHBaseInputFormatUtil {
    HiveHBaseInputFormatUtil() {
    }

    public static HTable getTable(JobConf jobConf) throws IOException {
        String hbaseTableName = jobConf.get("hbase.table.name");
        return new HTable(HBaseConfiguration.create((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName));
    }

    public static Scan getScan(JobConf jobConf) throws IOException {
        String scanBatch;
        String scanCacheBlocks;
        String scanCache;
        ColumnMappings columnMappings;
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        List readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        if (columnMappings.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean readAllColumns = ColumnProjectionUtils.isReadAllColumns((Configuration)jobConf);
        Scan scan = new Scan();
        boolean empty = true;
        ArrayList<String> addedFamilies = new ArrayList<String>();
        if (!readAllColumns) {
            ColumnMappings.ColumnMapping[] columnsMapping = columnMappings.getColumnsMapping();
            Iterator i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                ColumnMappings.ColumnMapping colMap = columnsMapping[i];
                if (colMap.hbaseRowKey) continue;
                if (colMap.qualifierName == null) {
                    scan.addFamily(colMap.familyNameBytes);
                    addedFamilies.add(colMap.familyName);
                } else if (!addedFamilies.contains(colMap.familyName)) {
                    scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
                }
                empty = false;
            }
        }
        if (empty) {
            for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                if (colMap.hbaseRowKey) continue;
                if (colMap.qualifierName == null) {
                    scan.addFamily(colMap.familyNameBytes);
                } else {
                    scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
                }
                if (readAllColumns) continue;
                break;
            }
        }
        if ((scanCache = jobConf.get("hbase.scan.cache")) != null) {
            scan.setCaching(Integer.valueOf(scanCache).intValue());
        }
        if ((scanCacheBlocks = jobConf.get("hbase.scan.cacheblock")) != null) {
            scan.setCacheBlocks(Boolean.valueOf(scanCacheBlocks).booleanValue());
        }
        if ((scanBatch = jobConf.get("hbase.scan.batch")) != null) {
            scan.setBatch(Integer.valueOf(scanBatch).intValue());
        }
        return scan;
    }

    public static boolean getStorageFormatOfKey(String spec, String defaultFormat) throws IOException {
        String[] mapInfo = spec.split("#");
        boolean tblLevelDefault = "binary".equalsIgnoreCase(defaultFormat);
        switch (mapInfo.length) {
            case 1: {
                return tblLevelDefault;
            }
            case 2: {
                String storageType = mapInfo[1];
                if (storageType.equals("-")) {
                    return tblLevelDefault;
                }
                if ("string".startsWith(storageType)) {
                    return false;
                }
                if (!"binary".startsWith(storageType)) break;
                return true;
            }
        }
        throw new IOException("Malformed string: " + spec);
    }
}

