/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.hbase.AbstractHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseScanRange;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.BaseStructObjectInspector;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.JobConf;

public class TestHBaseKeyFactory2
extends AbstractHBaseKeyFactory {
    private static final int FIXED_LENGTH = 10;
    private final ByteStream.Output output = new ByteStream.Output();

    public ObjectInspector createKeyObjectInspector(TypeInfo type) {
        return new StringArrayOI((StructTypeInfo)type);
    }

    public LazyObjectBase createKey(ObjectInspector inspector) throws SerDeException {
        return new FixedLengthed(10);
    }

    public byte[] serializeKey(Object object, StructField field) throws IOException {
        ObjectInspector inspector = field.getFieldObjectInspector();
        if (inspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new IllegalStateException("invalid type value " + inspector.getTypeName());
        }
        this.output.reset();
        for (Object element : ((StructObjectInspector)inspector).getStructFieldsDataAsList(object)) {
            this.output.write(this.toBinary(String.valueOf(element).getBytes(), 10, false, false));
        }
        return this.output.getLength() > 0 ? this.output.toByteArray() : null;
    }

    private byte[] toBinary(String value, int max, boolean end, boolean nextBA) {
        return this.toBinary(value.getBytes(), max, end, nextBA);
    }

    private byte[] toBinary(byte[] value, int max, boolean end, boolean nextBA) {
        byte[] bytes = new byte[max + 1];
        System.arraycopy(value, 0, bytes, 0, Math.min(value.length, max));
        if (end) {
            Arrays.fill(bytes, value.length, max, (byte)-1);
        }
        if (nextBA) {
            bytes[max] = 1;
        }
        return bytes;
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        String keyColName = this.keyMapping.columnName;
        IndexPredicateAnalyzer analyzer = IndexPredicateAnalyzer.createAnalyzer((boolean)false);
        analyzer.allowColumnName(keyColName);
        analyzer.setAcceptsFields(true);
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = new HiveStoragePredicateHandler.DecomposedPredicate();
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>();
        decomposed.residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, searchConditions);
        if (!searchConditions.isEmpty()) {
            decomposed.pushedPredicate = analyzer.translateSearchConditions(searchConditions);
            try {
                decomposed.pushedPredicateObject = this.setupFilter(keyColName, searchConditions);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return decomposed;
    }

    private HBaseScanRange setupFilter(String keyColName, List<IndexSearchCondition> conditions) throws IOException {
        HashMap<String, ArrayList<IndexSearchCondition>> fieldConds = new HashMap<String, ArrayList<IndexSearchCondition>>();
        for (IndexSearchCondition condition : conditions) {
            assert (keyColName.equals(condition.getColumnDesc().getColumn()));
            String fieldName = condition.getFields()[0];
            ArrayList<IndexSearchCondition> fieldCond = (ArrayList<IndexSearchCondition>)fieldConds.get(fieldName);
            if (fieldCond == null) {
                fieldCond = new ArrayList<IndexSearchCondition>();
                fieldConds.put(fieldName, fieldCond);
            }
            fieldCond.add(condition);
        }
        HBaseScanRange range = new HBaseScanRange();
        ByteArrayOutputStream startRow = new ByteArrayOutputStream();
        ByteArrayOutputStream stopRow = new ByteArrayOutputStream();
        StructTypeInfo type = (StructTypeInfo)this.keyMapping.columnType;
        for (String name : type.getAllStructFieldNames()) {
            List fieldCond = (List)fieldConds.get(name);
            if (fieldCond == null || fieldCond.size() > 2) continue;
            byte[] startElement = null;
            byte[] stopElement = null;
            for (IndexSearchCondition condition : fieldCond) {
                if (condition.getConstantDesc().getValue() == null) continue;
                String comparisonOp = condition.getComparisonOp();
                String constantVal = String.valueOf(condition.getConstantDesc().getValue());
                if (comparisonOp.endsWith("UDFOPEqual")) {
                    startElement = this.toBinary(constantVal, 10, false, false);
                    stopElement = this.toBinary(constantVal, 10, true, true);
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPEqualOrGreaterThan")) {
                    startElement = this.toBinary(constantVal, 10, false, false);
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPGreaterThan")) {
                    startElement = this.toBinary(constantVal, 10, false, true);
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPEqualOrLessThan")) {
                    stopElement = this.toBinary(constantVal, 10, true, false);
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPLessThan")) {
                    stopElement = this.toBinary(constantVal, 10, true, true);
                    continue;
                }
                throw new IOException(comparisonOp + " is not a supported comparison operator");
            }
            if (startRow != null) {
                if (startElement != null) {
                    startRow.write(startElement);
                } else {
                    if (startRow.size() > 0) {
                        range.setStartRow(startRow.toByteArray());
                    }
                    startRow = null;
                }
            }
            if (stopRow != null) {
                if (stopElement != null) {
                    stopRow.write(stopElement);
                } else {
                    if (stopRow.size() > 0) {
                        range.setStopRow(stopRow.toByteArray());
                    }
                    stopRow = null;
                }
            }
            if (startElement != null || stopElement != null) continue;
            break;
        }
        if (startRow != null && startRow.size() > 0) {
            range.setStartRow(startRow.toByteArray());
        }
        if (stopRow != null && stopRow.size() > 0) {
            range.setStopRow(stopRow.toByteArray());
        }
        return range;
    }

    private static class StringArrayOI
    extends BaseStructObjectInspector {
        private int length;

        private StringArrayOI(StructTypeInfo type) {
            ArrayList names = type.getAllStructFieldNames();
            ArrayList<JavaStringObjectInspector> ois = new ArrayList<JavaStringObjectInspector>();
            for (int i = 0; i < names.size(); ++i) {
                ois.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
            }
            this.init(names, ois, null);
        }

        public Object getStructFieldData(Object data, StructField fieldRef) {
            return ((FixedLengthed)data).fields.get(((BaseStructObjectInspector.MyField)fieldRef).getFieldID());
        }

        public List<Object> getStructFieldsDataAsList(Object data) {
            return ((FixedLengthed)data).fields;
        }
    }

    private static class FixedLengthed
    implements LazyObjectBase {
        private final int fixedLength;
        private final List<Object> fields = new ArrayList<Object>();

        public FixedLengthed(int fixedLength) {
            this.fixedLength = fixedLength;
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            this.fields.clear();
            byte[] data = bytes.getData();
            int rowStart = start;
            int rowStop = rowStart + this.fixedLength;
            while (rowStart < length) {
                this.fields.add(new String(data, rowStart, rowStop - rowStart).trim());
                rowStart = rowStop + 1;
                rowStop = rowStart + this.fixedLength;
            }
        }

        public Object getObject() {
            return this;
        }
    }
}

