/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class LazyHBaseRow
extends LazyStruct {
    private Result result;
    private ColumnMappings.ColumnMapping[] columnsMapping;
    private ArrayList<Object> cachedList;
    private final int iKey;
    private final HBaseKeyFactory keyFactory;

    public LazyHBaseRow(LazySimpleStructObjectInspector oi) {
        this(oi, -1, null);
    }

    public LazyHBaseRow(LazySimpleStructObjectInspector oi, int iKey, HBaseKeyFactory keyFactory) {
        super(oi);
        this.iKey = iKey;
        this.keyFactory = keyFactory;
    }

    public void init(Result r, ColumnMappings columnsMappings) {
        this.result = r;
        this.columnsMapping = columnsMappings.getColumnsMapping();
        this.setParsed(false);
    }

    protected LazyObjectBase createLazyField(int fieldID, StructField fieldRef) throws SerDeException {
        if (fieldID == this.iKey) {
            return this.keyFactory.createKey(fieldRef.getFieldObjectInspector());
        }
        ColumnMappings.ColumnMapping colMap = this.columnsMapping[fieldID];
        if (colMap.qualifierName == null && !colMap.hbaseRowKey) {
            return new LazyHBaseCellMap((LazyMapObjectInspector)fieldRef.getFieldObjectInspector());
        }
        return LazyFactory.createLazyObject((ObjectInspector)fieldRef.getFieldObjectInspector(), (boolean)colMap.binaryStorage.get(0));
    }

    public Object getField(int fieldID) {
        this.initFields();
        return this.uncheckedGetField(fieldID);
    }

    private void initFields() {
        if (this.getFields() == null) {
            this.initLazyFields(((LazySimpleStructObjectInspector)this.oi).getAllStructFieldRefs());
        }
        if (!this.getParsed()) {
            Arrays.fill(this.getFieldInited(), false);
            this.setParsed(true);
        }
    }

    private Object uncheckedGetField(int fieldID) {
        LazyObjectBase[] fields = this.getFields();
        boolean[] fieldsInited = this.getFieldInited();
        if (!fieldsInited[fieldID]) {
            ByteArrayRef ref = null;
            ColumnMappings.ColumnMapping colMap = this.columnsMapping[fieldID];
            if (colMap.hbaseRowKey) {
                ref = new ByteArrayRef();
                ref.setData(this.result.getRow());
            } else if (colMap.qualifierName == null) {
                ((LazyHBaseCellMap)fields[fieldID]).init(this.result, colMap.familyNameBytes, colMap.binaryStorage, colMap.qualifierPrefixBytes);
            } else {
                byte[] res = this.result.getValue(colMap.familyNameBytes, colMap.qualifierNameBytes);
                if (res == null) {
                    return null;
                }
                ref = new ByteArrayRef();
                ref.setData(res);
            }
            if (ref != null) {
                fields[fieldID].init(ref, 0, ref.getData().length);
            }
        }
        fieldsInited[fieldID] = true;
        return fields[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        this.initFields();
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

