/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hive.hbase.AbstractHBaseKeyPredicateDecomposer;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseScanRange;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;

class TestHBasePredicateDecomposer
extends AbstractHBaseKeyPredicateDecomposer {
    private static final int FIXED_LENGTH = 10;
    private ColumnMappings.ColumnMapping keyMapping;

    TestHBasePredicateDecomposer(ColumnMappings.ColumnMapping keyMapping) {
        this.keyMapping = keyMapping;
    }

    public HBaseScanRange getScanRange(List<IndexSearchCondition> searchConditions) throws Exception {
        HashMap<String, ArrayList<IndexSearchCondition>> fieldConds = new HashMap<String, ArrayList<IndexSearchCondition>>();
        for (IndexSearchCondition condition : searchConditions) {
            String fieldName = condition.getFields()[0];
            ArrayList<IndexSearchCondition> fieldCond = (ArrayList<IndexSearchCondition>)fieldConds.get(fieldName);
            if (fieldCond == null) {
                fieldCond = new ArrayList<IndexSearchCondition>();
                fieldConds.put(fieldName, fieldCond);
            }
            fieldCond.add(condition);
        }
        RowFilter filter = null;
        HBaseScanRange range = new HBaseScanRange();
        StructTypeInfo type = (StructTypeInfo)this.keyMapping.columnType;
        for (String name : type.getAllStructFieldNames()) {
            List fieldCond = (List)fieldConds.get(name);
            if (fieldCond == null || fieldCond.size() > 2) continue;
            for (IndexSearchCondition condition : fieldCond) {
                if (condition.getConstantDesc().getValue() == null) continue;
                String comparisonOp = condition.getComparisonOp();
                String constantVal = String.valueOf(condition.getConstantDesc().getValue());
                byte[] valueAsBytes = this.toBinary(constantVal, 10, false, false);
                if (comparisonOp.endsWith("UDFOPEqual")) {
                    filter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(valueAsBytes));
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPEqualOrGreaterThan")) {
                    filter = new RowFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(valueAsBytes));
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPGreaterThan")) {
                    filter = new RowFilter(CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new BinaryComparator(valueAsBytes));
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPEqualOrLessThan")) {
                    filter = new RowFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(valueAsBytes));
                    continue;
                }
                if (comparisonOp.endsWith("UDFOPLessThan")) {
                    filter = new RowFilter(CompareFilter.CompareOp.LESS, (ByteArrayComparable)new BinaryComparator(valueAsBytes));
                    continue;
                }
                throw new IOException(comparisonOp + " is not a supported comparison operator");
            }
        }
        if (filter != null) {
            range.addFilter(filter);
        }
        return range;
    }

    private byte[] toBinary(String value, int max, boolean end, boolean nextBA) {
        return this.toBinary(value.getBytes(), max, end, nextBA);
    }

    private byte[] toBinary(byte[] value, int max, boolean end, boolean nextBA) {
        byte[] bytes = new byte[max + 1];
        System.arraycopy(value, 0, bytes, 0, Math.min(value.length, max));
        if (end) {
            Arrays.fill(bytes, value.length, max, (byte)-1);
        }
        if (nextBA) {
            bytes[max] = 1;
        }
        return bytes;
    }
}

