/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.hbase.HBaseSerDeHelper;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ColumnMappings
implements Iterable<ColumnMapping> {
    private final int keyIndex;
    private final ColumnMapping[] columnsMapping;

    public ColumnMappings(List<ColumnMapping> columnMapping, int keyIndex) {
        this.columnsMapping = columnMapping.toArray(new ColumnMapping[columnMapping.size()]);
        this.keyIndex = keyIndex;
    }

    @Override
    public Iterator<ColumnMapping> iterator() {
        return Iterators.forArray((Object[])this.columnsMapping);
    }

    public int size() {
        return this.columnsMapping.length;
    }

    String toNamesString(Properties tbl, String autogenerate) {
        if (autogenerate != null && autogenerate.equals("true")) {
            StringBuilder sb = new StringBuilder();
            HBaseSerDeHelper.generateColumns(tbl, Arrays.asList(this.columnsMapping), sb);
            return sb.toString();
        }
        return "";
    }

    String toTypesString(Properties tbl, Configuration conf, String autogenerate) throws SerDeException {
        StringBuilder sb = new StringBuilder();
        if (autogenerate != null && autogenerate.equals("true")) {
            HBaseSerDeHelper.generateColumnTypes(tbl, Arrays.asList(this.columnsMapping), sb, conf);
        } else {
            for (ColumnMapping colMap : this.columnsMapping) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                if (colMap.hbaseRowKey) {
                    sb.append("string");
                    continue;
                }
                if (colMap.qualifierName == null) {
                    sb.append("map<string,string>");
                    continue;
                }
                sb.append("string");
            }
        }
        return sb.toString();
    }

    void setHiveColumnDescription(String serdeName, List<String> columnNames, List<TypeInfo> columnTypes) throws SerDeException {
        if (this.columnsMapping.length != columnNames.size()) {
            throw new SerDeException(serdeName + ": columns has " + columnNames.size() + " elements while hbase.columns.mapping has " + this.columnsMapping.length + " elements" + " (counting the key if implicit)");
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            TypeInfo typeInfo;
            ColumnMapping colMap = this.columnsMapping[i];
            if (!(colMap.qualifierName != null || colMap.hbaseRowKey || (typeInfo = columnTypes.get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE)) {
                throw new SerDeException(serdeName + ": hbase column family '" + colMap.familyName + "' should be mapped to Map<? extends LazyPrimitive<?, ?>,?>, that is " + "the Key for the map should be of primitive type, but is mapped to " + typeInfo.getTypeName());
            }
            colMap.columnName = columnNames.get(i);
            colMap.columnType = columnTypes.get(i);
        }
    }

    void parseColumnStorageTypes(String hbaseTableDefaultStorageType) throws SerDeException {
        boolean tableBinaryStorage = false;
        if (hbaseTableDefaultStorageType != null && !"".equals(hbaseTableDefaultStorageType)) {
            if (hbaseTableDefaultStorageType.equals("binary")) {
                tableBinaryStorage = true;
            } else if (!hbaseTableDefaultStorageType.equals("string")) {
                throw new SerDeException("Error: hbase.table.default.storage.type parameter must be specified as 'string' or 'binary'; '" + hbaseTableDefaultStorageType + "' is not a valid specification for this table/serde property.");
            }
        }
        for (ColumnMapping colMap : this.columnsMapping) {
            TypeInfo colType = colMap.columnType;
            String mappingSpec = colMap.mappingSpec;
            String[] mapInfo = mappingSpec.split("#");
            String[] storageInfo = null;
            if (mapInfo.length == 2) {
                storageInfo = mapInfo[1].split(":");
            }
            if (storageInfo == null) {
                if (colType.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                    if (!colType.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                if (colType.getCategory() == ObjectInspector.Category.MAP) {
                    TypeInfo keyTypeInfo = ((MapTypeInfo)colType).getMapKeyTypeInfo();
                    TypeInfo valueTypeInfo = ((MapTypeInfo)colType).getMapValueTypeInfo();
                    if (keyTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !keyTypeInfo.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                    if (valueTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !valueTypeInfo.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                colMap.binaryStorage.add(false);
                continue;
            }
            if (storageInfo.length == 1) {
                String storageOption = storageInfo[0];
                if (colType.getCategory() == ObjectInspector.Category.MAP || !storageOption.equals("-") && !"string".startsWith(storageOption) && !"binary".startsWith(storageOption)) {
                    throw new SerDeException("Error: A column storage specification is one of the following: '-', a prefix of 'string', or a prefix of 'binary'. " + storageOption + " is not a valid storage option specification for " + colMap.columnName);
                }
                if (colType.getCategory() == ObjectInspector.Category.PRIMITIVE && !colType.getTypeName().equals("string")) {
                    if ("-".equals(storageOption)) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    if ("binary".startsWith(storageOption)) {
                        colMap.binaryStorage.add(true);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                colMap.binaryStorage.add(false);
                continue;
            }
            if (storageInfo.length == 2) {
                String keyStorage = storageInfo[0];
                String valStorage = storageInfo[1];
                if (colType.getCategory() != ObjectInspector.Category.MAP || !keyStorage.equals("-") && !"string".startsWith(keyStorage) && !"binary".startsWith(keyStorage) || !valStorage.equals("-") && !"string".startsWith(valStorage) && !"binary".startsWith(valStorage)) {
                    throw new SerDeException("Error: To specify a valid column storage type for a Map column, use any two specifiers from '-', a prefix of 'string',  and a prefix of 'binary' separated by a ':'. Valid examples are '-:-', 's:b', etc. They specify the storage type for the key and value parts of the Map<?,?> respectively. Invalid storage specification for column " + colMap.columnName + "; " + storageInfo[0] + ":" + storageInfo[1]);
                }
                TypeInfo keyTypeInfo = ((MapTypeInfo)colType).getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = ((MapTypeInfo)colType).getMapValueTypeInfo();
                if (keyTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !keyTypeInfo.getTypeName().equals("string")) {
                    if (keyStorage.equals("-")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else if ("binary".startsWith(keyStorage)) {
                        colMap.binaryStorage.add(true);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                } else {
                    colMap.binaryStorage.add(false);
                }
                if (valueTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !valueTypeInfo.getTypeName().equals("string")) {
                    if (valStorage.equals("-")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else if ("binary".startsWith(valStorage)) {
                        colMap.binaryStorage.add(true);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                } else {
                    colMap.binaryStorage.add(false);
                }
                if (colMap.binaryStorage.size() == 2) continue;
                throw new SerDeException("Error: In parsing the storage specification for column " + colMap.columnName);
            }
            throw new SerDeException("Error: hbase.columns.mapping storage specification " + mappingSpec + " is not valid for column: " + colMap.columnName);
        }
    }

    public ColumnMapping getKeyMapping() {
        return this.columnsMapping[this.keyIndex];
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public ColumnMapping[] getColumnsMapping() {
        return this.columnsMapping;
    }

    public static class ColumnMapping {
        String columnName;
        TypeInfo columnType;
        String familyName;
        String qualifierName;
        byte[] familyNameBytes;
        byte[] qualifierNameBytes;
        List<Boolean> binaryStorage = new ArrayList<Boolean>(2);
        boolean hbaseRowKey;
        String mappingSpec;
        String qualifierPrefix;
        byte[] qualifierPrefixBytes;

        ColumnMapping() {
        }

        public String getColumnName() {
            return this.columnName;
        }

        public TypeInfo getColumnType() {
            return this.columnType;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public String getQualifierName() {
            return this.qualifierName;
        }

        public byte[] getFamilyNameBytes() {
            return this.familyNameBytes;
        }

        public byte[] getQualifierNameBytes() {
            return this.qualifierNameBytes;
        }

        public List<Boolean> getBinaryStorage() {
            return this.binaryStorage;
        }

        public boolean isHbaseRowKey() {
            return this.hbaseRowKey;
        }

        public String getMappingSpec() {
            return this.mappingSpec;
        }

        public String getQualifierPrefix() {
            return this.qualifierPrefix;
        }

        public byte[] getQualifierPrefixBytes() {
            return this.qualifierPrefixBytes;
        }

        public boolean isCategory(ObjectInspector.Category category) {
            return this.columnType.getCategory() == category;
        }
    }
}

