/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveHBaseTableInputFormat
extends TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, ResultWritable> {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableInputFormat.class);

    public org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        String scanBatch;
        String scanCacheBlocks;
        String scanCache;
        HBaseSplit hbaseSplit = (HBaseSplit)split;
        TableSplit tableSplit = hbaseSplit.getSplit();
        String hbaseTableName = jobConf.get("hbase.table.name");
        this.setHTable(new HTable(HBaseConfiguration.create((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName)));
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        List readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
        List<HBaseSerDe.ColumnMapping> columnsMapping = null;
        try {
            columnsMapping = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        if (columnsMapping.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean readAllColumns = ColumnProjectionUtils.isReadAllColumns((Configuration)jobConf);
        Scan scan = new Scan();
        boolean empty = true;
        ArrayList<String> addedFamilies = new ArrayList<String>();
        if (!readAllColumns) {
            Iterator i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                HBaseSerDe.ColumnMapping colMap = columnsMapping.get(i);
                if (colMap.hbaseRowKey) continue;
                if (colMap.qualifierName == null) {
                    scan.addFamily(colMap.familyNameBytes);
                    addedFamilies.add(colMap.familyName);
                } else if (!addedFamilies.contains(colMap.familyName)) {
                    scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
                }
                empty = false;
            }
        }
        if (empty) {
            for (int i = 0; i < columnsMapping.size(); ++i) {
                HBaseSerDe.ColumnMapping colMap = columnsMapping.get(i);
                if (colMap.hbaseRowKey) continue;
                if (colMap.qualifierName == null) {
                    scan.addFamily(colMap.familyNameBytes);
                } else {
                    scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
                }
                if (!readAllColumns) break;
            }
        }
        if ((scanCache = jobConf.get("hbase.scan.cache")) != null) {
            scan.setCaching(Integer.valueOf(scanCache).intValue());
        }
        if ((scanCacheBlocks = jobConf.get("hbase.scan.cacheblock")) != null) {
            scan.setCacheBlocks(Boolean.valueOf(scanCacheBlocks).booleanValue());
        }
        if ((scanBatch = jobConf.get("hbase.scan.batch")) != null) {
            scan.setBatch(Integer.valueOf(scanBatch).intValue());
        }
        this.setScan(scan);
        Job job = new Job((Configuration)jobConf);
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext(job.getConfiguration(), (Progressable)reporter);
        final RecordReader recordReader = this.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
        try {
            recordReader.initialize((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to initialize RecordReader", e);
        }
        return new org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable>(){

            public void close() throws IOException {
                recordReader.close();
            }

            public ImmutableBytesWritable createKey() {
                return new ImmutableBytesWritable();
            }

            public ResultWritable createValue() {
                return new ResultWritable(new Result());
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public float getProgress() throws IOException {
                float progress = 0.0f;
                try {
                    progress = recordReader.getProgress();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return progress;
            }

            public boolean next(ImmutableBytesWritable rowKey, ResultWritable value) throws IOException {
                boolean next = false;
                try {
                    next = recordReader.nextKeyValue();
                    if (next) {
                        rowKey.set(((Result)recordReader.getCurrentValue()).getRow());
                        value.setResult((Result)recordReader.getCurrentValue());
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return next;
            }
        };
    }

    private Scan createFilterScan(JobConf jobConf, int iKey, boolean isKeyBinary) throws IOException {
        ArrayList searchConditions;
        String colType;
        Scan scan = new Scan();
        String filterExprSerialized = jobConf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized == null) {
            return scan;
        }
        ExprNodeGenericFuncDesc filterExpr = Utilities.deserializeExpression((String)filterExprSerialized);
        String colName = jobConf.get("columns").split(",")[iKey];
        IndexPredicateAnalyzer analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(colName, colType = jobConf.get("columns.types").split(",")[iKey], isKeyBinary);
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate((ExprNodeDesc)filterExpr, searchConditions = new ArrayList());
        if (residualPredicate != null) {
            LOG.debug((Object)("Ignoring residual predicate " + residualPredicate.getExprString()));
        }
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        for (IndexSearchCondition sc : searchConditions) {
            Object writable;
            PrimitiveObjectInspector objInspector;
            ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
            try {
                objInspector = (PrimitiveObjectInspector)eval.initialize(null);
                writable = eval.evaluate(null);
            }
            catch (ClassCastException cce) {
                throw new IOException("Currently only primitve types are supported. Found: " + sc.getConstantDesc().getTypeString());
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
            byte[] constantVal = this.getConstantVal(writable, objInspector, isKeyBinary);
            String comparisonOp = sc.getComparisonOp();
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual".equals(comparisonOp)) {
                startRow = constantVal;
                stopRow = this.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan".equals(comparisonOp)) {
                stopRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan".equals(comparisonOp)) {
                startRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan".equals(comparisonOp)) {
                startRow = this.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan".equals(comparisonOp)) {
                stopRow = this.getNextBA(constantVal);
                continue;
            }
            throw new IOException(comparisonOp + " is not a supported comparison operator");
        }
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        return scan;
    }

    private byte[] getConstantVal(Object writable, PrimitiveObjectInspector poi, boolean isKeyBinary) throws IOException {
        if (!isKeyBinary) {
            ByteStream.Output serializeStream = new ByteStream.Output();
            LazyUtils.writePrimitiveUTF8((OutputStream)serializeStream, (Object)writable, (PrimitiveObjectInspector)poi, (boolean)false, (byte)0, null);
            byte[] startRow = new byte[serializeStream.getCount()];
            System.arraycopy(serializeStream.getData(), 0, startRow, 0, serializeStream.getCount());
            return startRow;
        }
        PrimitiveObjectInspector.PrimitiveCategory pc = poi.getPrimitiveCategory();
        switch (poi.getPrimitiveCategory()) {
            case INT: {
                return Bytes.toBytes((int)((IntWritable)writable).get());
            }
            case BOOLEAN: {
                return Bytes.toBytes((boolean)((BooleanWritable)writable).get());
            }
            case LONG: {
                return Bytes.toBytes((long)((LongWritable)writable).get());
            }
            case FLOAT: {
                return Bytes.toBytes((float)((FloatWritable)writable).get());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((DoubleWritable)writable).get());
            }
            case SHORT: {
                return Bytes.toBytes((short)((ShortWritable)writable).get());
            }
            case STRING: {
                return Bytes.toBytes((String)((Text)writable).toString());
            }
            case BYTE: {
                return Bytes.toBytes((short)((ByteWritable)writable).get());
            }
        }
        throw new IOException("Type not supported " + pc);
    }

    private byte[] getNextBA(byte[] current) {
        byte[] next = new byte[current.length + 1];
        System.arraycopy(current, 0, next, 0, current.length);
        return next;
    }

    static IndexPredicateAnalyzer newIndexPredicateAnalyzer(String keyColumnName, String keyColType, boolean isKeyBinary) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual");
        if (isKeyBinary || keyColType.equalsIgnoreCase("string")) {
            analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan");
            analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan");
            analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan");
            analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan");
        }
        analyzer.clearAllowedColumnNames();
        analyzer.allowColumnName(keyColumnName);
        return analyzer;
    }

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        int iKey;
        TableMapReduceUtil.initCredentials((JobConf)jobConf);
        String hbaseTableName = jobConf.get("hbase.table.name");
        this.setHTable(new HTable(HBaseConfiguration.create((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName)));
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        if (hbaseColumnsMapping == null) {
            throw new IOException("hbase.columns.mapping required for HBase Table.");
        }
        List<HBaseSerDe.ColumnMapping> columnsMapping = null;
        try {
            columnsMapping = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        try {
            iKey = HBaseSerDe.getRowKeyColumnOffset(columnsMapping);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        Scan scan = this.createFilterScan(jobConf, iKey, this.getStorageFormatOfKey(columnsMapping.get((int)iKey).mappingSpec, jobConf.get("hbase.table.default.storage.type", "string")));
        ArrayList<String> addedFamilies = new ArrayList<String>();
        for (int i = 0; i < columnsMapping.size(); ++i) {
            HBaseSerDe.ColumnMapping colMap = columnsMapping.get(i);
            if (colMap.hbaseRowKey) continue;
            if (colMap.qualifierName == null) {
                scan.addFamily(colMap.familyNameBytes);
                addedFamilies.add(colMap.familyName);
                continue;
            }
            if (addedFamilies.contains(colMap.familyName)) continue;
            scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
        }
        this.setScan(scan);
        Job job = new Job((Configuration)jobConf);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
        List splits = super.getSplits(jobContext);
        InputSplit[] results = new InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            results[i] = new HBaseSplit((TableSplit)splits.get(i), tablePaths[0]);
        }
        return results;
    }

    private boolean getStorageFormatOfKey(String spec, String defaultFormat) throws IOException {
        String[] mapInfo = spec.split("#");
        boolean tblLevelDefault = "binary".equalsIgnoreCase(defaultFormat);
        switch (mapInfo.length) {
            case 1: {
                return tblLevelDefault;
            }
            case 2: {
                String storageType = mapInfo[1];
                if (storageType.equals("-")) {
                    return tblLevelDefault;
                }
                if ("string".startsWith(storageType)) {
                    return false;
                }
                if (!"binary".startsWith(storageType)) break;
                return true;
            }
        }
        throw new IOException("Malformed string: " + spec);
    }
}

