/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;

public class HiveHBaseTableOutputFormat
extends TableOutputFormat<ImmutableBytesWritable>
implements OutputFormat<ImmutableBytesWritable, Object> {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableOutputFormat.class);
    public static final String HBASE_WAL_ENABLED = "hive.hbase.wal.enabled";

    public void checkOutputSpecs(FileSystem fs, JobConf jc) throws IOException {
        TableMapReduceUtil.initCredentials((JobConf)jc);
        String hbaseTableName = jc.get("hbase.table.name");
        jc.set("hbase.mapred.outputtable", hbaseTableName);
        Job job = new Job((Configuration)jc);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        try {
            this.checkOutputSpecs(jobContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public RecordWriter<ImmutableBytesWritable, Object> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String name, Progressable progressable) throws IOException {
        String hbaseTableName = jobConf.get("hbase.table.name");
        jobConf.set("hbase.mapred.outputtable", hbaseTableName);
        boolean walEnabled = HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_WAL_ENABLED);
        HTable table = new HTable(HBaseConfiguration.create((Configuration)jobConf), hbaseTableName);
        table.setAutoFlush(false);
        return new MyRecordWriter(table, walEnabled);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    private static class MyRecordWriter
    implements RecordWriter<ImmutableBytesWritable, Object> {
        private final HTable m_table;
        private final boolean m_walEnabled;

        public MyRecordWriter(HTable table, boolean walEnabled) {
            this.m_table = table;
            this.m_walEnabled = walEnabled;
        }

        public void close(Reporter reporter) throws IOException {
            this.m_table.close();
        }

        public void write(ImmutableBytesWritable key, Object value) throws IOException {
            Put put;
            if (value instanceof Put) {
                put = (Put)value;
            } else if (value instanceof PutWritable) {
                put = new Put(((PutWritable)value).getPut());
            } else {
                throw new IllegalArgumentException("Illegal Argument " + (value == null ? "null" : value.getClass().getName()));
            }
            if (this.m_walEnabled) {
                put.setDurability(Durability.SYNC_WAL);
            } else {
                put.setDurability(Durability.SKIP_WAL);
            }
            this.m_table.put(put);
        }
    }
}

