/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.MapRDbJsonUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MapRDbJsonUpdateSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 753: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 754: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 813: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 756: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 780: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 885: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 886: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 887: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 658: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 659: 
                    case 660: 
                    case 661: 
                    case 662: 
                    case 667: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 676: 
                    case 677: 
                    case 679: 
                    case 682: 
                    case 684: 
                    case 685: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 688: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 689: 
                    case 690: 
                    case 691: 
                    case 692: 
                    case 693: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 878);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 650: 
            case 654: 
            case 655: 
            case 656: 
            case 657: 
            case 665: 
            case 701: 
            case 709: 
            case 711: 
            case 714: 
            case 733: 
            case 734: 
            case 735: 
            case 742: 
            case 744: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 768: 
            case 770: 
            case 814: 
            case 815: 
            case 820: 
            case 892: 
            case 893: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 949: 
            case 992: 
            case 1000: 
            case 1001: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 710: 
            case 743: 
            case 882: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 694: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 713: 
            case 745: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 732: 
            case 818: 
            case 1003: {
                HiveConf hiveConf = queryState.getConf();
                if (MapRDbJsonUtils.isMapRDbJsonTable(tree, hiveConf)) {
                    return new MapRDbJsonUpdateSemanticAnalyzer(queryState);
                }
                if (AcidUtils.isAcidTable(tree, hiveConf)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                throw new SemanticException("Operation is not supported. Table is nor ACID neither MapRDbJSON");
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(queryState.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(753, HiveOperation.EXPLAIN);
        commandType.put(813, HiveOperation.LOAD);
        commandType.put(756, HiveOperation.EXPORT);
        commandType.put(780, HiveOperation.IMPORT);
        commandType.put(709, HiveOperation.CREATEDATABASE);
        commandType.put(742, HiveOperation.DROPDATABASE);
        commandType.put(949, HiveOperation.SWITCHDATABASE);
        commandType.put(715, HiveOperation.CREATETABLE);
        commandType.put(992, HiveOperation.TRUNCATETABLE);
        commandType.put(747, HiveOperation.DROPTABLE);
        commandType.put(735, HiveOperation.DESCTABLE);
        commandType.put(734, HiveOperation.DESCFUNCTION);
        commandType.put(820, HiveOperation.MSCK);
        commandType.put(659, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(679, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(677, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(676, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(668, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(661, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(684, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(662, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(685, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(675, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(669, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(670, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(667, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(660, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(913, HiveOperation.SHOWDATABASES);
        commandType.put(919, HiveOperation.SHOWTABLES);
        commandType.put(911, HiveOperation.SHOWCOLUMNS);
        commandType.put(929, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(930, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(922, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(923, HiveOperation.SHOW_CREATETABLE);
        commandType.put(915, HiveOperation.SHOWFUNCTIONS);
        commandType.put(916, HiveOperation.SHOWINDEXES);
        commandType.put(918, HiveOperation.SHOWPARTITIONS);
        commandType.put(917, HiveOperation.SHOWLOCKS);
        commandType.put(914, HiveOperation.SHOWLOCKS);
        commandType.put(912, HiveOperation.SHOWCONF);
        commandType.put(920, HiveOperation.SHOWVIEWS);
        commandType.put(710, HiveOperation.CREATEFUNCTION);
        commandType.put(743, HiveOperation.DROPFUNCTION);
        commandType.put(882, HiveOperation.RELOADFUNCTION);
        commandType.put(713, HiveOperation.CREATEMACRO);
        commandType.put(745, HiveOperation.DROPMACRO);
        commandType.put(716, HiveOperation.CREATEVIEW);
        commandType.put(717, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(748, HiveOperation.DROPVIEW);
        commandType.put(749, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(711, HiveOperation.CREATEINDEX);
        commandType.put(744, HiveOperation.DROPINDEX);
        commandType.put(657, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(656, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(692, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(691, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(689, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(690, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(693, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(688, HiveOperation.ALTERVIEW_AS);
        commandType.put(878, HiveOperation.QUERY);
        commandType.put(815, HiveOperation.LOCKTABLE);
        commandType.put(1001, HiveOperation.UNLOCKTABLE);
        commandType.put(814, HiveOperation.LOCKDB);
        commandType.put(1000, HiveOperation.UNLOCKDB);
        commandType.put(714, HiveOperation.CREATEROLE);
        commandType.put(746, HiveOperation.DROPROLE);
        commandType.put(768, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(892, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(924, HiveOperation.SHOW_GRANT);
        commandType.put(770, HiveOperation.GRANT_ROLE);
        commandType.put(893, HiveOperation.REVOKE_ROLE);
        commandType.put(925, HiveOperation.SHOW_ROLES);
        commandType.put(928, HiveOperation.SHOW_ROLES);
        commandType.put(927, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(926, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(655, HiveOperation.ALTERDATABASE);
        commandType.put(654, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(733, HiveOperation.DESCDATABASE);
        commandType.put(682, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(694, HiveOperation.ANALYZE_TABLE);
        commandType.put(701, HiveOperation.CACHE_METADATA);
        commandType.put(674, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(921, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(931, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(650, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(937, HiveOperation.START_TRANSACTION);
        commandType.put(708, HiveOperation.COMMIT);
        commandType.put(898, HiveOperation.ROLLBACK);
        commandType.put(909, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(885, HiveOperation.EXPORT);
        commandType.put(886, HiveOperation.IMPORT);
        commandType.put(887, HiveOperation.SHOW_TBLPROPERTIES);
        tablePartitionCommandType.put(671, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(672, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(673, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(681, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(680, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(678, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(666, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(683, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(663, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(665, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(686, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(687, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

