/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableAccessInfo;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSemanticAnalyzer {
    protected static final Logger STATIC_LOG = LoggerFactory.getLogger((String)BaseSemanticAnalyzer.class.getName());
    protected final Hive db;
    protected final HiveConf conf;
    protected final QueryState queryState;
    protected List<Task<? extends Serializable>> rootTasks;
    protected FetchTask fetchTask;
    protected final Logger LOG;
    protected final SessionState.LogHelper console;
    protected CompilationOpContext cContext;
    protected Context ctx;
    protected HashMap<String, String> idToTableNameMap;
    protected QueryProperties queryProperties;
    protected Set<FileSinkDesc> acidFileSinks = new HashSet<FileSinkDesc>();
    protected boolean acidInQuery;
    public static final int HIVE_COLUMN_ORDER_ASC = 1;
    public static final int HIVE_COLUMN_ORDER_DESC = 0;
    public static final int HIVE_COLUMN_NULLS_FIRST = 0;
    public static final int HIVE_COLUMN_NULLS_LAST = 1;
    protected HashSet<ReadEntity> inputs;
    protected HashSet<WriteEntity> outputs;
    protected LineageInfo linfo;
    protected TableAccessInfo tableAccessInfo;
    protected ColumnAccessInfo columnAccessInfo;
    protected ColumnAccessInfo updateColumnAccessInfo;
    private Boolean autoCommitValue;

    public Boolean getAutoCommitValue() {
        return this.autoCommitValue;
    }

    void setAutoCommitValue(Boolean autoCommit) {
        this.autoCommitValue = autoCommit;
    }

    public boolean skipAuthorization() {
        return false;
    }

    public BaseSemanticAnalyzer(QueryState queryState) throws SemanticException {
        this(queryState, BaseSemanticAnalyzer.createHiveDB(queryState.getConf()));
    }

    public BaseSemanticAnalyzer(QueryState queryState, Hive db) throws SemanticException {
        try {
            this.queryState = queryState;
            this.conf = queryState.getConf();
            this.db = db;
            this.rootTasks = new ArrayList<Task<? extends Serializable>>();
            this.LOG = LoggerFactory.getLogger((String)this.getClass().getName());
            this.console = new SessionState.LogHelper(this.LOG);
            this.idToTableNameMap = new HashMap();
            this.inputs = new LinkedHashSet<ReadEntity>();
            this.outputs = new LinkedHashSet<WriteEntity>();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    protected static Hive createHiveDB(HiveConf conf) throws SemanticException {
        try {
            return Hive.get(conf);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
    }

    public HashMap<String, String> getIdToTableNameMap() {
        return this.idToTableNameMap;
    }

    public abstract void analyzeInternal(ASTNode var1) throws SemanticException;

    public void init(boolean clearPartsCache) {
    }

    public void initCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void analyze(ASTNode ast, Context ctx) throws SemanticException {
        this.initCtx(ctx);
        this.init(true);
        this.analyzeInternal(ast);
    }

    public void validate() throws SemanticException {
    }

    public List<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(FetchTask fetchTask) {
        this.fetchTask = fetchTask;
    }

    protected void reset(boolean clearPartsCache) {
        this.rootTasks = new ArrayList<Task<? extends Serializable>>();
    }

    public static String stripIdentifierQuotes(String val) {
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static String stripQuotes(String val) {
        return PlanUtils.stripQuotes(val);
    }

    public static String charSetString(String charSetName, String charSetString) throws SemanticException {
        try {
            charSetName = charSetName.substring(1);
            if (charSetString.charAt(0) == '\'') {
                return new String(BaseSemanticAnalyzer.unescapeSQLString(charSetString).getBytes(), charSetName);
            }
            assert (charSetString.charAt(0) == '0');
            assert (charSetString.charAt(1) == 'x');
            charSetString = charSetString.substring(2);
            byte[] bArray = new byte[charSetString.length() / 2];
            int j = 0;
            for (int i = 0; i < charSetString.length(); i += 2) {
                int val = Character.digit(charSetString.charAt(i), 16) * 16 + Character.digit(charSetString.charAt(i + 1), 16);
                if (val > 127) {
                    val -= 256;
                }
                bArray[j++] = (byte)val;
            }
            String res = new String(bArray, charSetName);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new SemanticException(e);
        }
    }

    public static String getUnescapedName(ASTNode tableOrColumnNode) throws SemanticException {
        return BaseSemanticAnalyzer.getUnescapedName(tableOrColumnNode, null);
    }

    public static Map.Entry<String, String> getDbTableNamePair(ASTNode tableNameNode) throws SemanticException {
        if (tableNameNode.getType() != 978 || tableNameNode.getChildCount() != 1 && tableNameNode.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME.getMsg(tableNameNode));
        }
        if (tableNameNode.getChildCount() == 2) {
            String dbName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
            String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(1).getText());
            if (dbName.contains(".") || tableName.contains(".")) {
                throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tableNameNode));
            }
            return Pair.of(dbName, tableName);
        }
        String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
        if (tableName.contains(".")) {
            throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tableNameNode));
        }
        return Pair.of(null, tableName);
    }

    public static String getUnescapedName(ASTNode tableOrColumnNode, String currentDatabase) throws SemanticException {
        int tokenType = tableOrColumnNode.getToken().getType();
        if (tokenType == 978) {
            Map.Entry<String, String> dbTablePair = BaseSemanticAnalyzer.getDbTableNamePair(tableOrColumnNode);
            String dbName = dbTablePair.getKey();
            String tableName = dbTablePair.getValue();
            if (dbName != null) {
                return dbName + "." + tableName;
            }
            if (currentDatabase != null) {
                return currentDatabase + "." + tableName;
            }
            return tableName;
        }
        if (tokenType == 353) {
            return BaseSemanticAnalyzer.unescapeSQLString(tableOrColumnNode.getText());
        }
        return BaseSemanticAnalyzer.unescapeIdentifier(tableOrColumnNode.getText());
    }

    public static String[] getQualifiedTableName(ASTNode tabNameNode) throws SemanticException {
        if (tabNameNode.getType() != 978 || tabNameNode.getChildCount() != 1 && tabNameNode.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME.getMsg(tabNameNode));
        }
        if (tabNameNode.getChildCount() == 2) {
            String dbName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
            String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(1).getText());
            if (dbName.contains(".") || tableName.contains(".")) {
                throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tabNameNode));
            }
            return new String[]{dbName, tableName};
        }
        String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
        if (tableName.contains(".")) {
            throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tabNameNode));
        }
        return Utilities.getDbTableName(tableName);
    }

    public static String getDotName(String[] qname) throws SemanticException {
        String genericName = StringUtils.join((Object[])qname, ".");
        if (qname.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, genericName);
        }
        return genericName;
    }

    public static String getUnescapedUnqualifiedTableName(ASTNode node) throws SemanticException {
        assert (node.getChildCount() <= 2);
        if (node.getChildCount() == 2) {
            node = (ASTNode)node.getChild(1);
        }
        return BaseSemanticAnalyzer.getUnescapedName(node);
    }

    public static String unescapeIdentifier(String val) {
        if (val == null) {
            return null;
        }
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static void readProps(ASTNode prop, Map<String, String> mapProp) {
        for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
            String key = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
            String value = null;
            if (prop.getChild(propChild).getChild(1) != null) {
                value = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
            }
            mapProp.put(key, value);
        }
    }

    public static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < b.length() && b.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(b.charAt(j + base), 16);
                    code = (code << 4) + digit;
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String escapeSQLString(String b) {
        String result = b;
        block11: for (int i = 0; i < result.length(); ++i) {
            char nextChar;
            char currentChar = result.charAt(i);
            if (currentChar == '\\' && i + 1 < result.length() && ((nextChar = result.charAt(i + 1)) == '%' || nextChar == '_')) {
                ++i;
                continue;
            }
            switch (currentChar) {
                case '\u0000': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\0");
                    ++i;
                    continue block11;
                }
                case '\'': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\'");
                    ++i;
                    continue block11;
                }
                case '\"': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\\"");
                    ++i;
                    continue block11;
                }
                case '\b': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\b");
                    ++i;
                    continue block11;
                }
                case '\n': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\n");
                    ++i;
                    continue block11;
                }
                case '\r': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\r");
                    ++i;
                    continue block11;
                }
                case '\t': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\t");
                    ++i;
                    continue block11;
                }
                case '\\': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\\\");
                    ++i;
                    continue block11;
                }
                case '\u001a': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\Z");
                    ++i;
                    continue block11;
                }
                default: {
                    if (currentChar >= ' ') continue block11;
                    String hex = Integer.toHexString(currentChar);
                    String unicode = "\\u";
                    for (int j = 4; j > hex.length(); --j) {
                        unicode = unicode + '0';
                    }
                    unicode = unicode + hex;
                    result = BaseSemanticAnalyzer.spliceString(result, i, unicode);
                    i += unicode.length() - 1;
                }
            }
        }
        return result;
    }

    private static String spliceString(String str, int i, String replacement) {
        return BaseSemanticAnalyzer.spliceString(str, i, 1, replacement);
    }

    private static String spliceString(String str, int i, int length, String replacement) {
        return str.substring(0, i) + replacement + str.substring(i + length);
    }

    public HashSet<ReadEntity> getInputs() {
        return this.inputs;
    }

    public HashSet<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public List<FieldSchema> getResultSchema() {
        return null;
    }

    protected List<FieldSchema> getColumns(ASTNode ast) throws SemanticException {
        return BaseSemanticAnalyzer.getColumns(ast, true);
    }

    public static List<FieldSchema> getColumns(ASTNode ast, boolean lowerCase) throws SemanticException {
        return BaseSemanticAnalyzer.getColumns(ast, lowerCase, new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>());
    }

    private static void processPrimaryKeyInfos(ASTNode child, List<PKInfo> pkInfos) throws SemanticException {
        if (child.getChildCount() < 4) {
            throw new SemanticException(ErrorMsg.INVALID_PK_SYNTAX.getMsg());
        }
        boolean userSpecifiedConstraintName = child.getChildCount() == 5;
        int relyIndex = child.getChildCount() == 5 ? 2 : 1;
        for (int j = 0; j < child.getChild(0).getChildCount(); ++j) {
            boolean validate;
            Tree grandChild = child.getChild(0).getChild(j);
            boolean rely = child.getChild(relyIndex).getType() == 1008;
            boolean enable = child.getChild(relyIndex + 1).getType() == 750;
            boolean bl = validate = child.getChild(relyIndex + 2).getType() == 1008;
            if (enable) {
                throw new SemanticException(ErrorMsg.INVALID_PK_SYNTAX.getMsg(" ENABLE feature not supported yet"));
            }
            if (validate) {
                throw new SemanticException(ErrorMsg.INVALID_PK_SYNTAX.getMsg(" VALIDATE feature not supported yet"));
            }
            BaseSemanticAnalyzer.checkColumnName(grandChild.getText());
            pkInfos.add(new PKInfo(BaseSemanticAnalyzer.unescapeIdentifier(grandChild.getText().toLowerCase()), userSpecifiedConstraintName ? BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(1).getText().toLowerCase()) : null, rely));
        }
    }

    private static void processPrimaryKeys(ASTNode parent, List<PKInfo> pkInfos, List<SQLPrimaryKey> primaryKeys, Map<String, FieldSchema> nametoFS) throws SemanticException {
        int cnt = 1;
        String[] qualifiedTabName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
        for (int i = 0; i < pkInfos.size(); ++i) {
            String pk = pkInfos.get((int)i).colName;
            if (!nametoFS.containsKey(pk)) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(pk));
            }
            SQLPrimaryKey currPrimaryKey = new SQLPrimaryKey(qualifiedTabName[0], qualifiedTabName[1], pk, cnt++, pkInfos.get((int)i).constraintName, false, false, pkInfos.get((int)i).rely);
            primaryKeys.add(currPrimaryKey);
        }
    }

    protected static void processPrimaryKeys(ASTNode parent, ASTNode child, List<SQLPrimaryKey> primaryKeys) throws SemanticException {
        int relyIndex = 2;
        int cnt = 1;
        String[] qualifiedTabName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
        for (int j = 0; j < child.getChild(0).getChildCount(); ++j) {
            boolean validate;
            Tree grandChild = child.getChild(0).getChild(j);
            boolean rely = child.getChild(relyIndex).getType() == 1008;
            boolean enable = child.getChild(relyIndex + 1).getType() == 750;
            boolean bl = validate = child.getChild(relyIndex + 2).getType() == 1008;
            if (enable) {
                throw new SemanticException(ErrorMsg.INVALID_PK_SYNTAX.getMsg(" ENABLE feature not supported yet"));
            }
            if (validate) {
                throw new SemanticException(ErrorMsg.INVALID_PK_SYNTAX.getMsg(" VALIDATE feature not supported yet"));
            }
            primaryKeys.add(new SQLPrimaryKey(qualifiedTabName[0], qualifiedTabName[1], BaseSemanticAnalyzer.unescapeIdentifier(grandChild.getText().toLowerCase()), cnt++, BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(1).getText().toLowerCase()), false, false, rely));
        }
    }

    protected static void processForeignKeys(ASTNode parent, ASTNode child, List<SQLForeignKey> foreignKeys) throws SemanticException {
        String[] qualifiedTabName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
        boolean userSpecifiedConstraintName = child.getChildCount() == 7;
        int fkIndex = userSpecifiedConstraintName ? 1 : 0;
        int ptIndex = fkIndex + 1;
        int pkIndex = ptIndex + 1;
        int relyIndex = pkIndex + 1;
        if (child.getChildCount() <= fkIndex || child.getChildCount() <= pkIndex || child.getChildCount() <= ptIndex) {
            throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg());
        }
        String[] parentDBTbl = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)child.getChild(ptIndex));
        if (child.getChild(fkIndex).getChildCount() != child.getChild(pkIndex).getChildCount()) {
            throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg(" The number of foreign key columns should be same as number of parent key columns "));
        }
        for (int j = 0; j < child.getChild(fkIndex).getChildCount(); ++j) {
            boolean validate;
            SQLForeignKey sqlForeignKey = new SQLForeignKey();
            Tree fkgrandChild = child.getChild(fkIndex).getChild(j);
            BaseSemanticAnalyzer.checkColumnName(fkgrandChild.getText());
            boolean rely = child.getChild(relyIndex).getType() == 1008;
            boolean enable = child.getChild(relyIndex + 1).getType() == 750;
            boolean bl = validate = child.getChild(relyIndex + 2).getType() == 1008;
            if (enable) {
                throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg(" ENABLE feature not supported yet"));
            }
            if (validate) {
                throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg(" VALIDATE feature not supported yet"));
            }
            sqlForeignKey.setRely_cstr(rely);
            sqlForeignKey.setPktable_db(parentDBTbl[0]);
            sqlForeignKey.setPktable_name(parentDBTbl[1]);
            sqlForeignKey.setFktable_db(qualifiedTabName[0]);
            sqlForeignKey.setFktable_name(qualifiedTabName[1]);
            sqlForeignKey.setFkcolumn_name(BaseSemanticAnalyzer.unescapeIdentifier(fkgrandChild.getText().toLowerCase()));
            Tree pkgrandChild = child.getChild(pkIndex).getChild(j);
            sqlForeignKey.setPkcolumn_name(BaseSemanticAnalyzer.unescapeIdentifier(pkgrandChild.getText().toLowerCase()));
            sqlForeignKey.setKey_seq(j + 1);
            if (userSpecifiedConstraintName) {
                sqlForeignKey.setFk_name(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText().toLowerCase()));
            }
            foreignKeys.add(sqlForeignKey);
        }
    }

    private static void checkColumnName(String columnName) throws SemanticException {
        if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(columnName.toUpperCase())) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN_NAME.getMsg(columnName));
        }
    }

    public static List<FieldSchema> getColumns(ASTNode ast, boolean lowerCase, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws SemanticException {
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        int numCh = ast.getChildCount();
        ArrayList<PKInfo> pkInfos = new ArrayList<PKInfo>();
        HashMap<String, FieldSchema> nametoFS = new HashMap<String, FieldSchema>();
        Tree parent = ast.getParent();
        for (int i = 0; i < numCh; ++i) {
            FieldSchema col = new FieldSchema();
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() == 860) {
                BaseSemanticAnalyzer.processPrimaryKeyInfos(child, pkInfos);
                continue;
            }
            if (child.getToken().getType() == 762) {
                BaseSemanticAnalyzer.processForeignKeys((ASTNode)parent, child, foreignKeys);
                continue;
            }
            Tree grandChild = child.getChild(0);
            if (grandChild != null) {
                String name = grandChild.getText();
                if (lowerCase) {
                    name = name.toLowerCase();
                }
                BaseSemanticAnalyzer.checkColumnName(name);
                col.setName(BaseSemanticAnalyzer.unescapeIdentifier(name));
                ASTNode typeChild = (ASTNode)child.getChild(1);
                col.setType(BaseSemanticAnalyzer.getTypeStringFromAST(typeChild));
                if (child.getChildCount() == 3) {
                    col.setComment(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                }
            }
            nametoFS.put(col.getName(), col);
            colList.add(col);
        }
        if (!pkInfos.isEmpty()) {
            BaseSemanticAnalyzer.processPrimaryKeys((ASTNode)parent, pkInfos, primaryKeys, nametoFS);
        }
        return colList;
    }

    public static List<String> getColumnNames(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(BaseSemanticAnalyzer.unescapeIdentifier(child.getText()).toLowerCase());
        }
        return colList;
    }

    protected List<Order> getColumnNamesOrder(ASTNode ast) throws SemanticException {
        ArrayList<Order> colList = new ArrayList<Order>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() == 980) {
                if ((child = (ASTNode)child.getChild(0)).getToken().getType() == 828) {
                    colList.add(new Order(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase(), 1));
                    continue;
                }
                throw new SemanticException("create/alter table: not supported NULLS LAST for ORDER BY in ASC order");
            }
            if ((child = (ASTNode)child.getChild(0)).getToken().getType() == 829) {
                colList.add(new Order(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase(), 0));
                continue;
            }
            throw new SemanticException("create/alter table: not supported NULLS FIRST for ORDER BY in DESC order");
        }
        return colList;
    }

    protected static String getTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        switch (typeNode.getType()) {
            case 812: {
                return "array<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + ">";
            }
            case 816: {
                return "map<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + "," + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(1)) + ">";
            }
            case 942: {
                return BaseSemanticAnalyzer.getStructTypeStringFromAST(typeNode);
            }
            case 998: {
                return BaseSemanticAnalyzer.getUnionTypeStringFromAST(typeNode);
            }
        }
        return DDLSemanticAnalyzer.getTypeName(typeNode);
    }

    private static String getStructTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "struct<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty struct not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            ASTNode child = (ASTNode)typeNode.getChild(i);
            buffer.append(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText())).append(":");
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static String getUnionTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "uniontype<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty union not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(i)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        typeStr = buffer.toString();
        return typeStr;
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public void setLineageInfo(LineageInfo linfo) {
        this.linfo = linfo;
    }

    public TableAccessInfo getTableAccessInfo() {
        return this.tableAccessInfo;
    }

    public void setTableAccessInfo(TableAccessInfo tableAccessInfo) {
        this.tableAccessInfo = tableAccessInfo;
    }

    public ColumnAccessInfo getColumnAccessInfo() {
        return this.columnAccessInfo;
    }

    public void setColumnAccessInfo(ColumnAccessInfo columnAccessInfo) {
        this.columnAccessInfo = columnAccessInfo;
    }

    public ColumnAccessInfo getUpdateColumnAccessInfo() {
        return this.updateColumnAccessInfo;
    }

    public void setUpdateColumnAccessInfo(ColumnAccessInfo updateColumnAccessInfo) {
        this.updateColumnAccessInfo = updateColumnAccessInfo;
    }

    public final boolean isValidPrefixSpec(Table tTable, Map<String, String> spec) throws HiveException {
        List<FieldSchema> partCols = tTable.getPartitionKeys();
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new HiveException("table is not partitioned but partition spec exists: " + spec);
            }
            return true;
        }
        if (spec == null) {
            throw new HiveException("partition spec is not specified");
        }
        Iterator<String> itrPsKeys = spec.keySet().iterator();
        for (FieldSchema fs : partCols) {
            if (!itrPsKeys.hasNext()) break;
            if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        if (itrPsKeys.hasNext()) {
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        return true;
    }

    private static void ErrorPartSpec(Map<String, String> partSpec, List<FieldSchema> parts) throws SemanticException {
        StringBuilder sb = new StringBuilder("Partition columns in the table schema are: (");
        for (FieldSchema fs : parts) {
            sb.append(fs.getName()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("), while the partitions specified in the query are: (");
        Iterator<String> itrPsKeys = partSpec.keySet().iterator();
        while (itrPsKeys.hasNext()) {
            sb.append(itrPsKeys.next()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(").");
        throw new SemanticException(ErrorMsg.PARTSPEC_DIFFER_FROM_SCHEMA.getMsg(sb.toString()));
    }

    public Hive getDb() {
        return this.db;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public Set<FileSinkDesc> getAcidFileSinks() {
        return this.acidFileSinks;
    }

    public boolean hasAcidInQuery() {
        return this.acidInQuery;
    }

    protected ListBucketingCtx constructListBucketingCtx(List<String> skewedColNames, List<List<String>> skewedValues, Map<List<String>, String> skewedColValueLocationMaps, boolean isStoredAsSubDirectories, HiveConf conf) {
        ListBucketingCtx lbCtx = new ListBucketingCtx();
        lbCtx.setSkewedColNames(skewedColNames);
        lbCtx.setSkewedColValues(skewedValues);
        lbCtx.setLbLocationMap(skewedColValueLocationMaps);
        lbCtx.setStoredAsSubDirectories(isStoredAsSubDirectories);
        lbCtx.setDefaultKey("HIVE_DEFAULT_LIST_BUCKETING_KEY");
        lbCtx.setDefaultDirName("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME");
        return lbCtx;
    }

    protected List<String> getSkewedValueFromASTNode(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(BaseSemanticAnalyzer.stripQuotes(child.getText()));
        }
        return colList;
    }

    protected List<String> getSkewedValuesFromASTNode(Node node) throws SemanticException {
        ArrayList<String> result = null;
        Tree leafVNode = ((ASTNode)node).getChild(0);
        if (leafVNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        ASTNode lVAstNode = (ASTNode)leafVNode;
        if (lVAstNode.getToken().getType() != 955) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        result = new ArrayList<String>(this.getSkewedValueFromASTNode(lVAstNode));
        return result;
    }

    protected List<String> analyzeSkewedTablDDLColNames(List<String> skewedColNames, ASTNode child) throws SemanticException {
        Tree nNode = child.getChild(0);
        if (nNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        ASTNode nAstNode = (ASTNode)nNode;
        if (nAstNode.getToken().getType() != 954) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        skewedColNames = BaseSemanticAnalyzer.getColumnNames(nAstNode);
        return skewedColNames;
    }

    protected void analyzeDDLSkewedValues(List<List<String>> skewedValues, ASTNode child) throws SemanticException {
        Tree vNode = child.getChild(1);
        if (vNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        ASTNode vAstNode = (ASTNode)vNode;
        switch (vAstNode.getToken().getType()) {
            case 955: {
                for (String str : this.getSkewedValueFromASTNode(vAstNode)) {
                    ArrayList<String> sList = new ArrayList<String>(Arrays.asList(str));
                    skewedValues.add(sList);
                }
                break;
            }
            case 957: {
                List vLNodes = vAstNode.getChildren();
                for (Node node : vLNodes) {
                    if (((ASTNode)node).getToken().getType() != 956) {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    skewedValues.add(this.getSkewedValuesFromASTNode(node));
                }
                break;
            }
        }
    }

    protected boolean analyzeStoredAdDirs(ASTNode child) {
        boolean storedAsDirs = false;
        if (child.getChildCount() == 3 && ((ASTNode)child.getChild(2)).getToken().getType() == 939) {
            storedAsDirs = true;
        }
        return storedAsDirs;
    }

    private static boolean getPartExprNodeDesc(ASTNode astNode, HiveConf conf, Map<ASTNode, ExprNodeDesc> astExprNodeMap) throws SemanticException {
        if (astNode == null) {
            return true;
        }
        if (astNode.getChildren() == null || ((ArrayList)astNode.getChildren()).size() == 0) {
            return astNode.getType() != 858;
        }
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        boolean result = true;
        for (Node childNode : astNode.getChildren()) {
            ASTNode partVal;
            ASTNode childASTNode = (ASTNode)childNode;
            if (childASTNode.getType() != 858) {
                result = BaseSemanticAnalyzer.getPartExprNodeDesc(childASTNode, conf, astExprNodeMap) && result;
                continue;
            }
            boolean isDynamicPart = ((ArrayList)childASTNode.getChildren()).size() <= 1;
            boolean bl = result = !isDynamicPart && result;
            if (isDynamicPart || defaultPartitionName.equalsIgnoreCase(BaseSemanticAnalyzer.unescapeSQLString((partVal = (ASTNode)((ArrayList)childASTNode.getChildren()).get(1)).getText()))) continue;
            astExprNodeMap.put((ASTNode)((ArrayList)childASTNode.getChildren()).get(0), TypeCheckProcFactory.genExprNode(partVal, typeCheckCtx).get(partVal));
        }
        return result;
    }

    public static void validatePartSpec(Table tbl, Map<String, String> partSpec, ASTNode astNode, HiveConf conf, boolean shouldBeFull) throws SemanticException {
        tbl.validatePartColumnNames(partSpec, shouldBeFull);
        BaseSemanticAnalyzer.validatePartColumnType(tbl, partSpec, astNode, conf);
    }

    public static void validatePartColumnType(Table tbl, Map<String, String> partSpec, ASTNode astNode, HiveConf conf) throws SemanticException {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TYPE_CHECK_ON_INSERT)) {
            return;
        }
        HashMap<ASTNode, ExprNodeDesc> astExprNodeMap = new HashMap<ASTNode, ExprNodeDesc>();
        if (!BaseSemanticAnalyzer.getPartExprNodeDesc(astNode, conf, astExprNodeMap)) {
            STATIC_LOG.warn("Dynamic partitioning is used; only validating " + astExprNodeMap.size() + " columns");
        }
        if (astExprNodeMap.isEmpty()) {
            return;
        }
        List<FieldSchema> parts = tbl.getPartitionKeys();
        HashMap<String, String> partCols = new HashMap<String, String>(parts.size());
        for (FieldSchema fieldSchema : parts) {
            partCols.put(fieldSchema.getName(), fieldSchema.getType().toLowerCase());
        }
        for (Map.Entry entry : astExprNodeMap.entrySet()) {
            Object value;
            String astKeyName = ((ASTNode)entry.getKey()).toString().toLowerCase();
            if (((ASTNode)entry.getKey()).getType() == 24) {
                astKeyName = BaseSemanticAnalyzer.stripIdentifierQuotes(astKeyName);
            }
            String colType = (String)partCols.get(astKeyName);
            ObjectInspector inputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(((ExprNodeDesc)entry.getValue()).getTypeInfo());
            TypeInfo expectedType = TypeInfoUtils.getTypeInfoFromTypeString(colType);
            ObjectInspector outputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(expectedType);
            Object convertedValue = value = ((ExprNodeConstantDesc)entry.getValue()).getValue();
            if (!inputOI.getTypeName().equals(outputOI.getTypeName())) {
                convertedValue = ObjectInspectorConverters.getConverter(inputOI, outputOI).convert(value);
                if (convertedValue == null) {
                    throw new SemanticException(ErrorMsg.PARTITION_SPEC_TYPE_MISMATCH, astKeyName, inputOI.getTypeName(), outputOI.getTypeName());
                }
                if (!convertedValue.toString().equals(value.toString())) {
                    STATIC_LOG.warn("Partition " + astKeyName + " expects type " + outputOI.getTypeName() + " but input value is in type " + inputOI.getTypeName() + ". Convert " + value.toString() + " to " + convertedValue.toString());
                }
            }
            if (!convertedValue.toString().equals(partSpec.get(astKeyName))) {
                STATIC_LOG.warn("Partition Spec " + astKeyName + "=" + partSpec.get(astKeyName) + " has been changed to " + astKeyName + "=" + convertedValue.toString());
            }
            partSpec.put(astKeyName, convertedValue.toString());
        }
    }

    @VisibleForTesting
    static void normalizeColSpec(Map<String, String> partSpec, String colName, String colType, String originalColSpec, Object colValue) throws SemanticException {
        if (colValue == null) {
            return;
        }
        String normalizedColSpec = originalColSpec;
        if (colType.equals("date")) {
            normalizedColSpec = BaseSemanticAnalyzer.normalizeDateCol(colValue, originalColSpec);
        }
        if (!normalizedColSpec.equals(originalColSpec)) {
            STATIC_LOG.warn("Normalizing partition spec - " + colName + " from " + originalColSpec + " to " + normalizedColSpec);
            partSpec.put(colName, normalizedColSpec);
        }
    }

    private static String normalizeDateCol(Object colValue, String originalColSpec) throws SemanticException {
        Date value;
        if (colValue instanceof DateWritable) {
            value = ((DateWritable)colValue).get(false);
        } else if (colValue instanceof Date) {
            value = (Date)colValue;
        } else {
            throw new SemanticException("Unexpected date type " + colValue.getClass());
        }
        return HiveMetaStore.PARTITION_DATE_FORMAT.get().format(value);
    }

    protected WriteEntity toWriteEntity(String location) throws SemanticException {
        return this.toWriteEntity(new Path(location));
    }

    protected WriteEntity toWriteEntity(Path location) throws SemanticException {
        return BaseSemanticAnalyzer.toWriteEntity(location, this.conf);
    }

    public static WriteEntity toWriteEntity(Path location, HiveConf conf) throws SemanticException {
        try {
            Path path = BaseSemanticAnalyzer.tryQualifyPath(location, conf);
            return new WriteEntity(path, FileUtils.isLocalFile(conf, path.toUri()));
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    protected ReadEntity toReadEntity(String location) throws SemanticException {
        return this.toReadEntity(new Path(location));
    }

    protected ReadEntity toReadEntity(Path location) throws SemanticException {
        return BaseSemanticAnalyzer.toReadEntity(location, this.conf);
    }

    public static ReadEntity toReadEntity(Path location, HiveConf conf) throws SemanticException {
        try {
            Path path = BaseSemanticAnalyzer.tryQualifyPath(location, conf);
            return new ReadEntity(path, FileUtils.isLocalFile(conf, path.toUri()));
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private Path tryQualifyPath(Path path) throws IOException {
        return BaseSemanticAnalyzer.tryQualifyPath(path, this.conf);
    }

    public static Path tryQualifyPath(Path path, HiveConf conf) throws IOException {
        try {
            return path.getFileSystem((Configuration)conf).makeQualified(path);
        }
        catch (IOException e) {
            return path;
        }
    }

    protected Database getDatabase(String dbName) throws SemanticException {
        return this.getDatabase(dbName, true);
    }

    protected Database getDatabase(String dbName, boolean throwException) throws SemanticException {
        Database database;
        try {
            database = this.db.getDatabase(dbName);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (database == null && throwException) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(dbName));
        }
        return database;
    }

    protected Table getTable(String[] qualified) throws SemanticException {
        return this.getTable(qualified[0], qualified[1], true);
    }

    protected Table getTable(String[] qualified, boolean throwException) throws SemanticException {
        return this.getTable(qualified[0], qualified[1], throwException);
    }

    protected Table getTable(String tblName) throws SemanticException {
        return this.getTable(null, tblName, true);
    }

    protected Table getTable(String tblName, boolean throwException) throws SemanticException {
        return this.getTable(null, tblName, throwException);
    }

    protected Table getTable(String database, String tblName, boolean throwException) throws SemanticException {
        Table tab;
        try {
            tab = database == null ? this.db.getTable(tblName, false) : this.db.getTable(database, tblName, false);
        }
        catch (InvalidTableException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName), e);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (tab == null && throwException) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        return tab;
    }

    protected Partition getPartition(Table table, Map<String, String> partSpec, boolean throwException) throws SemanticException {
        Partition partition;
        try {
            partition = this.db.getPartition(table, partSpec, false);
        }
        catch (Exception e) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec), e);
        }
        if (partition == null && throwException) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec));
        }
        return partition;
    }

    protected List<Partition> getPartitions(Table table, Map<String, String> partSpec, boolean throwException) throws SemanticException {
        List<Partition> partitions;
        try {
            partitions = partSpec == null ? this.db.getPartitions(table) : this.db.getPartitions(table, partSpec);
        }
        catch (Exception e) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec), e);
        }
        if (partitions.isEmpty() && throwException) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec));
        }
        return partitions;
    }

    protected String toMessage(ErrorMsg message, Object detail) {
        return detail == null ? message.getMsg() : message.getMsg(detail.toString());
    }

    public List<Task<? extends Serializable>> getAllRootTasks() {
        return this.rootTasks;
    }

    public HashSet<ReadEntity> getAllInputs() {
        return this.inputs;
    }

    public HashSet<WriteEntity> getAllOutputs() {
        return this.outputs;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    protected FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", Integer.toString(9));
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        prop.setProperty("serialization.lib", LazySimpleSerDe.class.getName());
        FetchWork fetch = new FetchWork(this.ctx.getResFile(), new TableDesc(TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    public class AnalyzeRewriteContext {
        private String tableName;
        private List<String> colName;
        private List<String> colType;
        private boolean tblLvl;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public List<String> getColName() {
            return this.colName;
        }

        public void setColName(List<String> colName) {
            this.colName = colName;
        }

        public boolean isTblLvl() {
            return this.tblLvl;
        }

        public void setTblLvl(boolean isTblLvl) {
            this.tblLvl = isTblLvl;
        }

        public List<String> getColType() {
            return this.colType;
        }

        public void setColType(List<String> colType) {
            this.colType = colType;
        }
    }

    public static class TableSpec {
        public String tableName;
        public Table tableHandle;
        public Map<String, String> partSpec;
        public Partition partHandle;
        public int numDynParts;
        public List<Partition> partitions;
        public SpecType specType;

        public TableSpec(Hive db, HiveConf conf, ASTNode ast) throws SemanticException {
            this(db, conf, ast, true, false);
        }

        public TableSpec(Hive db, HiveConf conf, String tableName, Map<String, String> partSpec) throws HiveException {
            this.tableName = tableName;
            this.partSpec = partSpec;
            this.tableHandle = db.getTable(tableName);
            if (partSpec != null) {
                this.specType = SpecType.STATIC_PARTITION;
                this.partHandle = db.getPartition(this.tableHandle, partSpec, false);
                this.partitions = Arrays.asList(this.partHandle);
            } else {
                this.specType = SpecType.TABLE_ONLY;
            }
        }

        public TableSpec(Table tableHandle, List<Partition> partitions) throws HiveException {
            this.tableHandle = tableHandle;
            this.tableName = tableHandle.getTableName();
            if (partitions != null && !partitions.isEmpty()) {
                this.specType = SpecType.STATIC_PARTITION;
                this.partitions = partitions;
                List<FieldSchema> partCols = this.tableHandle.getPartCols();
                this.partSpec = new LinkedHashMap<String, String>();
                for (FieldSchema partCol : partCols) {
                    this.partSpec.put(partCol.getName(), null);
                }
            } else {
                this.specType = SpecType.TABLE_ONLY;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public TableSpec(Hive db, HiveConf conf, ASTNode ast, boolean allowDynamicPartitionsSpec, boolean allowPartialPartitionsSpec) throws SemanticException {
            assert (ast.getToken().getType() == 950 || ast.getToken().getType() == 976 || ast.getToken().getType() == 983 || ast.getToken().getType() == 715 || ast.getToken().getType() == 717);
            int childIndex = 0;
            this.numDynParts = 0;
            try {
                this.tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
                if (testMode) {
                    this.tableName = conf.getVar(HiveConf.ConfVars.HIVETESTMODEPREFIX) + this.tableName;
                }
                if (ast.getToken().getType() != 715 && ast.getToken().getType() != 717) {
                    this.tableHandle = db.getTable(this.tableName);
                }
            }
            catch (InvalidTableException ite) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(ast.getChild(0)), ite);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.CANNOT_RETRIEVE_TABLE_METADATA.getMsg(ast.getChild(childIndex), e.getMessage()), e);
            }
            if (ast.getChildCount() == 2 && ast.getToken().getType() != 715 && ast.getToken().getType() != 717) {
                childIndex = 1;
                ASTNode partspec = (ASTNode)ast.getChild(1);
                this.partitions = new ArrayList<Partition>();
                HashMap<String, String> tmpPartSpec = new HashMap<String, String>(partspec.getChildCount());
                for (int i = 0; i < partspec.getChildCount(); ++i) {
                    ASTNode partspec_val = (ASTNode)partspec.getChild(i);
                    String val = null;
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                    if (partspec_val.getChildCount() < 2) {
                        if (!allowDynamicPartitionsSpec) throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                        ++this.numDynParts;
                    } else {
                        val = BaseSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                    }
                    tmpPartSpec.put(colName, val);
                }
                BaseSemanticAnalyzer.validatePartSpec(this.tableHandle, tmpPartSpec, ast, conf, false);
                List<FieldSchema> parts = this.tableHandle.getPartitionKeys();
                this.partSpec = new LinkedHashMap<String, String>(partspec.getChildCount());
                for (FieldSchema fs : parts) {
                    String partKey = fs.getName();
                    this.partSpec.put(partKey, (String)tmpPartSpec.get(partKey));
                }
                if (this.numDynParts > 0) {
                    int numStaPart = parts.size() - this.numDynParts;
                    if (numStaPart == 0 && conf.getVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equalsIgnoreCase("strict")) {
                        throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                    }
                    if (this.partSpec.keySet().size() != parts.size()) {
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    Iterator<String> itrPsKeys = this.partSpec.keySet().iterator();
                    for (FieldSchema fs : parts) {
                        if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    for (FieldSchema fs : parts) {
                        if (this.partSpec.get(fs.getName().toLowerCase()) == null) {
                            if (numStaPart <= 0) break;
                            throw new SemanticException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(ast.getChild(childIndex)));
                        }
                        --numStaPart;
                    }
                    this.partHandle = null;
                    this.specType = SpecType.DYNAMIC_PARTITION;
                    return;
                }
                try {
                    if (allowPartialPartitionsSpec) {
                        this.partitions = db.getPartitions(this.tableHandle, this.partSpec);
                    } else {
                        this.partHandle = db.getPartition(this.tableHandle, this.partSpec, false);
                        if (this.partHandle == null) {
                            this.partHandle = new Partition(this.tableHandle, this.partSpec, null);
                        } else {
                            this.partitions.add(this.partHandle);
                        }
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(childIndex)), e);
                }
                this.specType = SpecType.STATIC_PARTITION;
                return;
            }
            this.specType = SpecType.TABLE_ONLY;
        }

        public Map<String, String> getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(Map<String, String> partSpec) {
            this.partSpec = partSpec;
        }

        public String toString() {
            if (this.partHandle != null) {
                return this.partHandle.toString();
            }
            return this.tableHandle.toString();
        }

        public static enum SpecType {
            TABLE_ONLY,
            STATIC_PARTITION,
            DYNAMIC_PARTITION;

        }
    }

    static class PKInfo {
        public String colName;
        public String constraintName;
        public boolean rely;

        public PKInfo(String colName, String constraintName, boolean rely) {
            this.colName = colName;
            this.constraintName = constraintName;
            this.rely = rely;
        }
    }

    class RowFormatParams {
        String fieldDelim = null;
        String fieldEscape = null;
        String collItemDelim = null;
        String mapKeyDelim = null;
        String lineDelim = null;
        String nullFormat = null;

        RowFormatParams() {
        }

        protected void analyzeRowFormat(ASTNode child) throws SemanticException {
            child = (ASTNode)child.getChild(0);
            int numChildRowFormat = child.getChildCount();
            block7: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 968: {
                        this.fieldDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (rowChild.getChildCount() < 2) continue block7;
                        this.fieldEscape = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        continue block7;
                    }
                    case 967: {
                        this.collItemDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 970: {
                        this.mapKeyDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 969: {
                        this.lineDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (this.lineDelim.equals("\n") || this.lineDelim.equals("10")) continue block7;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    case 971: {
                        this.nullFormat = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)("Unkown Token: " + rowChild));
                    }
                }
            }
        }
    }
}

