/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.NumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.udf.generic.StringNumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="compute_stats", value="_FUNC_(x) - Returns the statistical summary of a set of primitive type values.")
public class GenericUDAFComputeStats
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFComputeStats.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly two arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BOOLEAN: {
                return new GenericUDAFBooleanStatsEvaluator();
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                return new GenericUDAFLongStatsEvaluator();
            }
            case FLOAT: 
            case DOUBLE: {
                return new GenericUDAFDoubleStatsEvaluator();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new GenericUDAFStringStatsEvaluator();
            }
            case BINARY: {
                return new GenericUDAFBinaryStatsEvaluator();
            }
            case DECIMAL: {
                return new GenericUDAFDecimalStatsEvaluator();
            }
            case DATE: {
                return new GenericUDAFDateStatsEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Only integer/long/timestamp/date/float/double/string/binary/boolean/decimal type argument is accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class GenericUDAFDateStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<DateWritable, DateObjectInspector> {
        @Override
        protected DateObjectInspector getValueObjectInspector() {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DateStatsAgg result = new DateStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset("Date");
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DateStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                DateWritable v = new DateWritable((DateWritable)inputOI.getPrimitiveWritableObject(p));
                if (this.min == null || v.compareTo((DateWritable)this.min) < 0) {
                    this.min = v;
                }
                if (this.max == null || v.compareTo((DateWritable)this.max) > 0) {
                    this.max = v;
                }
                this.numDV.addToEstimator(v.getDays());
            }

            protected void updateMin(Object minValue, DateObjectInspector minFieldOI) {
                if (minValue != null && (this.min == null || ((DateWritable)this.min).compareTo(minFieldOI.getPrimitiveWritableObject(minValue)) > 0)) {
                    this.min = new DateWritable(minFieldOI.getPrimitiveWritableObject(minValue));
                }
            }

            protected void updateMax(Object maxValue, DateObjectInspector maxFieldOI) {
                if (maxValue != null && (this.max == null || ((DateWritable)this.max).compareTo(maxFieldOI.getPrimitiveWritableObject(maxValue)) < 0)) {
                    this.max = new DateWritable(maxFieldOI.getPrimitiveWritableObject(maxValue));
                }
            }
        }
    }

    public static class GenericUDAFDecimalStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<HiveDecimal, HiveDecimalObjectInspector> {
        @Override
        protected HiveDecimalObjectInspector getValueObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DecimalStatsAgg result = new DecimalStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset("Decimal");
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DecimalStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.lengthOfDecimal() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                HiveDecimal v = PrimitiveObjectInspectorUtils.getHiveDecimal(p, inputOI);
                if (this.min == null || v.compareTo((HiveDecimal)this.min) < 0) {
                    this.min = v;
                }
                if (this.max == null || v.compareTo((HiveDecimal)this.max) > 0) {
                    this.max = v;
                }
                this.numDV.addToEstimator(v);
            }

            protected void updateMin(Object minValue, HiveDecimalObjectInspector minFieldOI) {
                if (minValue != null && (this.min == null || ((HiveDecimal)this.min).compareTo(minFieldOI.getPrimitiveJavaObject(minValue)) > 0)) {
                    this.min = minFieldOI.getPrimitiveJavaObject(minValue);
                }
            }

            protected void updateMax(Object maxValue, HiveDecimalObjectInspector maxFieldOI) {
                if (maxValue != null && (this.max == null || ((HiveDecimal)this.max).compareTo(maxFieldOI.getPrimitiveJavaObject(maxValue)) < 0)) {
                    this.max = maxFieldOI.getPrimitiveJavaObject(maxValue);
                }
            }
        }
    }

    public static class GenericUDAFBinaryStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField maxLengthField;
        private transient LongObjectInspector maxLengthFieldOI;
        private transient StructField sumLengthField;
        private transient LongObjectInspector sumLengthFieldOI;
        private transient StructField countField;
        private transient LongObjectInspector countFieldOI;
        private transient StructField countNullsField;
        private transient LongObjectInspector countNullsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.maxLengthField = this.soi.getStructFieldRef("maxlength");
                this.maxLengthFieldOI = (LongObjectInspector)this.maxLengthField.getFieldObjectInspector();
                this.sumLengthField = this.soi.getStructFieldRef("sumlength");
                this.sumLengthFieldOI = (LongObjectInspector)this.sumLengthField.getFieldObjectInspector();
                this.countField = this.soi.getStructFieldRef("count");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("countnulls");
                this.countNullsFieldOI = (LongObjectInspector)this.countNullsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("columntype");
                fname.add("maxlength");
                fname.add("sumlength");
                fname.add("count");
                fname.add("countnulls");
                this.partialResult = new Object[5];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new LongWritable(0L);
                this.partialResult[2] = new LongWritable(0L);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new LongWritable(0L);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("columntype");
            fname.add("maxlength");
            fname.add("avglength");
            fname.add("countnulls");
            this.result = new Object[4];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new DoubleWritable(0.0);
            this.result[3] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            BinaryStatsAgg result = new BinaryStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            myagg.columnType = new String("Binary");
            myagg.maxLength = 0L;
            myagg.sumLength = 0L;
            myagg.count = 0L;
            myagg.countNulls = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block7: {
                Object p = parameters[0];
                BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            BytesWritable v = PrimitiveObjectInspectorUtils.getBinary(p, this.inputOI);
                            int len = v.getLength();
                            if ((long)len > myagg.maxLength) {
                                myagg.maxLength = len;
                            }
                            myagg.sumLength += (long)len;
                            ++myagg.count;
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block7;
                            this.warned = true;
                            LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                            LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.maxLength);
            ((LongWritable)this.partialResult[2]).set(myagg.sumLength);
            ((LongWritable)this.partialResult[3]).set(myagg.count);
            ((LongWritable)this.partialResult[4]).set(myagg.countNulls);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
                Object partialValue = this.soi.getStructFieldData(partial, this.maxLengthField);
                if (myagg.maxLength < this.maxLengthFieldOI.get(partialValue)) {
                    myagg.maxLength = this.maxLengthFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.sumLengthField);
                myagg.sumLength += this.sumLengthFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countField);
                myagg.count += this.countFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BinaryStatsAgg myagg = (BinaryStatsAgg)agg;
            double avgLength = 0.0;
            long count = myagg.count + myagg.countNulls;
            if (count != 0L) {
                avgLength = (double)myagg.sumLength / (1.0 * (double)(myagg.count + myagg.countNulls));
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.maxLength);
            ((DoubleWritable)((Object)this.result[2])).set(avgLength);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class BinaryStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long maxLength;
            public long sumLength;
            public long count;
            public long countNulls;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive2() * 4 + model.lengthFor(this.columnType);
            }
        }
    }

    public static class GenericUDAFStringStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient PrimitiveObjectInspector numVectorsOI;
        private static final int MAX_BIT_VECTORS = 1024;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField maxLengthField;
        private transient LongObjectInspector maxLengthFieldOI;
        private transient StructField sumLengthField;
        private transient LongObjectInspector sumLengthFieldOI;
        private transient StructField countField;
        private transient LongObjectInspector countFieldOI;
        private transient StructField countNullsField;
        private transient LongObjectInspector countNullsFieldOI;
        private transient StructField ndvField;
        private transient StringObjectInspector ndvFieldOI;
        private transient StructField numBitVectorsField;
        private transient IntObjectInspector numBitVectorsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.numVectorsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.maxLengthField = this.soi.getStructFieldRef("maxlength");
                this.maxLengthFieldOI = (LongObjectInspector)this.maxLengthField.getFieldObjectInspector();
                this.sumLengthField = this.soi.getStructFieldRef("sumlength");
                this.sumLengthFieldOI = (LongObjectInspector)this.sumLengthField.getFieldObjectInspector();
                this.countField = this.soi.getStructFieldRef("count");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("countnulls");
                this.countNullsFieldOI = (LongObjectInspector)this.countNullsField.getFieldObjectInspector();
                this.ndvField = this.soi.getStructFieldRef("bitvector");
                this.ndvFieldOI = (StringObjectInspector)this.ndvField.getFieldObjectInspector();
                this.numBitVectorsField = this.soi.getStructFieldRef("numbitvectors");
                this.numBitVectorsFieldOI = (IntObjectInspector)this.numBitVectorsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("columntype");
                fname.add("maxlength");
                fname.add("sumlength");
                fname.add("count");
                fname.add("countnulls");
                fname.add("bitvector");
                fname.add("numbitvectors");
                this.partialResult = new Object[7];
                this.partialResult[0] = new Text();
                this.partialResult[1] = new LongWritable(0L);
                this.partialResult[2] = new LongWritable(0L);
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new LongWritable(0L);
                this.partialResult[5] = new Text();
                this.partialResult[6] = new IntWritable(0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("columntype");
            fname.add("maxlength");
            fname.add("avglength");
            fname.add("countnulls");
            fname.add("numdistinctvalues");
            this.result = new Object[5];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new DoubleWritable(0.0);
            this.result[3] = new LongWritable(0L);
            this.result[4] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StringStatsAgg result = new StringStatsAgg();
            this.reset(result);
            return result;
        }

        public void initNDVEstimator(StringStatsAgg aggBuffer, int numBitVectors) {
            aggBuffer.numDV = new StringNumDistinctValueEstimator(numBitVectors);
            aggBuffer.numDV.reset();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            myagg.columnType = new String("String");
            myagg.maxLength = 0L;
            myagg.sumLength = 0L;
            myagg.count = 0L;
            myagg.countNulls = 0L;
            myagg.firstItem = true;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block10: {
                Object p = parameters[0];
                StringStatsAgg myagg = (StringStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (myagg.firstItem) {
                    int numVectors = 0;
                    if (!emptyTable) {
                        numVectors = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.numVectorsOI);
                    }
                    if (numVectors > 1024) {
                        throw new HiveException("The maximum allowed value for number of bit vectors  is 1024 , but was passed " + numVectors + " bit vectors");
                    }
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            String v = PrimitiveObjectInspectorUtils.getString(p, this.inputOI);
                            int len = v.length();
                            if ((long)len > myagg.maxLength) {
                                myagg.maxLength = len;
                            }
                            myagg.sumLength += (long)len;
                            ++myagg.count;
                            myagg.numDV.addToEstimator(v);
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block10;
                            this.warned = true;
                            LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                            LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            Text t = myagg.numDV.serialize();
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.maxLength);
            ((LongWritable)this.partialResult[2]).set(myagg.sumLength);
            ((LongWritable)this.partialResult[3]).set(myagg.count);
            ((LongWritable)this.partialResult[4]).set(myagg.countNulls);
            ((Text)this.partialResult[5]).set(t);
            ((IntWritable)this.partialResult[6]).set(myagg.numBitVectors);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                Object partialValue;
                StringStatsAgg myagg = (StringStatsAgg)agg;
                if (myagg.firstItem) {
                    partialValue = this.soi.getStructFieldData(partial, this.numBitVectorsField);
                    int numVectors = this.numBitVectorsFieldOI.get(partialValue);
                    this.initNDVEstimator(myagg, numVectors);
                    myagg.firstItem = false;
                    myagg.numBitVectors = numVectors;
                }
                if (myagg.maxLength < this.maxLengthFieldOI.get(partialValue = this.soi.getStructFieldData(partial, this.maxLengthField))) {
                    myagg.maxLength = this.maxLengthFieldOI.get(partialValue);
                }
                partialValue = this.soi.getStructFieldData(partial, this.sumLengthField);
                myagg.sumLength += this.sumLengthFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countField);
                myagg.count += this.countFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialValue);
                partialValue = this.soi.getStructFieldData(partial, this.ndvField);
                String v = this.ndvFieldOI.getPrimitiveJavaObject(partialValue);
                NumDistinctValueEstimator o = new NumDistinctValueEstimator(v, myagg.numBitVectors);
                myagg.numDV.mergeEstimators(o);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StringStatsAgg myagg = (StringStatsAgg)agg;
            long numDV = 0L;
            double avgLength = 0.0;
            long total = myagg.count + myagg.countNulls;
            if (myagg.numBitVectors != 0) {
                numDV = myagg.numDV.estimateNumDistinctValues();
            }
            if (total != 0L) {
                avgLength = (double)myagg.sumLength / (1.0 * (double)total);
            }
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.maxLength);
            ((DoubleWritable)((Object)this.result[2])).set(avgLength);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            ((LongWritable)this.result[4]).set(numDV);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class StringStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long maxLength;
            public long sumLength;
            public long count;
            public long countNulls;
            public StringNumDistinctValueEstimator numDV;
            public int numBitVectors;
            public boolean firstItem;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive1() * 2 + model.primitive2() * 4 + model.lengthFor(this.columnType) + this.numDV.lengthFor(model);
            }
        }
    }

    public static class GenericUDAFDoubleStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Double, DoubleObjectInspector> {
        @Override
        protected DoubleObjectInspector getValueObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            DoubleStatsAgg result = new DoubleStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset("Double");
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class DoubleStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                double v = PrimitiveObjectInspectorUtils.getDouble(p, inputOI);
                if (this.min == null || v < (Double)this.min) {
                    this.min = v;
                }
                if (this.max == null || v > (Double)this.max) {
                    this.max = v;
                }
                this.numDV.addToEstimator(v);
            }

            protected void updateMin(Object minValue, DoubleObjectInspector minFieldOI) {
                if (minValue != null && (this.min == null || (Double)this.min > minFieldOI.get(minValue))) {
                    this.min = minFieldOI.get(minValue);
                }
            }

            protected void updateMax(Object maxValue, DoubleObjectInspector maxFieldOI) {
                if (maxValue != null && (this.max == null || (Double)this.max < maxFieldOI.get(maxValue))) {
                    this.max = maxFieldOI.get(maxValue);
                }
            }
        }
    }

    public static class GenericUDAFLongStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Long, LongObjectInspector> {
        @Override
        protected LongObjectInspector getValueObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            LongStatsAgg result = new LongStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((GenericUDAFNumericStatsEvaluator.NumericStatsAgg)agg).reset("Long");
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public class LongStatsAgg
        extends GenericUDAFNumericStatsEvaluator.NumericStatsAgg {
            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return super.estimate() + model.primitive2() * 2;
            }

            @Override
            protected void update(Object p, PrimitiveObjectInspector inputOI) {
                long v = PrimitiveObjectInspectorUtils.getLong(p, inputOI);
                if (this.min == null || v < (Long)this.min) {
                    this.min = v;
                }
                if (this.max == null || v > (Long)this.max) {
                    this.max = v;
                }
                this.numDV.addToEstimator(v);
            }

            protected void updateMin(Object minValue, LongObjectInspector minFieldOI) {
                if (minValue != null && (this.min == null || (Long)this.min > minFieldOI.get(minValue))) {
                    this.min = minFieldOI.get(minValue);
                }
            }

            protected void updateMax(Object maxValue, LongObjectInspector maxFieldOI) {
                if (maxValue != null && (this.max == null || (Long)this.max < maxFieldOI.get(maxValue))) {
                    this.max = maxFieldOI.get(maxValue);
                }
            }
        }
    }

    public static abstract class GenericUDAFNumericStatsEvaluator<V, OI extends ObjectInspector>
    extends GenericUDAFEvaluator {
        protected static final int MAX_BIT_VECTORS = 1024;
        protected transient PrimitiveObjectInspector inputOI;
        protected transient PrimitiveObjectInspector numVectorsOI;
        protected transient StructObjectInspector soi;
        protected transient StructField minField;
        protected transient OI minFieldOI;
        protected transient StructField maxField;
        protected transient OI maxFieldOI;
        protected transient StructField countNullsField;
        protected transient LongObjectInspector countNullsFieldOI;
        protected transient StructField ndvField;
        protected transient StringObjectInspector ndvFieldOI;
        protected transient StructField numBitVectorsField;
        protected transient IntObjectInspector numBitVectorsFieldOI;
        protected transient Object[] partialResult;
        protected transient Object[] result;
        protected transient boolean warned;

        protected abstract OI getValueObjectInspector();

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.numVectorsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.minField = this.soi.getStructFieldRef("min");
                this.minFieldOI = this.minField.getFieldObjectInspector();
                this.maxField = this.soi.getStructFieldRef("max");
                this.maxFieldOI = this.maxField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("countnulls");
                this.countNullsFieldOI = (LongObjectInspector)this.countNullsField.getFieldObjectInspector();
                this.ndvField = this.soi.getStructFieldRef("bitvector");
                this.ndvFieldOI = (StringObjectInspector)this.ndvField.getFieldObjectInspector();
                this.numBitVectorsField = this.soi.getStructFieldRef("numbitvectors");
                this.numBitVectorsFieldOI = (IntObjectInspector)this.numBitVectorsField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add((ObjectInspector)this.getValueObjectInspector());
                foi.add((ObjectInspector)this.getValueObjectInspector());
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("columnType");
                fname.add("min");
                fname.add("max");
                fname.add("countnulls");
                fname.add("bitvector");
                fname.add("numbitvectors");
                this.partialResult = new Object[6];
                this.partialResult[0] = new Text();
                this.partialResult[3] = new LongWritable(0L);
                this.partialResult[4] = new Text();
                this.partialResult[5] = new IntWritable(0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add((ObjectInspector)this.getValueObjectInspector());
            foi.add((ObjectInspector)this.getValueObjectInspector());
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("columnType");
            fname.add("min");
            fname.add("max");
            fname.add("countnulls");
            fname.add("numdistinctvalues");
            this.result = new Object[5];
            this.result[0] = new Text();
            this.result[3] = new LongWritable(0L);
            this.result[4] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block6: {
                NumericStatsAgg myagg = (NumericStatsAgg)agg;
                if (myagg.numDV == null) {
                    int numVectors;
                    int n = numVectors = parameters[1] == null ? 0 : PrimitiveObjectInspectorUtils.getInt(parameters[1], this.numVectorsOI);
                    if (numVectors > 1024) {
                        throw new HiveException("The maximum allowed value for number of bit vectors  is 1024, but was passed " + numVectors + " bit vectors");
                    }
                    myagg.initNDVEstimator(numVectors);
                }
                if (parameters[0] == null) {
                    ++myagg.countNulls;
                } else {
                    try {
                        myagg.update(parameters[0], this.inputOI);
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block6;
                        this.warned = true;
                        LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                        LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serializePartial(this.partialResult);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((NumericStatsAgg)agg).serialize(this.result);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                NumericStatsAgg myagg = (NumericStatsAgg)agg;
                if (myagg.numDV == null) {
                    Object partialValue = this.soi.getStructFieldData(partial, this.numBitVectorsField);
                    int numVectors = this.numBitVectorsFieldOI.get(partialValue);
                    myagg.initNDVEstimator(numVectors);
                }
                Object minValue = this.soi.getStructFieldData(partial, this.minField);
                myagg.updateMin(minValue, this.minFieldOI);
                Object maxValue = this.soi.getStructFieldData(partial, this.maxField);
                myagg.updateMax(maxValue, this.maxFieldOI);
                Object countNull = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(countNull);
                Object numDistinct = this.soi.getStructFieldData(partial, this.ndvField);
                String v = this.ndvFieldOI.getPrimitiveJavaObject(numDistinct);
                NumDistinctValueEstimator o = new NumDistinctValueEstimator(v, myagg.numDV.getnumBitVectors());
                myagg.numDV.mergeEstimators(o);
            }
        }

        public abstract class NumericStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public V min;
            public V max;
            public long countNulls;
            public NumDistinctValueEstimator numDV;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.lengthFor(this.columnType) + model.primitive1() + model.primitive2() + this.numDV.lengthFor(model);
            }

            protected void initNDVEstimator(int numBitVectors) {
                this.numDV = new NumDistinctValueEstimator(numBitVectors);
            }

            protected abstract void update(Object var1, PrimitiveObjectInspector var2);

            protected abstract void updateMin(Object var1, OI var2);

            protected abstract void updateMax(Object var1, OI var2);

            protected Object serialize(Object[] result) {
                this.serializeCommon(result);
                long dv = this.numDV != null ? this.numDV.estimateNumDistinctValues() : 0L;
                ((LongWritable)result[4]).set(dv);
                return result;
            }

            protected Object serializePartial(Object[] result) {
                this.serializeCommon(result);
                Text t = this.numDV.serialize();
                ((Text)result[4]).set(t);
                ((IntWritable)result[5]).set(this.numDV.getnumBitVectors());
                return result;
            }

            private void serializeCommon(Object[] result) {
                ((Text)result[0]).set(this.columnType);
                result[1] = this.min;
                result[2] = this.max;
                ((LongWritable)result[3]).set(this.countNulls);
            }

            public void reset(String type) throws HiveException {
                this.columnType = type;
                this.min = null;
                this.max = null;
                this.countNulls = 0L;
                this.numDV = null;
            }
        }
    }

    public static class GenericUDAFBooleanStatsEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient Object[] partialResult;
        private transient StructObjectInspector soi;
        private transient StructField countTruesField;
        private transient WritableLongObjectInspector countTruesFieldOI;
        private transient StructField countFalsesField;
        private transient WritableLongObjectInspector countFalsesFieldOI;
        private transient StructField countNullsField;
        private transient WritableLongObjectInspector countNullsFieldOI;
        private transient Object[] result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countTruesField = this.soi.getStructFieldRef("counttrues");
                this.countTruesFieldOI = (WritableLongObjectInspector)this.countTruesField.getFieldObjectInspector();
                this.countFalsesField = this.soi.getStructFieldRef("countfalses");
                this.countFalsesFieldOI = (WritableLongObjectInspector)this.countFalsesField.getFieldObjectInspector();
                this.countNullsField = this.soi.getStructFieldRef("countnulls");
                this.countNullsFieldOI = (WritableLongObjectInspector)this.countNullsField.getFieldObjectInspector();
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("columntype");
            fname.add("counttrues");
            fname.add("countfalses");
            fname.add("countnulls");
            this.partialResult = new Object[4];
            this.partialResult[0] = new Text();
            this.partialResult[1] = new LongWritable(0L);
            this.partialResult[2] = new LongWritable(0L);
            this.partialResult[3] = new LongWritable(0L);
            this.result = new Object[4];
            this.result[0] = new Text();
            this.result[1] = new LongWritable(0L);
            this.result[2] = new LongWritable(0L);
            this.result[3] = new LongWritable(0L);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            BooleanStatsAgg result = new BooleanStatsAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            myagg.columnType = new String("Boolean");
            myagg.countTrues = 0L;
            myagg.countFalses = 0L;
            myagg.countNulls = 0L;
        }

        private void printDebugOutput(String functionName, GenericUDAFEvaluator.AggregationBuffer agg) {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            LOG.debug(functionName);
            LOG.debug("Count of True Values: {}", (Object)myagg.countTrues);
            LOG.debug("Count of False Values: {}", (Object)myagg.countFalses);
            LOG.debug("Count of Null Values: {}", (Object)myagg.countNulls);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block9: {
                Object p = parameters[0];
                BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
                boolean emptyTable = false;
                if (parameters[1] == null) {
                    emptyTable = true;
                }
                if (!emptyTable) {
                    if (p == null) {
                        ++myagg.countNulls;
                    } else {
                        try {
                            boolean v = PrimitiveObjectInspectorUtils.getBoolean(p, this.inputOI);
                            if (!v) {
                                ++myagg.countFalses;
                            } else if (v) {
                                ++myagg.countTrues;
                            }
                        }
                        catch (NumberFormatException e) {
                            if (this.warned) break block9;
                            this.warned = true;
                            LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                            LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                        }
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            ((Text)this.partialResult[0]).set(myagg.columnType);
            ((LongWritable)this.partialResult[1]).set(myagg.countTrues);
            ((LongWritable)this.partialResult[2]).set(myagg.countFalses);
            ((LongWritable)this.partialResult[3]).set(myagg.countNulls);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
                Object partialCount = this.soi.getStructFieldData(partial, this.countTruesField);
                myagg.countTrues += this.countTruesFieldOI.get(partialCount);
                partialCount = this.soi.getStructFieldData(partial, this.countFalsesField);
                myagg.countFalses += this.countFalsesFieldOI.get(partialCount);
                partialCount = this.soi.getStructFieldData(partial, this.countNullsField);
                myagg.countNulls += this.countNullsFieldOI.get(partialCount);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BooleanStatsAgg myagg = (BooleanStatsAgg)agg;
            ((Text)this.result[0]).set(myagg.columnType);
            ((LongWritable)this.result[1]).set(myagg.countTrues);
            ((LongWritable)this.result[2]).set(myagg.countFalses);
            ((LongWritable)this.result[3]).set(myagg.countNulls);
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        public static class BooleanStatsAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            public String columnType;
            public long countTrues;
            public long countFalses;
            public long countNulls;

            @Override
            public int estimate() {
                JavaDataModel model = JavaDataModel.get();
                return model.primitive2() * 3 + model.lengthFor(this.columnType);
            }
        }
    }
}

