/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hive.common.util.AnnotationUtils;

public class HiveJoinPushTransitivePredicatesRule
extends RelOptRule {
    private final RelFactories.FilterFactory filterFactory;
    public static final HiveJoinPushTransitivePredicatesRule INSTANCE = new HiveJoinPushTransitivePredicatesRule(Join.class, RelFactories.DEFAULT_FILTER_FACTORY);

    public HiveJoinPushTransitivePredicatesRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinPushTransitivePredicatesRule.operand(clazz, (RelOptRuleOperand)HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinPushTransitivePredicatesRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveJoinPushTransitivePredicatesRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinPushTransitivePredicatesRule.any())}));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        Join join = (Join)call.rel(0);
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        if (registry != null) {
            registry.registerVisited(this, (RelNode)join);
        }
        RelOptPredicateList preds = RelMetadataQuery.getPulledUpPredicates((RelNode)join);
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode lChild = call.rel(1);
        RelNode rChild = call.rel(2);
        ImmutableList<RexNode> leftPreds = this.getValidPreds(join.getCluster(), lChild, preds.leftInferredPredicates, lChild.getRowType());
        ImmutableList<RexNode> rightPreds = this.getValidPreds(join.getCluster(), rChild, preds.rightInferredPredicates, rChild.getRowType());
        if (leftPreds.isEmpty() && rightPreds.isEmpty()) {
            return;
        }
        if (leftPreds.size() > 0) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, RexUtil.composeConjunction((RexBuilder)rB, leftPreds, (boolean)false));
            call.getPlanner().onCopy(curr, lChild);
        }
        if (rightPreds.size() > 0) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, RexUtil.composeConjunction((RexBuilder)rB, rightPreds, (boolean)false));
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newRel);
        if (registry != null) {
            registry.registerVisited(this, (RelNode)newRel);
        }
        call.transformTo((RelNode)newRel);
    }

    private ImmutableList<RexNode> getValidPreds(RelOptCluster cluster, RelNode rn, List<RexNode> rexs, RelDataType rType) {
        InputRefValidator validator = new InputRefValidator(rType.getFieldList());
        ArrayList<RexNode> valids = new ArrayList<RexNode>(rexs.size());
        for (RexNode rex : rexs) {
            try {
                rex.accept((RexVisitor)validator);
                valids.add(rex);
            }
            catch (Util.FoundOne e) {
                Util.swallow((Throwable)e, null);
            }
        }
        return HiveCalciteUtil.getPredsNotPushedAlready(rn, valids);
    }

    private RexNode getTypeSafePred(RelOptCluster cluster, RexNode rex, RelDataType rType) {
        RexNode typeSafeRex = rex;
        if (typeSafeRex instanceof RexCall && HiveCalciteUtil.isComparisonOp((RexCall)typeSafeRex)) {
            RexBuilder rb = cluster.getRexBuilder();
            ArrayList<RexNode> fixedPredElems = new ArrayList<RexNode>();
            RelDataType commonType = cluster.getTypeFactory().leastRestrictive(RexUtil.types((List)((RexCall)rex).getOperands()));
            for (RexNode rn : ((RexCall)rex).getOperands()) {
                fixedPredElems.add(rb.ensureType(commonType, rn, true));
            }
            typeSafeRex = rb.makeCall(((RexCall)typeSafeRex).getOperator(), fixedPredElems);
        }
        return typeSafeRex;
    }

    private static class InputRefValidator
    extends RexVisitorImpl<Void> {
        private final List<RelDataTypeField> types;

        protected InputRefValidator(List<RelDataTypeField> types) {
            super(true);
            this.types = types;
        }

        public Void visitCall(RexCall call) {
            if (AnnotationUtils.getAnnotation(GenericUDFOPNotNull.class, Description.class).name().equals(call.getOperator().getName()) && call.getOperands().get(0) instanceof RexInputRef && !this.types.get(((RexInputRef)call.getOperands().get(0)).getIndex()).getType().isNullable()) {
                throw new Util.FoundOne((Object)call);
            }
            return (Void)super.visitCall(call);
        }
    }
}

