/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenMRFileSink1
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenMRFileSink1.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        FetchTask fetchTask;
        FileSinkDesc fileSinkDesc;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        boolean chDir = false;
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        ctx.addRootIfPossible(currTask);
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseCtx, fsOp);
        HiveConf hconf = parseCtx.getConf();
        ((MapredWork)currTask.getWork()).setFinalMapRed(true);
        Map<FileSinkDesc, Task<? extends Serializable>> fileSinkDescs = ctx.getLinkedFileDescTasks();
        if (fileSinkDescs != null) {
            Task<? extends Serializable> childTask = fileSinkDescs.get(fsOp.getConf());
            this.processLinkedFileDesc(ctx, childTask);
            return true;
        }
        if (ctx.getSeenFileSinkOps() == null || !ctx.getSeenFileSinkOps().contains(nd)) {
            chDir = GenMapRedUtils.isMergeRequired(ctx.getMvTask(), hconf, fsOp, currTask, isInsertTable);
        }
        Path finalName = this.processFS(fsOp, stack, opProcCtx, chDir);
        if (chDir) {
            LOG.info("using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fsOp, finalName, ctx.getDependencyTaskForMultiInsert(), ctx.getMvTask(), hconf, currTask);
        }
        if ((fileSinkDesc = (FileSinkDesc)fsOp.getConf()).isLinkedFileSink()) {
            Map<FileSinkDesc, Task<? extends Serializable>> linkedFileDescTasks = ctx.getLinkedFileDescTasks();
            if (linkedFileDescTasks == null) {
                linkedFileDescTasks = new HashMap<FileSinkDesc, Task<? extends Serializable>>();
                ctx.setLinkedFileDescTasks(linkedFileDescTasks);
            }
            if (currTask.getChildTasks() != null && currTask.getChildTasks().size() == 1) {
                for (FileSinkDesc fileDesc : fileSinkDesc.getLinkedFileSinkDesc()) {
                    linkedFileDescTasks.put(fileDesc, currTask.getChildTasks().get(0));
                }
            }
        }
        if ((fetchTask = parseCtx.getFetchTask()) != null && currTask.getNumChild() == 0 && fetchTask.isFetchFrom(fileSinkDesc)) {
            currTask.setFetchSource(true);
        }
        return true;
    }

    private void processLinkedFileDesc(GenMRProcContext ctx, Task<? extends Serializable> childTask) throws SemanticException {
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        Operator<? extends OperatorDesc> currTopOp = ctx.getCurrTopOp();
        if (currTopOp != null && !ctx.isSeenOp(currTask, currTopOp)) {
            String currAliasId = ctx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx);
        }
        if (childTask != null) {
            currTask.addDependentTask(childTask);
        }
    }

    private Path processFS(FileSinkOperator fsOp, Stack<Node> stack, NodeProcessorCtx opProcCtx, boolean chDir) throws SemanticException {
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        Path dest = null;
        List<FileSinkOperator> seenFSOps = ctx.getSeenFileSinkOps();
        if (seenFSOps == null) {
            seenFSOps = new ArrayList<FileSinkOperator>();
        }
        if (!seenFSOps.contains(fsOp)) {
            seenFSOps.add(fsOp);
        }
        ctx.setSeenFileSinkOps(seenFSOps);
        dest = GenMapRedUtils.createMoveTask(ctx.getCurrTask(), chDir, fsOp, ctx.getParseCtx(), ctx.getMvTask(), ctx.getConf(), ctx.getDependencyTaskForMultiInsert());
        Operator<? extends OperatorDesc> currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        if (currTopOp != null) {
            Task<? extends Serializable> mapTask = opTaskMap.get(null);
            if (mapTask == null) {
                if (!ctx.isSeenOp(currTask, currTopOp)) {
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx);
                }
                opTaskMap.put(null, currTask);
            } else if (!ctx.isSeenOp(currTask, currTopOp)) {
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, mapTask, false, ctx);
            } else {
                UnionOperator currUnionOp = ctx.getCurrUnionOp();
                if (currUnionOp != null) {
                    opTaskMap.put(null, currTask);
                    ctx.setCurrTopOp(null);
                    GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
                    return dest;
                }
            }
            return dest;
        }
        UnionOperator currUnionOp = ctx.getCurrUnionOp();
        if (currUnionOp != null) {
            opTaskMap.put(null, currTask);
            GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
            return dest;
        }
        return dest;
    }
}

