/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDF;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUDFDateString
extends StringUnaryUDF {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorUDFDateString.class.getName());

    public VectorUDFDateString(int colNum, int outputColumn) {
        super(colNum, outputColumn, new StringUnaryUDF.IUDFUnaryString(){
            Text t = new Text();
            final transient SimpleDateFormat formatter = DateUtils.getDateFormat();

            @Override
            public Text evaluate(Text s) {
                if (s == null) {
                    return null;
                }
                try {
                    Date date = this.formatter.parse(s.toString());
                    this.t.set(this.formatter.format(date));
                    return this.t;
                }
                catch (ParseException e) {
                    return null;
                }
            }
        });
    }

    public VectorUDFDateString() {
    }
}

