/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectContainer<ROW> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectContainer.class);
    @VisibleForTesting
    static final int IN_MEMORY_NUM_ROWS = 1024;
    private ROW[] readBuffer = new Object[1024];
    private boolean readBufferUsed = false;
    private int rowsInReadBuffer = 0;
    private int readCursor = 0;
    private int rowsOnDisk = 0;
    private File parentFile;
    private File tmpFile;
    private Input input;
    private Output output;

    public ObjectContainer() {
        for (int i = 0; i < 1024; ++i) {
            this.readBuffer[i] = new Object();
        }
        try {
            this.setupOutput();
        }
        catch (IOException | HiveException e) {
            throw new RuntimeException("Failed to create temporary output file on disk", e);
        }
    }

    private void setupOutput() throws IOException, HiveException {
        FileOutputStream fos = null;
        try {
            if (this.parentFile == null) {
                this.parentFile = File.createTempFile("object-container", "");
                if (this.parentFile.delete() && this.parentFile.mkdir()) {
                    this.parentFile.deleteOnExit();
                }
            }
            if (this.tmpFile == null || this.input != null) {
                this.tmpFile = File.createTempFile("ObjectContainer", ".tmp", this.parentFile);
                LOG.info("ObjectContainer created temp file " + this.tmpFile.getAbsolutePath());
                this.tmpFile.deleteOnExit();
            }
            fos = new FileOutputStream(this.tmpFile);
            this.output = new Output(fos);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        finally {
            if (this.output == null && fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ROW row) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            kryo.writeClassAndObject(this.output, row);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        ++this.rowsOnDisk;
    }

    public void clear() {
        this.rowsOnDisk = 0;
        this.rowsInReadBuffer = 0;
        this.readCursor = 0;
        this.readBufferUsed = false;
        if (this.parentFile != null) {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.input = null;
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.output = null;
            }
            try {
                FileUtil.fullyDelete((File)this.parentFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.parentFile = null;
            this.tmpFile = null;
        }
    }

    public boolean hasNext() {
        return this.readBufferUsed || this.rowsOnDisk > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROW next() {
        block15: {
            Preconditions.checkState(this.hasNext());
            if (!this.readBufferUsed) {
                try {
                    if (this.input == null && this.output != null) {
                        this.output.close();
                        this.output = null;
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(this.tmpFile);
                            this.input = new Input(fis);
                        }
                        finally {
                            if (this.input == null && fis != null) {
                                fis.close();
                            }
                        }
                    }
                    if (this.input == null) break block15;
                    this.rowsInReadBuffer = this.rowsOnDisk >= 1024 ? 1024 : this.rowsOnDisk;
                    Kryo kryo = SerializationUtilities.borrowKryo();
                    try {
                        for (int i = 0; i < this.rowsInReadBuffer; ++i) {
                            this.readBuffer[i] = kryo.readClassAndObject(this.input);
                        }
                    }
                    finally {
                        SerializationUtilities.releaseKryo(kryo);
                    }
                    if (this.input.eof()) {
                        this.input.close();
                        this.input = null;
                    }
                    this.readBufferUsed = true;
                    this.readCursor = 0;
                    this.rowsOnDisk -= this.rowsInReadBuffer;
                }
                catch (Exception e) {
                    this.clear();
                    throw new RuntimeException("Failed to load rows from disk", e);
                }
            }
        }
        ROW row = this.readBuffer[this.readCursor];
        if (++this.readCursor >= this.rowsInReadBuffer) {
            this.readBufferUsed = false;
            this.rowsInReadBuffer = 0;
            this.readCursor = 0;
        }
        return row;
    }

    public int size() {
        return this.rowsInReadBuffer + this.rowsOnDisk;
    }
}

