/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableConf;
import org.apache.hadoop.hive.ql.exec.persistence.KeyValueContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerDirectAccess;
import org.apache.hadoop.hive.ql.exec.persistence.ObjectContainer;
import org.apache.hadoop.hive.ql.exec.persistence.ReusableGetAdaptorDirectAccess;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinRowBytesContainer;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.hive.common.util.BloomFilter;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridHashTableContainer
implements MapJoinTableContainer,
MapJoinTableContainerDirectAccess {
    private static final Logger LOG = LoggerFactory.getLogger(HybridHashTableContainer.class);
    private final HashPartition[] hashPartitions;
    private int totalInMemRowCount = 0;
    private long memoryThreshold;
    private long memoryUsed;
    private final long tableRowSize;
    private boolean isSpilled;
    private int toSpillPartitionId;
    private int numPartitionsSpilled;
    private boolean lastPartitionInMem;
    private final int memoryCheckFrequency;
    private final HybridHashTableConf nwayConf;
    private LazyBinaryStructObjectInspector internalValueOi;
    private boolean[] sortableSortOrders;
    private MapJoinBytesTableContainer.KeyValueHelper writeHelper;
    private final MapJoinBytesTableContainer.DirectKeyValueWriter directWriteHelper;
    private final transient BloomFilter bloom1;
    private final List<Object> EMPTY_LIST = new ArrayList<Object>(0);

    public HybridHashTableContainer(Configuration hconf, long keyCount, long memoryAvailable, long estimatedTableSize, HybridHashTableConf nwayConf) throws SerDeException, IOException {
        this(HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD), HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMEMCHECKFREQ), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINWBSIZE), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEWBSIZE), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINNUMPARTITIONS), HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEMAPJOINOPTIMIZEDTABLEPROBEPERCENT), estimatedTableSize, keyCount, memoryAvailable, nwayConf);
    }

    private HybridHashTableContainer(float keyCountAdj, int threshold, float loadFactor, int memCheckFreq, int minWbSize, int maxWbSize, int minNumParts, float probePercent, long estimatedTableSize, long keyCount, long memoryAvailable, HybridHashTableConf nwayConf) throws SerDeException, IOException {
        int writeBufferSize;
        int numPartitions;
        this.directWriteHelper = new MapJoinBytesTableContainer.DirectKeyValueWriter();
        int newKeyCount = HashMapWrapper.calculateTableSize(keyCountAdj, threshold, loadFactor, keyCount);
        this.memoryThreshold = memoryAvailable;
        this.tableRowSize = estimatedTableSize / (keyCount != 0L ? keyCount : 1L);
        this.memoryCheckFrequency = memCheckFreq;
        this.nwayConf = nwayConf;
        if (nwayConf == null) {
            numPartitions = HybridHashTableContainer.calcNumPartitions(this.memoryThreshold, estimatedTableSize, minNumParts, minWbSize);
            writeBufferSize = (int)(estimatedTableSize / (long)numPartitions);
        } else {
            numPartitions = nwayConf.getNumberOfPartitions();
            if (nwayConf.getLoadedContainerList().size() == 0) {
                writeBufferSize = (int)(estimatedTableSize / (long)numPartitions);
            } else {
                while (this.memoryThreshold < (long)(numPartitions * minWbSize)) {
                    long memFreed = nwayConf.spill();
                    if (memFreed == 0L) {
                        LOG.warn("Available memory is not enough to create HybridHashTableContainers consistently!");
                        break;
                    }
                    LOG.info("Total available memory was: " + this.memoryThreshold);
                    this.memoryThreshold += memFreed;
                    LOG.info("Total available memory is: " + this.memoryThreshold);
                }
                writeBufferSize = (int)(this.memoryThreshold / (long)numPartitions);
            }
        }
        writeBufferSize = Integer.bitCount(writeBufferSize) == 1 ? writeBufferSize : Integer.highestOneBit(writeBufferSize);
        writeBufferSize = writeBufferSize < minWbSize ? minWbSize : Math.min(maxWbSize, writeBufferSize);
        this.bloom1 = new BloomFilter(newKeyCount);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("Using a bloom-1 filter %d keys of size %d bytes", newKeyCount, this.bloom1.sizeInBytes()));
            LOG.info("Write buffer size: " + writeBufferSize);
        }
        this.hashPartitions = new HashPartition[numPartitions];
        int numPartitionsSpilledOnCreation = 0;
        this.memoryUsed = 0L;
        int initialCapacity = Math.max(newKeyCount / numPartitions, threshold / numPartitions);
        float probePercentage = 8.0f / (float)(this.tableRowSize + 8L);
        if (probePercentage == 1.0f) {
            probePercentage = probePercent;
        }
        int maxCapacity = (int)((float)this.memoryThreshold * probePercentage);
        for (int i = 0; i < numPartitions; ++i) {
            this.hashPartitions[i] = this.nwayConf == null || nwayConf.getLoadedContainerList().size() == 0 ? (i == 0 ? new HashPartition(initialCapacity, loadFactor, writeBufferSize, maxCapacity, true) : new HashPartition(initialCapacity, loadFactor, writeBufferSize, maxCapacity, this.memoryUsed + this.hashPartitions[0].hashMap.memorySize() < this.memoryThreshold)) : (this.nwayConf.doSpillOnCreation(i) ? new HashPartition(initialCapacity, loadFactor, writeBufferSize, maxCapacity, false) : new HashPartition(initialCapacity, loadFactor, writeBufferSize, maxCapacity, true));
            if (this.isHashMapSpilledOnCreation(i)) {
                ++numPartitionsSpilledOnCreation;
                ++this.numPartitionsSpilled;
                this.setSpill(true);
                if (this.nwayConf == null || this.nwayConf.getNextSpillPartition() != numPartitions - 1) continue;
                this.nwayConf.setNextSpillPartition(i - 1);
                continue;
            }
            this.memoryUsed += this.hashPartitions[i].hashMap.memorySize();
        }
        assert (numPartitionsSpilledOnCreation != numPartitions) : "All partitions are directly spilled! It is not supported now.";
        LOG.info("Number of partitions created: " + numPartitions);
        LOG.info("Number of partitions spilled directly to disk on creation: " + numPartitionsSpilledOnCreation);
        if (this.nwayConf != null) {
            this.nwayConf.getLoadedContainerList().add(this);
        }
    }

    public MapJoinBytesTableContainer.KeyValueHelper getWriteHelper() {
        return this.writeHelper;
    }

    public HashPartition[] getHashPartitions() {
        return this.hashPartitions;
    }

    public long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long refreshMemoryUsed() {
        long memUsed = 0L;
        for (HashPartition hp : this.hashPartitions) {
            if (hp.hashMap == null) continue;
            memUsed += hp.hashMap.memorySize();
        }
        this.memoryUsed = memUsed;
        return this.memoryUsed;
    }

    public LazyBinaryStructObjectInspector getInternalValueOi() {
        return this.internalValueOi;
    }

    public boolean[] getSortableSortOrders() {
        return this.sortableSortOrders;
    }

    @Override
    public MapJoinKey putRow(Writable currentKey, Writable currentValue) throws SerDeException, HiveException, IOException {
        this.writeHelper.setKeyValue(currentKey, currentValue);
        return this.internalPutRow(this.writeHelper, currentKey, currentValue);
    }

    private MapJoinKey internalPutRow(MapJoinBytesTableContainer.KeyValueHelper keyValueHelper, Writable currentKey, Writable currentValue) throws SerDeException, IOException {
        int keyHash = keyValueHelper.getHashFromKey();
        int partitionId = keyHash & this.hashPartitions.length - 1;
        HashPartition hashPartition = this.hashPartitions[partitionId];
        this.bloom1.addLong(keyHash);
        if (this.isOnDisk(partitionId) || this.isHashMapSpilledOnCreation(partitionId)) {
            KeyValueContainer kvContainer = hashPartition.getSidefileKVContainer();
            kvContainer.add((HiveKey)currentKey, (BytesWritable)currentValue);
        } else {
            hashPartition.hashMap.put(keyValueHelper, keyHash);
            ++this.totalInMemRowCount;
            if ((this.totalInMemRowCount & this.memoryCheckFrequency - 1) == 0 && !this.lastPartitionInMem && this.isMemoryFull()) {
                if (this.numPartitionsSpilled == this.hashPartitions.length - 1) {
                    LOG.warn("This LAST partition in memory won't be spilled!");
                    this.lastPartitionInMem = true;
                } else {
                    if (this.nwayConf == null) {
                        int biggest = this.biggestPartition();
                        this.spillPartition(biggest);
                        this.setSpill(true);
                    } else {
                        LOG.info("N-way spilling: spill tail partition from previously loaded small tables");
                        this.memoryThreshold += this.nwayConf.spill();
                        LOG.info("Memory threshold has been increased to: " + this.memoryThreshold);
                    }
                    ++this.numPartitionsSpilled;
                }
            }
        }
        return null;
    }

    public boolean isOnDisk(int partitionId) {
        return this.hashPartitions[partitionId].hashMapOnDisk;
    }

    public boolean isHashMapSpilledOnCreation(int partitionId) {
        return this.hashPartitions[partitionId].hashMapSpilledOnCreation;
    }

    private boolean isMemoryFull() {
        return this.refreshMemoryUsed() >= this.memoryThreshold;
    }

    private int biggestPartition() {
        int res = 0;
        int maxSize = 0;
        for (int i = 0; i < this.hashPartitions.length; ++i) {
            int size;
            if (this.isOnDisk(i) || (size = this.hashPartitions[i].hashMap.getNumValues()) <= maxSize) continue;
            maxSize = size;
            res = i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long spillPartition(int partitionId) throws IOException {
        HashPartition partition = this.hashPartitions[partitionId];
        int inMemRowCount = partition.hashMap.getNumValues();
        Path path = Files.createTempFile("partition-" + partitionId + "-", null, new FileAttribute[0]);
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        Output output = new Output(outputStream);
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            kryo.writeObject(output, partition.hashMap);
            output.close();
            outputStream.close();
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        partition.hashMapLocalPath = path;
        partition.hashMapOnDisk = true;
        LOG.info("Spilling hash partition " + partitionId + " (Rows: " + inMemRowCount + ", Mem size: " + partition.hashMap.memorySize() + "): " + path);
        LOG.info("Memory usage before spilling: " + this.memoryUsed);
        long memFreed = partition.hashMap.memorySize();
        this.memoryUsed -= memFreed;
        LOG.info("Memory usage after spilling: " + this.memoryUsed);
        partition.rowsOnDisk = inMemRowCount;
        this.totalInMemRowCount -= inMemRowCount;
        partition.hashMap.clear();
        return memFreed;
    }

    public static int calcNumPartitions(long memoryThreshold, long dataSize, int minNumParts, int minWbSize) throws IOException {
        int numPartitions = minNumParts;
        if (memoryThreshold < (long)(minNumParts * minWbSize)) {
            LOG.warn("Available memory is not enough to create a HybridHashTableContainer!");
        }
        if (memoryThreshold < dataSize) {
            while (dataSize / (long)numPartitions > memoryThreshold) {
                numPartitions *= 2;
            }
        }
        LOG.info("Total available memory: " + memoryThreshold);
        LOG.info("Estimated small table size: " + dataSize);
        LOG.info("Number of hash partitions to be created: " + numPartitions);
        return numPartitions;
    }

    public int getNumPartitions() {
        return this.hashPartitions.length;
    }

    public int getTotalInMemRowCount() {
        return this.totalInMemRowCount;
    }

    public void setTotalInMemRowCount(int totalInMemRowCount) {
        this.totalInMemRowCount = totalInMemRowCount;
    }

    public long getTableRowSize() {
        return this.tableRowSize;
    }

    @Override
    public boolean hasSpill() {
        return this.isSpilled;
    }

    public void setSpill(boolean isSpilled) {
        this.isSpilled = isSpilled;
    }

    public int getToSpillPartitionId() {
        return this.toSpillPartitionId;
    }

    @Override
    public void clear() {
        for (HashPartition hp : this.hashPartitions) {
            if (hp == null) continue;
            hp.clear();
        }
        this.memoryUsed = 0L;
    }

    @Override
    public MapJoinKey getAnyKey() {
        return null;
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        if (keyTypeFromLoader != null) {
            throw new AssertionError((Object)("No key expected from loader but got " + keyTypeFromLoader));
        }
        return new GetAdaptor();
    }

    @Override
    public void seal() {
        for (HashPartition hp : this.hashPartitions) {
            if (hp.hashMap == null || hp.hashMap.size() == 0) continue;
            hp.hashMap.seal();
        }
    }

    @Override
    public void put(Writable currentKey, Writable currentValue) throws SerDeException, IOException {
        this.directWriteHelper.setKeyValue(currentKey, currentValue);
        this.internalPutRow(this.directWriteHelper, currentKey, currentValue);
    }

    @Override
    public void dumpMetrics() {
        for (int i = 0; i < this.hashPartitions.length; ++i) {
            HashPartition hp = this.hashPartitions[i];
            if (hp.hashMap == null) continue;
            hp.hashMap.debugDumpMetrics();
        }
    }

    public void dumpStats() {
        int numPartitionsInMem = 0;
        int numPartitionsOnDisk = 0;
        for (HashPartition hp : this.hashPartitions) {
            if (hp.isHashMapOnDisk()) {
                ++numPartitionsOnDisk;
                continue;
            }
            ++numPartitionsInMem;
        }
        LOG.info("In memory partitions have been processed successfully: " + numPartitionsInMem + " partitions in memory have been processed; " + numPartitionsOnDisk + " partitions have been spilled to disk and will be processed next.");
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (HashPartition hashPartition : this.hashPartitions) {
            totalSize += hashPartition.size();
        }
        return totalSize;
    }

    @Override
    public void setSerde(MapJoinObjectSerDeContext keyCtx, MapJoinObjectSerDeContext valCtx) throws SerDeException {
        SerDe keySerde = keyCtx.getSerDe();
        SerDe valSerde = valCtx.getSerDe();
        if (this.writeHelper == null) {
            LOG.info("Initializing container with " + keySerde.getClass().getName() + " and " + valSerde.getClass().getName());
            LazyBinaryStructObjectInspector valSoi = (LazyBinaryStructObjectInspector)valSerde.getObjectInspector();
            this.writeHelper = new MapJoinBytesTableContainer.LazyBinaryKvWriter(keySerde, valSoi, valCtx.hasFilterTag());
            if (this.internalValueOi == null) {
                this.internalValueOi = valSoi;
            }
            if (this.sortableSortOrders == null) {
                this.sortableSortOrders = ((BinarySortableSerDe)keySerde).getSortOrders();
            }
        }
    }

    private class ReusableRowContainer
    implements MapJoinRowContainer,
    AbstractRowContainer.RowIterator<List<Object>> {
        private byte aliasFilter;
        private final BytesBytesMultiHashMap.Result hashMapResult;
        private List<Object> dummyRow = null;
        private final ByteArrayRef uselessIndirection;
        private final LazyBinaryStruct valueStruct;
        private final boolean needsComplexObjectFixup;
        private final ArrayList<Object> complexObjectArrayBuffer;
        private int partitionId;

        public ReusableRowContainer() {
            if (HybridHashTableContainer.this.internalValueOi != null) {
                this.valueStruct = (LazyBinaryStruct)LazyBinaryFactory.createLazyBinaryObject(HybridHashTableContainer.this.internalValueOi);
                this.needsComplexObjectFixup = MapJoinBytesTableContainer.hasComplexObjects(HybridHashTableContainer.this.internalValueOi);
                this.complexObjectArrayBuffer = this.needsComplexObjectFixup ? new ArrayList<Object>(Collections.nCopies(HybridHashTableContainer.this.internalValueOi.getAllStructFieldRefs().size(), null)) : null;
            } else {
                this.valueStruct = null;
                this.needsComplexObjectFixup = false;
                this.complexObjectArrayBuffer = null;
            }
            this.uselessIndirection = new ByteArrayRef();
            this.hashMapResult = new BytesBytesMultiHashMap.Result();
            this.clearRows();
        }

        public JoinUtil.JoinResult setFromOutput(ByteStream.Output output) throws HiveException {
            int keyHash = HashCodeUtil.murmurHash(output.getData(), 0, output.getLength());
            if (!HybridHashTableContainer.this.bloom1.testLong(keyHash)) {
                this.dummyRow = null;
                this.aliasFilter = (byte)-1;
                this.hashMapResult.forget();
                return JoinUtil.JoinResult.NOMATCH;
            }
            this.partitionId = keyHash & HybridHashTableContainer.this.hashPartitions.length - 1;
            if (HybridHashTableContainer.this.isOnDisk(this.partitionId)) {
                HybridHashTableContainer.this.toSpillPartitionId = this.partitionId;
                this.hashMapResult.forget();
                return JoinUtil.JoinResult.SPILL;
            }
            this.aliasFilter = ((HybridHashTableContainer)HybridHashTableContainer.this).hashPartitions[this.partitionId].hashMap.getValueResult(output.getData(), 0, output.getLength(), this.hashMapResult);
            this.dummyRow = null;
            if (this.hashMapResult.hasRows()) {
                return JoinUtil.JoinResult.MATCH;
            }
            this.aliasFilter = (byte)-1;
            return JoinUtil.JoinResult.NOMATCH;
        }

        @Override
        public boolean hasRows() {
            return this.hashMapResult.hasRows() || this.dummyRow != null;
        }

        @Override
        public boolean isSingleRow() {
            if (!this.hashMapResult.hasRows()) {
                return this.dummyRow != null;
            }
            return this.hashMapResult.isSingleRow();
        }

        @Override
        public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
            return this;
        }

        @Override
        public int rowCount() throws HiveException {
            throw new UnsupportedOperationException("Getting the row count not supported");
        }

        @Override
        public void clearRows() {
            this.hashMapResult.forget();
            this.dummyRow = null;
            this.aliasFilter = (byte)-1;
        }

        @Override
        public byte getAliasFilter() throws HiveException {
            return this.aliasFilter;
        }

        @Override
        public MapJoinRowContainer copy() throws HiveException {
            return this;
        }

        @Override
        public List<Object> first() throws HiveException {
            if (this.dummyRow != null) {
                List<Object> result = this.dummyRow;
                this.dummyRow = null;
                return result;
            }
            WriteBuffers.ByteSegmentRef byteSegmentRef = this.hashMapResult.first();
            if (byteSegmentRef == null) {
                return null;
            }
            return this.unpack(byteSegmentRef);
        }

        @Override
        public List<Object> next() throws HiveException {
            WriteBuffers.ByteSegmentRef byteSegmentRef = this.hashMapResult.next();
            if (byteSegmentRef == null) {
                return null;
            }
            return this.unpack(byteSegmentRef);
        }

        private List<Object> unpack(WriteBuffers.ByteSegmentRef ref) throws HiveException {
            if (ref.getLength() == 0) {
                return HybridHashTableContainer.this.EMPTY_LIST;
            }
            this.uselessIndirection.setData(ref.getBytes());
            this.valueStruct.init(this.uselessIndirection, (int)ref.getOffset(), ref.getLength());
            List<Object> result = !this.needsComplexObjectFixup ? this.valueStruct.getFieldsAsList() : MapJoinBytesTableContainer.getComplexFieldsAsList(this.valueStruct, this.complexObjectArrayBuffer, HybridHashTableContainer.this.internalValueOi);
            return result;
        }

        @Override
        public void addRow(List<Object> t) {
            if (this.dummyRow != null || this.hashMapResult.hasRows()) {
                throw new RuntimeException("Cannot add rows when not empty");
            }
            this.dummyRow = t;
        }

        @Override
        public void addRow(Object[] value) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot add arrays");
        }

        @Override
        public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot be serialized");
        }

        public JoinUtil.JoinResult setDirect(byte[] bytes, int offset, int length, BytesBytesMultiHashMap.Result hashMapResult) {
            int keyHash = HashCodeUtil.murmurHash(bytes, offset, length);
            this.partitionId = keyHash & HybridHashTableContainer.this.hashPartitions.length - 1;
            if (!HybridHashTableContainer.this.bloom1.testLong(keyHash)) {
                this.dummyRow = null;
                this.aliasFilter = (byte)-1;
                hashMapResult.forget();
                return JoinUtil.JoinResult.NOMATCH;
            }
            if (HybridHashTableContainer.this.isOnDisk(this.partitionId)) {
                return JoinUtil.JoinResult.SPILL;
            }
            this.aliasFilter = ((HybridHashTableContainer)HybridHashTableContainer.this).hashPartitions[this.partitionId].hashMap.getValueResult(bytes, offset, length, hashMapResult);
            this.dummyRow = null;
            if (hashMapResult.hasRows()) {
                return JoinUtil.JoinResult.MATCH;
            }
            this.aliasFilter = (byte)-1;
            return JoinUtil.JoinResult.NOMATCH;
        }

        public int directSpillPartitionId() {
            return this.partitionId;
        }
    }

    private class GetAdaptor
    implements MapJoinTableContainer.ReusableGetAdaptor,
    ReusableGetAdaptorDirectAccess {
        private Object[] currentKey;
        private boolean[] nulls;
        private List<ObjectInspector> vectorKeyOIs;
        private final ReusableRowContainer currentValue;
        private final ByteStream.Output output;

        public GetAdaptor() {
            this.currentValue = new ReusableRowContainer();
            this.output = new ByteStream.Output();
        }

        @Override
        public JoinUtil.JoinResult setFromVector(VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException {
            int i;
            if (this.nulls == null) {
                this.nulls = new boolean[keyOutputWriters.length];
                this.currentKey = new Object[keyOutputWriters.length];
                this.vectorKeyOIs = new ArrayList<ObjectInspector>();
                for (i = 0; i < keyOutputWriters.length; ++i) {
                    this.vectorKeyOIs.add(keyOutputWriters[i].getObjectInspector());
                }
            } else assert (this.nulls.length == keyOutputWriters.length);
            for (i = 0; i < keyOutputWriters.length; ++i) {
                this.currentKey[i] = keyWrapperBatch.getWritableKeyValue(kw, i, keyOutputWriters[i]);
                this.nulls[i] = this.currentKey[i] == null;
            }
            return this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, this.vectorKeyOIs, HybridHashTableContainer.this.sortableSortOrders));
        }

        @Override
        public JoinUtil.JoinResult setFromRow(Object row, List<ExprNodeEvaluator> fields, List<ObjectInspector> ois) throws HiveException {
            if (this.nulls == null) {
                this.nulls = new boolean[fields.size()];
                this.currentKey = new Object[fields.size()];
            }
            for (int keyIndex = 0; keyIndex < fields.size(); ++keyIndex) {
                this.currentKey[keyIndex] = fields.get(keyIndex).evaluate(row);
                this.nulls[keyIndex] = this.currentKey[keyIndex] == null;
            }
            return this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, ois, HybridHashTableContainer.this.sortableSortOrders));
        }

        @Override
        public JoinUtil.JoinResult setFromOther(MapJoinTableContainer.ReusableGetAdaptor other) throws HiveException {
            assert (other instanceof GetAdaptor);
            GetAdaptor other2 = (GetAdaptor)other;
            this.nulls = other2.nulls;
            this.currentKey = other2.currentKey;
            return this.currentValue.setFromOutput(other2.output);
        }

        @Override
        public boolean hasAnyNulls(int fieldCount, boolean[] nullsafes) {
            if (this.nulls == null || this.nulls.length == 0) {
                return false;
            }
            for (int i = 0; i < this.nulls.length; ++i) {
                if (!this.nulls[i] || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapJoinRowContainer getCurrentRows() {
            return !this.currentValue.hasRows() ? null : this.currentValue;
        }

        @Override
        public Object[] getCurrentKey() {
            return this.currentKey;
        }

        @Override
        public JoinUtil.JoinResult setDirect(byte[] bytes, int offset, int length, BytesBytesMultiHashMap.Result hashMapResult) {
            return this.currentValue.setDirect(bytes, offset, length, hashMapResult);
        }

        @Override
        public int directSpillPartitionId() {
            return this.currentValue.directSpillPartitionId();
        }
    }

    public static class HashPartition {
        BytesBytesMultiHashMap hashMap;
        KeyValueContainer sidefileKVContainer;
        ObjectContainer matchfileObjContainer;
        VectorMapJoinRowBytesContainer matchfileRowBytesContainer;
        Path hashMapLocalPath;
        boolean hashMapOnDisk;
        boolean hashMapSpilledOnCreation;
        int initialCapacity;
        float loadFactor;
        int wbSize;
        int rowsOnDisk;

        public HashPartition(int initialCapacity, float loadFactor, int wbSize, long maxProbeSize, boolean createHashMap) {
            if (createHashMap) {
                maxProbeSize = Math.max(maxProbeSize, (long)wbSize);
                this.hashMap = new BytesBytesMultiHashMap(initialCapacity, loadFactor, wbSize, maxProbeSize);
            } else {
                this.hashMapSpilledOnCreation = true;
                this.hashMapOnDisk = true;
            }
            this.initialCapacity = initialCapacity;
            this.loadFactor = loadFactor;
            this.wbSize = wbSize;
        }

        public BytesBytesMultiHashMap getHashMapFromMemory() {
            return this.hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BytesBytesMultiHashMap getHashMapFromDisk(int rowCount) throws IOException, ClassNotFoundException {
            if (this.hashMapSpilledOnCreation) {
                return new BytesBytesMultiHashMap(rowCount, this.loadFactor, this.wbSize, -1L);
            }
            InputStream inputStream = Files.newInputStream(this.hashMapLocalPath, new OpenOption[0]);
            Input input = new Input(inputStream);
            Kryo kryo = SerializationUtilities.borrowKryo();
            BytesBytesMultiHashMap restoredHashMap = null;
            try {
                restoredHashMap = kryo.readObject(input, BytesBytesMultiHashMap.class);
            }
            finally {
                SerializationUtilities.releaseKryo(kryo);
            }
            if (rowCount > 0) {
                restoredHashMap.expandAndRehashToTarget(rowCount);
            }
            this.rowsOnDisk = 0;
            this.hashMapOnDisk = false;
            input.close();
            inputStream.close();
            Files.delete(this.hashMapLocalPath);
            return restoredHashMap;
        }

        public KeyValueContainer getSidefileKVContainer() {
            if (this.sidefileKVContainer == null) {
                this.sidefileKVContainer = new KeyValueContainer();
            }
            return this.sidefileKVContainer;
        }

        public ObjectContainer getMatchfileObjContainer() {
            if (this.matchfileObjContainer == null) {
                this.matchfileObjContainer = new ObjectContainer();
            }
            return this.matchfileObjContainer;
        }

        public VectorMapJoinRowBytesContainer getMatchfileRowBytesContainer() {
            if (this.matchfileRowBytesContainer == null) {
                this.matchfileRowBytesContainer = new VectorMapJoinRowBytesContainer();
            }
            return this.matchfileRowBytesContainer;
        }

        public boolean isHashMapOnDisk() {
            return this.hashMapOnDisk;
        }

        public void clear() {
            if (this.hashMap != null) {
                this.hashMap.clear();
                this.hashMap = null;
            }
            if (this.hashMapLocalPath != null) {
                try {
                    Files.delete(this.hashMapLocalPath);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.hashMapLocalPath = null;
                this.rowsOnDisk = 0;
                this.hashMapOnDisk = false;
            }
            if (this.sidefileKVContainer != null) {
                this.sidefileKVContainer.clear();
                this.sidefileKVContainer = null;
            }
            if (this.matchfileObjContainer != null) {
                this.matchfileObjContainer.clear();
                this.matchfileObjContainer = null;
            }
            if (this.matchfileRowBytesContainer != null) {
                this.matchfileRowBytesContainer.clear();
                this.matchfileRowBytesContainer = null;
            }
        }

        public int size() {
            if (this.isHashMapOnDisk()) {
                return this.rowsOnDisk + (this.sidefileKVContainer != null ? this.sidefileKVContainer.size() : 0);
            }
            return this.hashMap.size();
        }
    }
}

