/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;

public class DecimalColumnStatsAggregator
implements ColumnStatsAggregator {
    @Override
    public void aggregate(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        DecimalColumnStatsData aggregateData = aggregateColStats.getStatsData().getDecimalStats();
        DecimalColumnStatsData newData = newColStats.getStatsData().getDecimalStats();
        Decimal lowValue = aggregateData.getLowValue().compareTo(newData.getLowValue()) > 0 ? aggregateData.getLowValue() : newData.getLowValue();
        aggregateData.setLowValue(lowValue);
        Decimal highValue = aggregateData.getHighValue().compareTo(newData.getHighValue()) > 0 ? aggregateData.getHighValue() : newData.getHighValue();
        aggregateData.setHighValue(highValue);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
    }
}

